/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.ContextBridge;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.pkg.sso.db.SsoUserDao;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoContextDao
extends BaseDao {
    private SsoUserDao ssoUserDao;
    private ParameterizedRowMapper<Context> contextMapper;
    private ParameterizedRowMapper<ContextBridge> contextBridgeMapper;
    private NyxManager nyxManager;
    private Map<Long, Context> cashe = new HashMap<Long, Context>();

    protected SsoContextDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate, SsoUserDao ssoUserDao) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.ssoUserDao = ssoUserDao;
        this.contextMapper = new DefaultParameterizedRowMapper<Context>(){

            public Context mapRow(ResultSet rs, int rowNum) throws SQLException {
                Context ret = new Context();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setContextCode(rs.getLong("context_code"));
                ret.setContextType(rs.getString("context_type"));
                ret.setContextName(rs.getString("context_name"));
                SsoContextDao.this.cashe.put(ret.getContextCode(), ret);
                return ret;
            }
        };
        this.contextBridgeMapper = new DefaultParameterizedRowMapper<ContextBridge>(){

            public ContextBridge mapRow(ResultSet rs, int rowNum) throws SQLException {
                ContextBridge ret = new ContextBridge();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setContextCode(rs.getLong("context_code"));
                ret.setParentContextCode(rs.getLong("parent_context_code"));
                return ret;
            }
        };
    }

    public Context loadContext(long contextCode, Access access) throws SQLException {
        return this.loadContext(contextCode, access, false);
    }

    public Context loadContext(long contextCode, Access access, boolean loadBridgedUser) throws SQLException {
        Context ret;
        block17: {
            Set bridges;
            List bridgeIds;
            block16: {
                if (this.cashe.containsKey(contextCode)) {
                    return this.cashe.get(contextCode);
                }
                List ext = this.simpleTemplate.query("select * from m_context_ext where context_code=?", this.extMapper, new Object[]{contextCode});
                ret = (Context)this.simpleTemplate.queryForObject("select * from m_context where context_code=?", this.contextMapper, new Object[]{contextCode});
                Map map = ret.getExt();
                for (Ext ex : ext) {
                    map.put(ex.getFieldName(), ex);
                }
                List userIds = this.loadString("user_id", "m_context_user", "context_code", contextCode);
                Set user = ret.getUser();
                for (String i : userIds) {
                    if (access == null) {
                        user.add(this.ssoUserDao.loadUser(i));
                        continue;
                    }
                    user.add(this.ssoUserDao.loadUser(i, access));
                }
                List ownerIds = this.loadString("user_id", "m_context_owner", "context_code", contextCode);
                Set owner = ret.getOwner();
                for (String i : ownerIds) {
                    if (access == null) {
                        owner.add(this.ssoUserDao.loadUser(i));
                        continue;
                    }
                    owner.add(this.ssoUserDao.loadUser(i, access));
                }
                if (!Context.ContextType.NESTED.getValue().equals(ret.getContextType())) break block16;
                bridgeIds = this.loadLong("context_code", "m_context_bridge", "parent_context_code", contextCode);
                bridges = ret.getBridge();
                for (Long i : bridgeIds) {
                    try {
                        ContextBridge b = this.loadContextBridge(contextCode, i);
                        bridges.add(b);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Load ContextBridge failed,(parentCode:" + i + ",childeCode:" + contextCode + ")"), (Throwable)e);
                    }
                }
                if (!loadBridgedUser) break block17;
                List bridgeUserIds = this.loadString("user_id", "m_context_bridge b inner join m_context_user u on (b.context_code=u.context_code)", "b.parent_context_code", contextCode);
                for (String i : bridgeUserIds) {
                    if (access == null) {
                        user.add(this.ssoUserDao.loadUser(i));
                        continue;
                    }
                    user.add(this.ssoUserDao.loadUser(i, access));
                }
                List bridgeOwnerIds = this.loadString("user_id", "m_context_bridge b inner join m_context_owner u on (b.context_code=u.context_code)", "b.parent_context_code", contextCode);
                for (String i : bridgeOwnerIds) {
                    if (access == null) {
                        owner.add(this.ssoUserDao.loadUser(i));
                        continue;
                    }
                    owner.add(this.ssoUserDao.loadUser(i, access));
                }
                break block17;
            }
            bridgeIds = this.loadLong("parent_context_code", "m_context_bridge", "context_code", contextCode);
            bridges = ret.getBridge();
            for (Long i : bridgeIds) {
                try {
                    ContextBridge b = this.loadContextBridge(i, contextCode);
                    bridges.add(b);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Load ContextBridge failed,(parentCode:" + i + ",childeCode:" + contextCode + ")"), (Throwable)e);
                }
            }
        }
        return ret;
    }

    public Set<Context> loadContextUser(String userId, int offset, int limit, Access access) throws SQLException {
        List ids = this.loadLong("context_code", "v_context_user", "user_id", userId, offset, limit);
        if (ids.size() <= 0) {
            return new TreeSet<Context>();
        }
        TreeSet<Context> ret = new TreeSet<Context>();
        for (Long i : ids) {
            ret.add(this.loadContext(i, access));
        }
        return ret;
    }

    public List<Context> loadContext(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadLong("context_code", "m_context", conditions, offset, limit, "context_name");
        if (ids.size() <= 0) {
            return new ArrayList<Context>();
        }
        ArrayList<Context> ret = new ArrayList<Context>();
        for (Long i : ids) {
            ret.add(this.loadContext(i, conditions.getAccess()));
        }
        return ret;
    }

    protected ContextBridge loadContextBridge(long parentContextCode, long contextCode) throws SQLException {
        ContextBridge ret = (ContextBridge)this.simpleTemplate.queryForObject("select * from m_context_bridge where context_code=? and parent_context_code=?", this.contextBridgeMapper, new Object[]{contextCode, parentContextCode});
        String context_name = (String)this.simpleTemplate.queryForObject("select context_name as \"context_name\" from m_context where context_code=?", this.stringMapper, new Object[]{parentContextCode});
        ret.setParentContextName(context_name);
        context_name = (String)this.simpleTemplate.queryForObject("select context_name as \"context_name\" from m_context where context_code=?", this.stringMapper, new Object[]{contextCode});
        ret.setContextName(context_name);
        return ret;
    }

    private void saveContextBridge(Context context) throws SQLException {
        if (Context.ContextType.NESTED.getValue().equals(context.getContextType())) {
            for (ContextBridge cb : context.getBridge()) {
                String contextType = (String)this.simpleTemplate.queryForObject("select context_type from m_context where context_code=?", this.stringMapper, new Object[]{cb.getContextCode()});
                if (!Context.ContextType.NESTED.getValue().equals(contextType)) continue;
                throw new SQLException("It tried to add the parents context to the parents context.");
            }
            this.saveRef("m_context_bridge", "context_code", "contextCode", "parent_context_code", context.getContextCode(), context.getBridge(), (DefaultModel)context);
        } else {
            for (ContextBridge cb : context.getBridge()) {
                String contextType = (String)this.simpleTemplate.queryForObject("select context_type from m_context where context_code=?", this.stringMapper, new Object[]{cb.getParentContextCode()});
                if (Context.ContextType.NESTED.getValue().equals(contextType)) continue;
                throw new SQLException("It tried to add the child context to parents of the child context.");
            }
            this.saveRef("m_context_bridge", "parent_context_code", "parentContextCode", "context_code", context.getContextCode(), context.getBridge(), (DefaultModel)context);
        }
    }

    public void saveContext(Context context) throws SQLException {
        int r = this.namedTemplate.update("update m_context set context_type=:contextType ,context_name=:contextName where context_code=:contextCode", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)context));
        if (r > 0) {
            this.saveExt("m_context_ext", "context_code", context.getContextCode(), context.getExt(), (DefaultModel)context);
            this.saveRef("m_context_owner", "user_id", "userId", "context_code", context.getContextCode(), context.getOwner(), (DefaultModel)context);
            this.saveRef("m_context_user", "user_id", "userId", "context_code", context.getContextCode(), context.getUser(), (DefaultModel)context);
            this.saveContextBridge(context);
            this.saveSsoDefault("m_context", "context_code", context.getContextCode(), (DefaultModel)context);
            return;
        }
        long seq = this.nextSequence("m_context_context_code_seq");
        context.setContextCode(seq);
        this.namedTemplate.update("insert into m_context(context_code, context_type, context_name) values(:contextCode, :contextType, :contextName)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)context));
        this.saveExt("m_context_ext", "context_code", context.getContextCode(), context.getExt(), (DefaultModel)context);
        this.saveRef("m_context_owner", "user_id", "userId", "context_code", context.getContextCode(), context.getOwner(), (DefaultModel)context);
        this.saveRef("m_context_user", "user_id", "userId", "context_code", context.getContextCode(), context.getUser(), (DefaultModel)context);
        this.saveContextBridge(context);
        this.saveSsoDefault("m_context", "context_code", context.getContextCode(), (DefaultModel)context);
    }

    public void deleteContext(long context_code) {
        this.simpleTemplate.update("delete from m_context_ext where context_code=?", new Object[]{context_code});
        this.simpleTemplate.update("delete from m_context_owner where context_code=?", new Object[]{context_code});
        this.simpleTemplate.update("delete from m_context_user where context_code=?", new Object[]{context_code});
        this.simpleTemplate.update("delete from m_context_bridge where context_code=?", new Object[]{context_code});
        this.simpleTemplate.update("delete from m_context where context_code=?", new Object[]{context_code});
    }

    public void clearCashe() {
        this.cashe.clear();
    }

    public boolean isDerby() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return !"postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }

    public boolean isPostgreSQL() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return "postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }
}

