/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.pkg.sso.db.model.PortalNotice;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoPortalNoticeDao
extends BaseDao {
    private ParameterizedRowMapper<PortalNotice> portalNoticeMapper;
    private NyxManager nyxManager;

    protected SsoPortalNoticeDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate) {
        super(simpleTemplate, namedTemplate);
        if (nyxManager == null) {
            throw new NullPointerException("nyxManager is null.");
        }
        this.nyxManager = nyxManager;
        this.portalNoticeMapper = new DefaultParameterizedRowMapper<PortalNotice>(){

            public PortalNotice mapRow(ResultSet rs, int rowNum) throws SQLException {
                PortalNotice ret = new PortalNotice();
                ret.setSeq(rs.getInt("seq"));
                ret.setUserId(rs.getString("user_id"));
                ret.setUserName(rs.getString("user_name"));
                ret.setFromUserId(rs.getString("from_user_id"));
                ret.setFromUserName(rs.getString("from_user_name"));
                ret.setDisplayType(rs.getString("display_type"));
                ret.setDisplayStart(rs.getTimestamp("display_start"));
                ret.setDisplayEnd(rs.getTimestamp("display_end"));
                ret.setDisplayMode(rs.getString("display_mode"));
                ret.setNoticeDate(rs.getTimestamp("notice_date"));
                ret.setReceiveDate(rs.getTimestamp("receive_date"));
                ret.setUrl(rs.getString("url"));
                ret.setTitle(rs.getString("title"));
                ret.setMessage(rs.getString("message"));
                ret.setEnableTo("t".equals(rs.getString("enable_to")));
                ret.setEnableFrom("t".equals(rs.getString("enable_from")));
                return ret;
            }
        };
    }

    public List<PortalNotice> loadPortalNotice(String user_id, String display_type, Timestamp display_start, Timestamp display_end, String display_mode) {
        List ret = this.simpleTemplate.query("select n.*, u1.user_name, u2.user_name as from_user_name from m_portal_notice n left join m_user u1 on (n.user_id=u1.user_id) left join m_user u2 on (n.from_user_id=u2.user_id) where n.user_id=? and display_type=? and (display_start is null or display_start<=?) and (display_end is null or display_end>=?) and display_mode=? order by seq", this.portalNoticeMapper, new Object[]{txtUtil.nvl(user_id), display_type, display_start, display_end, display_mode});
        return ret;
    }

    public PortalNotice loadPortalNotice(long seq) {
        return (PortalNotice)this.simpleTemplate.queryForObject("select n.*, u1.user_name, u2.user_name as from_user_name from m_portal_notice n left join m_user u1 on (n.user_id=u1.user_id) left join m_user u2 on (n.from_user_id=u2.user_id) where seq=? ", this.portalNoticeMapper, new Object[]{seq});
    }

    public List<PortalNotice> loadPortalNotice(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadLong("seq", "(select n.*, u1.user_name, u2.user_name as from_user_name from m_portal_notice n left join m_user u1 on (n.user_id=u1.user_id) left join m_user u2 on (n.from_user_id=u2.user_id) ) notice ", conditions, offset, limit, "seq desc");
        if (ids.size() <= 0) {
            return new ArrayList<PortalNotice>();
        }
        ArrayList<PortalNotice> ret = new ArrayList<PortalNotice>();
        for (Long i : ids) {
            ret.add(this.loadPortalNotice(i));
        }
        return ret;
    }

    public List<Long> loadPortalNoticeSeq(ConditionList conditions) throws SQLException {
        return this.loadLong("seq", "(select n.*, u1.user_name, u2.user_name as from_user_name from m_portal_notice n left join m_user u1 on (n.user_id=u1.user_id) left join m_user u2 on (n.from_user_id=u2.user_id) ) notice ", conditions, 0, 10000, "seq desc");
    }

    public void savePortalNotice(PortalNotice notice) throws SQLException {
        this.savePortalNotice(notice, false);
    }

    public void savePortalNotice(PortalNotice notice, boolean forceAdd) throws SQLException {
        int r;
        if (!forceAdd && (r = this.namedTemplate.update("update m_portal_notice set user_id=:userId ,from_user_id=:fromUserId" + txtUtil.getEmpty((Object)notice.getDisplayType(), ",display_type=:displayType") + txtUtil.getEmpty((Object)notice.getDisplayStart(), ",display_start=:displayStart") + txtUtil.getEmpty((Object)notice.getDisplayEnd(), ",display_end=:displayEnd") + txtUtil.getEmpty((Object)notice.getDisplayMode(), ",display_mode=:displayMode") + txtUtil.getEmpty((Object)notice.getNoticeDate(), ",notice_date=:noticeDate") + txtUtil.getEmpty((Object)notice.getReceiveDate(), ",receive_date=:receiveDate") + txtUtil.getEmpty((Object)notice.getUrl(), ",url=:url") + txtUtil.getEmpty((Object)notice.getTitle(), ",title=:title") + txtUtil.getEmpty((Object)notice.getMessage(), ",message=:message") + ",enable_to=:enableToString ,enable_from=:enableFromString where seq=:seq", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)notice))) > 0) {
            return;
        }
        long seq = this.nextSequence("m_portal_notice_seq");
        notice.setSeq(seq);
        this.namedTemplate.update("insert into m_portal_notice(seq, user_id, from_user_id" + txtUtil.getEmpty((Object)notice.getDisplayType(), ",display_type") + txtUtil.getEmpty((Object)notice.getDisplayStart(), ",display_start") + txtUtil.getEmpty((Object)notice.getDisplayEnd(), ",display_end") + txtUtil.getEmpty((Object)notice.getDisplayMode(), ",display_mode") + txtUtil.getEmpty((Object)notice.getNoticeDate(), ",notice_date") + txtUtil.getEmpty((Object)notice.getReceiveDate(), ",receive_date") + txtUtil.getEmpty((Object)notice.getUrl(), ",url") + txtUtil.getEmpty((Object)notice.getTitle(), ",title") + txtUtil.getEmpty((Object)notice.getMessage(), ",message") + ", enable_to, enable_from) values(:seq, :userId, :fromUserId" + txtUtil.getEmpty((Object)notice.getDisplayType(), ", :displayType") + txtUtil.getEmpty((Object)notice.getDisplayStart(), ", :displayStart") + txtUtil.getEmpty((Object)notice.getDisplayEnd(), ", :displayEnd") + txtUtil.getEmpty((Object)notice.getDisplayMode(), ", :displayMode") + txtUtil.getEmpty((Object)notice.getNoticeDate(), ", :noticeDate") + txtUtil.getEmpty((Object)notice.getReceiveDate(), ", :receiveDate") + txtUtil.getEmpty((Object)notice.getUrl(), ", :url") + txtUtil.getEmpty((Object)notice.getTitle(), ", :title") + txtUtil.getEmpty((Object)notice.getMessage(), ", :message") + ", :enableToString, :enableFromString)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)notice));
    }

    public void deletePortalNotice(Integer seq) {
        this.simpleTemplate.update("delete from m_portal_notice where seq=?", new Object[]{seq});
    }

    public void clearCashe() {
    }

    public boolean isDerby() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return !"postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }

    public boolean isPostgreSQL() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return "postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }
}

