/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.spec;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.SettingMap;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.Site;
import jp.nyx.common.db.model.Tieup;
import jp.nyx.common.rpc.client.NyxXmlClient;
import jp.nyx.common.util.DigestUtility;
import jp.nyx.common.util.WebUtility;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class AccessValidaterUtility
extends WebUtility {
    private NyxManager nyxManager;
    private Map<String, Setting> nyx;
    private NyxXmlClient client = new NyxXmlClient();
    private int siteparamPipemax = 4092;
    private static final String MULTIPART_REQUEST_CONTENTTYPE = "multipart";

    public AccessValidaterUtility(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
        try {
            this.nyx = this.nyxManager.loadSetting();
            this.siteparamPipemax = this.numUtil.parseInt(this.nyx.get("kernel_siteparam_pipemax").getValue(), 4092);
            this.setAuthRealm(this.nyx.get("kernel_auth_realm").getValue());
        }
        catch (SQLException e) {
            this.nyx = new SettingMap();
        }
    }

    public boolean checkUser(DataSource ds, String userId, String encPasswd) throws NyxException {
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(ds);
        try {
            int urs = template.queryForInt("select count(*) from m_user where user_id=? and passwd=? and (verify_startdate is null or verify_startdate<=current_timestamp) and (verify_enddate is null or verify_enddate>=current_timestamp) and enable='t'", new Object[]{userId, encPasswd});
            if (urs > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
        return false;
    }

    public boolean checkContextUser(DataSource ds, String userId, String encPasswd, String contextCodes) throws NyxException {
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(ds);
        try {
            int urs = template.queryForInt("select count(*) from m_user where user_id=? and passwd=? and (verify_startdate is null or verify_startdate<=current_timestamp) and (verify_enddate is null or verify_enddate>=current_timestamp) and enable='t'", new Object[]{userId, encPasswd});
            if (urs <= 0) {
                return false;
            }
            for (String contextCode : this.textUtil.nvl(contextCodes).split(",")) {
                long cc = this.numUtil.parseLong((Object)contextCode.trim(), -1L);
                int cxs = template.queryForInt("select count(*) from m_context_user where context_code=? and user_id=? and (verify_startdate is null or verify_startdate<=current_timestamp) and (verify_enddate is null or verify_enddate>=current_timestamp) and enable='t'", new Object[]{cc, userId});
                if (cxs > 0) {
                    return true;
                }
                int cxbs = template.queryForInt("select count(*) from m_context_bridge b inner join m_context_user u on (b.context_code=u.context_code) where b.parent_context_code=? and u.user_id=? and (u.verify_startdate is null or u.verify_startdate<=current_timestamp) and (u.verify_enddate is null or u.verify_enddate>=current_timestamp) and u.enable='t'", new Object[]{cc, userId});
                if (cxbs <= 0) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
        return false;
    }

    public boolean valid(DataSource ds, HttpServletRequest request, AuthValue ret) throws NyxException {
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(ds);
        try {
            ret.triggerSite = new AuthSite(this.createRequestURL(request));
            if (ret.triggerSite.url == null) {
                throw new IllegalArgumentException("param.getTrigger_site()==null");
            }
            ret.triggerMethod = request.getMethod();
            ret.clientAddress = request.getRemoteAddr();
            ret.userId = this.parseRequestUser(request);
            ret.passwd = this.parseRequestPasswd(request);
            String contentType = request.getContentType();
            List<Map<String, Object>> result = this.loadAuth(template, ret.triggerSite);
            String lastTriggerSitePath = null;
            for (Map<String, Object> row : result) {
                Map<String, Object> charset;
                ret.authId = this.numUtil.parseLong(row.get("auth_id"));
                ret.authName = (String)row.get("auth_name");
                ret.authType = (String)row.get("auth_type");
                ret.authUse = (String)row.get("auth_use");
                ret.tieupCode = this.numUtil.parseLong(row.get("tieup_code"), -1L);
                ret.validTicket = "t".equals(row.get("valid_ticket"));
                ret.triggerSite.siteId = this.numUtil.parseLong(row.get("trigger_site_id"));
                ret.validSite.siteId = this.numUtil.parseLong(row.get("valid_site_id"));
                ret.failerSite.siteId = this.numUtil.parseLong(row.get("failer_site_id"));
                if (Auth.AuthUse.PROXY.getValue().equals(ret.authUse) && (charset = this.loadExt(template, "m_auth_ext", "auth_id", ret.authId, Auth.AuthExtNames.PROXY_REQPARAM_CHARENCODE.getValue())) != null) {
                    ret.proxyCharset = (String)charset.get("field_value");
                }
                ret.proxyCharset = this.textUtil.nvl(ret.proxyCharset, "UTF-8");
                boolean isListen = Auth.AuthType.LISTEN.getValue().equals(ret.authType);
                boolean isParam = Auth.AuthType.PARAM.getValue().equals(ret.authType);
                if (isListen || isParam) {
                    if (lastTriggerSitePath != null && !row.get("site_path").equals(lastTriggerSitePath)) break;
                    if (!(this.textUtil.nvl(contentType).startsWith(MULTIPART_REQUEST_CONTENTTYPE) || this.siteparamPipemax < request.getContentLength() && this.textUtil.isEmpty(ret.triggerSite.url.getQuery()))) {
                        if (this.textUtil.isEmpty(request.getCharacterEncoding())) {
                            request.setCharacterEncoding(ret.proxyCharset);
                        }
                        Map reqMap = request.getParameterMap();
                        ret.loadedRequestParam = true;
                        for (String key : reqMap.keySet()) {
                            Object val = reqMap.get(key);
                            if (val instanceof String[] && ((String[])val).length == 1) {
                                ret.triggerSite.param.put(key, ((String[])val)[0]);
                                continue;
                            }
                            ret.triggerSite.param.put(key, val);
                        }
                    }
                    List<Map<String, Object>> triggerSiteParams = this.loadSiteParam(template, ret.triggerSite.siteId);
                    boolean isValidParam = this.validParamAuth(triggerSiteParams, ret);
                    if (isParam) {
                        if (triggerSiteParams.size() <= 0 || ret.triggerSite.param.size() <= 0) {
                            ret.validSite = this.loadSite(template, ret.validSite.siteId, ret.triggerSite);
                            this.fillTargetParam(template, ret, triggerSiteParams);
                            ret.log.append(ret.authName);
                            ret.log.append(" ");
                            ret.log.append("[Param-Auth-Passed]");
                            return true;
                        }
                        if (!isValidParam) {
                            ret.log.append(ret.authName);
                            ret.log.append(" ");
                            ret.log.append("[Param-Auth-Miss]");
                            lastTriggerSitePath = (String)row.get("site_path");
                            continue;
                        }
                        try {
                            this.searchValidSite(ret, template, ret.validSite.siteId, ret.failerSite.siteId);
                        }
                        catch (NyxException e) {
                            // empty catch block
                        }
                        if (ret.validSite.url != null) {
                            ret.informSite.addAll(this.loadAuthInform(template, ret.authId, ret.triggerSite));
                            this.fillTargetParam(template, ret, triggerSiteParams);
                            ret.log.append("[Param-Auth-Success]");
                            return true;
                        }
                        return false;
                    }
                    if (triggerSiteParams.size() <= 0 || ret.triggerSite.param.size() <= 0) {
                        ret.log.append(ret.authName);
                        ret.log.append(" ");
                        ret.log.append("[Listen-Auth-Passed]");
                        ret.validSite = this.loadSite(template, ret.validSite.siteId, ret.triggerSite);
                        this.fillTargetParam(template, ret, triggerSiteParams);
                        return true;
                    }
                    if (!isValidParam) {
                        ret.log.append(ret.authName);
                        ret.log.append(" ");
                        ret.log.append("[Listen-Auth-Miss]");
                        ret.validSite = this.loadSite(template, ret.validSite.siteId, ret.triggerSite);
                        this.fillTargetParam(template, ret, triggerSiteParams);
                        return true;
                    }
                    try {
                        this.searchValidSite(ret, template, ret.validSite.siteId, ret.failerSite.siteId);
                        if (ret.validSite.url == null) {
                            ret.log.append(ret.authName);
                            ret.log.append(" ");
                            ret.log.append("[Listen-Auth-UserUnmatch]");
                            ret.validSite = this.loadSite(template, ret.validSite.siteId, ret.triggerSite);
                            this.fillTargetParam(template, ret, triggerSiteParams);
                            return true;
                        }
                    }
                    catch (NyxException e) {
                        ret.log.append("[Listen-Auth-");
                        ret.log.append(e.getMessage());
                        ret.log.append("] ");
                    }
                    ret.validSite = this.loadSite(template, ret.validSite.siteId, ret.triggerSite);
                    ret.informSite.addAll(this.loadAuthInform(template, ret.authId, ret.triggerSite));
                    this.fillTargetParam(template, ret, triggerSiteParams);
                    ret.log.append(ret.authName);
                    ret.log.append(" ");
                    ret.log.append("[Listen-Auth-Success]");
                    return true;
                }
                try {
                    this.searchValidSite(ret, template, ret.validSite.siteId, ret.failerSite.siteId);
                }
                catch (NyxException e) {
                    // empty catch block
                }
                if (ret.validSite.url == null) break;
                ret.informSite.addAll(this.loadAuthInform(template, ret.authId, ret.triggerSite));
                ret.log.append("[Auth-Success]");
                return true;
            }
            if (result.size() <= 0) {
                ret.log.append("[NotFound-TriggerSite]");
            } else {
                ret.log.append("[NoMatch-TriggerSite]");
            }
            return false;
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    private boolean validParamAuth(List<Map<String, Object>> resultParams, AuthValue ret) {
        boolean ok = true;
        for (Map<String, Object> resultParam : resultParams) {
            Object resultParamValue;
            Site.SiteParamType paramType = Site.SiteParamType.getSiteParamType((String)((String)resultParam.get("field_type")));
            if (!paramType.isSupportSiteType(Site.SiteType.TRIGGER)) continue;
            Object field_name = resultParam.get("field_name");
            Object field_value = resultParam.get("field_value");
            if (!ret.triggerSite.param.containsKey(field_name)) {
                ok = false;
                break;
            }
            if (paramType.equals((Object)Site.SiteParamType.VALUE)) {
                if (this.textUtil.isEmpty((String)field_value)) continue;
                resultParamValue = ret.triggerSite.param.get(field_name);
                if (resultParamValue instanceof String[]) {
                    for (String rp : (String[])resultParamValue) {
                        if (this.textUtil.nvl(rp).equals(field_value)) continue;
                        ok = false;
                    }
                    if (!ok) {
                        break;
                    }
                } else if (resultParamValue instanceof String && !this.textUtil.nvl((String)resultParamValue).equals(field_value)) {
                    ok = false;
                    break;
                }
            }
            if (paramType.equals((Object)Site.SiteParamType.UID)) {
                resultParamValue = ret.triggerSite.param.get(field_name);
                if (resultParamValue instanceof String[]) {
                    if (((String[])resultParamValue).length > 0) {
                        ret.userId = ((String[])resultParamValue)[0];
                    }
                } else if (resultParamValue instanceof String) {
                    ret.userId = (String)resultParamValue;
                    continue;
                }
                ok = false;
                break;
            }
            if (!paramType.equals((Object)Site.SiteParamType.UPW)) continue;
            resultParamValue = ret.triggerSite.param.get(field_name);
            if (resultParamValue instanceof String[]) {
                if (((String[])resultParamValue).length > 0) {
                    ret.passwd = ((String[])resultParamValue)[0];
                }
            } else if (resultParamValue instanceof String) {
                ret.passwd = (String)resultParamValue;
                continue;
            }
            ok = false;
            break;
        }
        if (!ok) {
            ret.log.append("[NoMatch-TriggerSiteParam]");
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> loadAuth(SimpleJdbcTemplate template, AuthSite trigger) throws SQLException {
        List result = template.queryForList("select auth_id as \"auth_id\", trigger_site_id as \"trigger_site_id\", valid_site_id as \"valid_site_id\", auth_name as \"auth_name\", failer_site_id as \"failer_site_id\", auth_type as \"auth_type\", auth_use as \"auth_use\", tieup_code as \"tieup_code\", site_path as \"site_path\", valid_ticket as \"valid_ticket\" from v_auth_verify where ? like site_path||'%' order by length(site_path) desc, site_priority desc, auth_id desc", new Object[]{trigger.url.getPath()});
        return result;
    }

    private List<AuthSite> loadAuthInform(SimpleJdbcTemplate template, Long authId, AuthSite trigger) {
        InformSiteMapper informSiteMapper = new InformSiteMapper(trigger.url.getQuery());
        List result = template.query("select inform_site_id as \"site_id\", site_protocol as \"site_protocol\", site_host as \"site_host\", site_port as \"site_port\", site_path as \"site_path\" from m_auth_inform a join m_site b on (a.inform_site_id=b.site_id) where a.auth_id=? and b.verify_startdate<=current_timestamp and current_timestamp<=b.verify_enddate and b.enable='t'", (ParameterizedRowMapper)informSiteMapper, new Object[]{authId});
        return result;
    }

    private List<Map<String, Object>> loadSiteParam(SimpleJdbcTemplate template, Long siteId) {
        List result = template.queryForList("select site_id as \"site_id\", field_name as \"field_name\", field_value as \"field_value\", field_type as \"field_type\", field_modify as \"field_modify\", field_display as \"field_display\" from m_site_param where site_id=? and verify_startdate<=current_timestamp and current_timestamp<=verify_enddate and enable='t'", new Object[]{siteId});
        return result;
    }

    private void searchValidSite(AuthValue ret, SimpleJdbcTemplate template, Long valid_site_id, Long failer_site_id) throws NyxException {
        try {
            ret.log.append(ret.authName);
            ret.log.append(" ");
            if (Auth.AuthType.PASSED.getValue().equals(ret.authType)) {
                ret.validSite = this.loadSite(template, valid_site_id, ret.triggerSite);
                return;
            }
            if (Auth.AuthType.isOpenidType((String)ret.authType)) {
                // empty if block
            }
            if (ret.tieupCode > 0L) {
                Tieup tieup = this.nyxManager.loadTieup(ret.tieupCode);
                if (Tieup.TiupType.QUERY.getValue().equals(tieup.getTieupType()) && !this.textUtil.isEmpty(tieup.getTieupServer())) {
                    ret.log.append("[TieupAuth ");
                    ret.log.append(tieup.getTieupServer());
                    ret.log.append("]");
                    if (Tieup.TiupUse.CONTEXT.getValue().equals(tieup.getTieupUse())) {
                        try {
                            boolean authUser = this.client.rpcCheckContextUser("xmlrpc=" + tieup.getTieupServer(), ret.userId, ret.passwd, tieup.getTieupModify());
                            if (!authUser) {
                                ret.log.append("[CheckContextUser-Permit-Failed]");
                                ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                                return;
                            }
                        }
                        catch (NyxException e) {
                            ret.log.append("[CheckContextUser-Failed:" + e.getMessage() + "]");
                            ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                            throw new NyxException((Throwable)e);
                        }
                        ret.validSite = this.loadSite(template, valid_site_id, ret.triggerSite);
                        if (ret.validSite.url == null) {
                            ret.log.append("[NotFound-ValidSite]");
                            ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                            return;
                        }
                        return;
                    }
                    if (Tieup.TiupUse.ACCOUNT.getValue().equals(tieup.getTieupUse())) {
                        try {
                            boolean authUser = this.client.rpcCheckUser("xmlrpc=" + tieup.getTieupServer(), ret.userId, ret.passwd);
                            if (!authUser) {
                                ret.log.append("[CheckUser-Permit-Failed]");
                                ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                                return;
                            }
                        }
                        catch (NyxException e) {
                            ret.log.append("[CheckUser-Failed:" + e.getMessage() + "]");
                            ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                            throw new NyxException((Throwable)e);
                        }
                        ret.validSite = this.loadSite(template, valid_site_id, ret.triggerSite);
                        if (ret.validSite.url == null) {
                            ret.log.append("[NotFound-ValidSite]");
                            ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                            return;
                        }
                        return;
                    }
                }
            }
            String sha1Pass = this.textUtil.nvl(DigestUtility.sha1((String)ret.passwd));
            String md5Pass = this.textUtil.nvl(DigestUtility.md5((String)ret.passwd));
            String user_id = this.textUtil.nvl(ret.userId);
            int crs1 = template.queryForInt("select count(*) from v_auth_context_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.authId, user_id, md5Pass});
            int crs2 = template.queryForInt("select count(*) from v_auth_context_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.authId, user_id, sha1Pass});
            if (crs1 <= 0 && crs2 <= 0) {
                int urs3;
                int urs1 = template.queryForInt("select count(*) from v_auth_user_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.authId, user_id, md5Pass});
                int urs2 = template.queryForInt("select count(*) from v_auth_user_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.authId, user_id, sha1Pass});
                if (urs1 <= 0 && urs2 <= 0 && (urs3 = template.queryForInt("select count(*) from m_user where user_id=? and passwd=? and user_type='ticket' and ? like modification_value||'%'", new Object[]{user_id, md5Pass, ret.triggerSite.toString()})) <= 0) {
                    ret.log.append("[NotFound-UserOnTrigger]");
                    ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                    return;
                }
            }
            ret.validSite = this.loadSite(template, valid_site_id, ret.triggerSite);
            if (ret.validSite.url == null) {
                ret.log.append("[NotFound-ValidSite]");
                ret.failerSite = this.loadSite(template, failer_site_id, ret.triggerSite);
                return;
            }
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    private void fillTargetParam(SimpleJdbcTemplate template, AuthValue ret, List<Map<String, Object>> triggerSiteParams) throws SQLException {
        Map<String, Object> ext;
        Site.SiteParamType field_type;
        Object field_value;
        String field_name;
        String field_type2;
        for (Map<String, Object> triggerSiteParam : triggerSiteParams) {
            String field_name2 = (String)triggerSiteParam.get("field_name");
            Object field_value2 = triggerSiteParam.get("field_value");
            field_type2 = (String)triggerSiteParam.get("field_type");
            if (!Site.SiteParamType.VALUE.getValue().equals(field_type2)) continue;
            ret.triggerSite.param.put(field_name2, field_value2);
        }
        List<Map<String, Object>> validSiteParams = this.loadSiteParam(template, ret.validSite.siteId);
        for (Map<String, Object> validSiteParam : validSiteParams) {
            field_name = (String)validSiteParam.get("field_name");
            field_value = validSiteParam.get("field_value");
            field_type = Site.SiteParamType.getSiteParamType((String)((String)validSiteParam.get("field_type")));
            if (Site.SiteParamType.VALUE.equals((Object)field_type)) {
                ret.validSite.param.put(field_name, field_value);
                continue;
            }
            if (Site.SiteParamType.UID.equals((Object)field_type)) {
                ret.validSite.param.put(field_name, ret.userId);
                continue;
            }
            if (Site.SiteParamType.UPW.equals((Object)field_type)) {
                ret.validSite.param.put(field_name, ret.passwd);
                continue;
            }
            if (Site.SiteParamType.USEREXT.equals((Object)field_type)) {
                ext = this.loadExt(template, "m_user_ext", "user_id", ret.userId, field_value);
                ret.validSite.param.put(field_name, ext.get("field_value"));
                continue;
            }
            if (Site.SiteParamType.AUTHEXT.equals((Object)field_type)) {
                ext = this.loadExt(template, "m_autht_ext", "auth_id", ret.authId, field_value);
                ret.validSite.param.put(field_name, ext.get("field_value"));
                continue;
            }
            if (!Site.SiteParamType.INFORMHEADER2PARAM.equals((Object)field_type)) continue;
            AuthSiteParamReserve pr = new AuthSiteParamReserve();
            pr.paramName = (String)field_value;
            ret.validSite.param.put(field_name.toLowerCase(), pr);
        }
        ret.validSite.param.putAll(ret.triggerSite.param);
        for (Map<String, Object> validSiteParam : validSiteParams) {
            field_name = (String)validSiteParam.get("field_name");
            field_type2 = (String)validSiteParam.get("field_type");
            if (!Site.SiteParamType.LOSEVALUE.getValue().equals(field_type2)) continue;
            ret.validSite.param.remove(field_name);
        }
        if (ret.failerSite.siteId != null) {
            for (Map<String, Object> failerSiteParam : this.loadSiteParam(template, ret.failerSite.siteId)) {
                field_name = (String)failerSiteParam.get("field_name");
                field_value = failerSiteParam.get("field_value");
                field_type = Site.SiteParamType.getSiteParamType((String)((String)failerSiteParam.get("field_type")));
                if (Site.SiteParamType.VALUE.equals((Object)field_type)) {
                    ret.failerSite.param.put(field_name, field_value);
                    continue;
                }
                if (Site.SiteParamType.PIPE.equals((Object)field_type)) {
                    ret.failerSite.param.put(field_name, ret.triggerSite.param.get(field_value));
                    continue;
                }
                if (Site.SiteParamType.UID.equals((Object)field_type)) {
                    ret.failerSite.param.put(field_name, ret.userId);
                    continue;
                }
                if (Site.SiteParamType.UPW.equals((Object)field_type)) {
                    ret.failerSite.param.put(field_name, ret.passwd);
                    continue;
                }
                if (Site.SiteParamType.USEREXT.equals((Object)field_type)) {
                    ext = this.loadExt(template, "m_user_ext", "user_id", ret.userId, field_value);
                    ret.failerSite.param.put(field_name, ext.get("field_value"));
                    continue;
                }
                if (!Site.SiteParamType.AUTHEXT.equals((Object)field_type)) continue;
                ext = this.loadExt(template, "m_autht_ext", "auth_id", ret.authId, field_value);
                ret.failerSite.param.put(field_name, ext.get("field_value"));
            }
        }
        for (AuthSite inform : ret.informSite) {
            for (Map<String, Object> informSiteParam : this.loadSiteParam(template, inform.siteId)) {
                Map<String, Object> ext2;
                String field_name3 = (String)informSiteParam.get("field_name");
                Object field_value3 = informSiteParam.get("field_value");
                Site.SiteParamType field_type3 = Site.SiteParamType.getSiteParamType((String)((String)informSiteParam.get("field_type")));
                if (Site.SiteParamType.VALUE.equals((Object)field_type3)) {
                    inform.param.put(field_name3, field_value3);
                    continue;
                }
                if (Site.SiteParamType.PIPE.equals((Object)field_type3)) {
                    inform.param.put(field_name3, ret.triggerSite.param.get(field_value3));
                    continue;
                }
                if (Site.SiteParamType.UID.equals((Object)field_type3)) {
                    inform.param.put(field_name3, ret.userId);
                    continue;
                }
                if (Site.SiteParamType.UPW.equals((Object)field_type3)) {
                    inform.param.put(field_name3, ret.passwd);
                    continue;
                }
                if (Site.SiteParamType.USEREXT.equals((Object)field_type3)) {
                    ext2 = this.loadExt(template, "m_user_ext", "user_id", ret.userId, field_value3);
                    inform.param.put(field_name3, ext2.get("field_value"));
                    continue;
                }
                if (!Site.SiteParamType.AUTHEXT.equals((Object)field_type3)) continue;
                ext2 = this.loadExt(template, "m_autht_ext", "auth_id", ret.authId, field_value3);
                inform.param.put(field_name3, ext2.get("field_value"));
            }
        }
    }

    private Map<String, Object> loadExt(SimpleJdbcTemplate template, String table, String key, Object keyValue, Object fieldName) throws SQLException {
        List result = template.queryForList("select field_value as \"field_value\" from " + table + " where " + key + "=? and field_name=? and verify_startdate<current_timestamp and current_timestamp<verify_enddate and enable='t'", new Object[]{keyValue, fieldName});
        if (result.size() <= 0) {
            return new HashMap<String, Object>();
        }
        return (Map)result.get(0);
    }

    private AuthSite loadSite(SimpleJdbcTemplate template, Long siteId, AuthSite trigger) throws NyxException {
        try {
            if (siteId == null) {
                return null;
            }
            Map row = template.queryForMap("select site_protocol as \"site_protocol\", site_host as \"site_host\", site_port as \"site_port\", site_path as \"site_path\" from m_site where site_id=? and site_path is not null", new Object[]{siteId});
            if (row == null) {
                return null;
            }
            String queryString = this.textUtil.nvl(trigger.url.getQuery());
            queryString = !this.textUtil.isEmpty(queryString) ? "?" + queryString : queryString;
            String pathString = trigger.url.getPath();
            return new AuthSite(siteId, new URL((String)row.get("site_protocol"), (String)row.get("site_host"), (Integer)row.get("site_port"), pathString + queryString));
        }
        catch (EmptyResultDataAccessException e) {
            return new AuthSite();
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    public class AuthValue {
        private String userId = null;
        private AuthSite triggerSite = new AuthSite();
        private String triggerMethod = null;
        private String passwd = null;
        private long authId = -1L;
        private long contextCode = -1L;
        private String authName = null;
        private String authType = null;
        private String authUse = null;
        private long tieupCode = -1L;
        private AuthSite validSite = new AuthSite();
        private AuthSite failerSite = new AuthSite();
        private String clientAddress = null;
        private StringBuffer log = new StringBuffer();
        private long lastAccess = -1L;
        private boolean validTicket = false;
        private boolean proxyLogWrite = false;
        private String sessionId = null;
        private List<AuthSite> informSite = new ArrayList<AuthSite>();
        private String proxyCharset = null;
        private boolean loadedRequestParam = false;

        public void clean() {
            this.userId = null;
            this.triggerSite = null;
            this.triggerMethod = null;
            this.passwd = null;
            this.authId = -1L;
            this.authName = null;
            this.authType = null;
            this.authUse = null;
            this.validSite = null;
            this.failerSite = null;
            this.clientAddress = null;
            this.log = new StringBuffer();
            this.validTicket = false;
            this.proxyLogWrite = false;
            this.informSite.clear();
        }

        public long getAuthId() {
            return this.authId;
        }

        public void setAuthId(long authId) {
            this.authId = authId;
        }

        public String getClientAddress() {
            return this.clientAddress;
        }

        public void setClientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
        }

        public AuthSite getFailerSite() {
            return this.failerSite;
        }

        public void setFailerSite(AuthSite failerSite) {
            this.failerSite = failerSite;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
        }

        public AuthSite getTriggerSite() {
            return this.triggerSite;
        }

        public void setTriggerSite(AuthSite triggerSite) {
            this.triggerSite = triggerSite;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public AuthSite getValidSite() {
            return this.validSite;
        }

        public void setValidSite(AuthSite validSite) {
            this.validSite = validSite;
        }

        public StringBuffer getLog() {
            return this.log;
        }

        public String getAuthName() {
            return this.authName;
        }

        public void setAuthName(String authName) {
            this.authName = authName;
        }

        public String getAuthType() {
            return this.authType;
        }

        public void setAuthType(String authType) {
            this.authType = authType;
        }

        public String getAuthUse() {
            return this.authUse;
        }

        public void setAuthUse(String authUse) {
            this.authUse = authUse;
        }

        public String getTriggerMethod() {
            return this.triggerMethod;
        }

        public void setTriggerMethod(String triggerMethod) {
            this.triggerMethod = triggerMethod;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess(long lastAccess) {
            this.lastAccess = lastAccess;
        }

        public boolean isProxyLogWrite() {
            return this.proxyLogWrite;
        }

        public void setProxyLogWrite(boolean proxyLogWrite) {
            this.proxyLogWrite = proxyLogWrite;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public boolean isValidTicket() {
            return this.validTicket;
        }

        public void setValidTicket(boolean validTicket) {
            this.validTicket = validTicket;
        }

        public long getTieupCode() {
            return this.tieupCode;
        }

        public void setTieupCode(long tieupCode) {
            this.tieupCode = tieupCode;
        }

        public List<AuthSite> getInformSite() {
            return this.informSite;
        }

        public long getContextCode() {
            return this.contextCode;
        }

        public void setContextCode(long contextCode) {
            this.contextCode = contextCode;
        }

        public String getProxyCharset() {
            return this.proxyCharset;
        }

        public void setProxyCharset(String proxyCharset) {
            this.proxyCharset = proxyCharset;
        }

        public boolean isLoadedRequestParam() {
            return this.loadedRequestParam;
        }

        public void setLoadedRequestParam(boolean loadedRequestParam) {
            this.loadedRequestParam = loadedRequestParam;
        }
    }

    public class AuthSite {
        private Long siteId;
        private URL url;
        private Map<String, Object> param = new HashMap<String, Object>();

        private AuthSite() {
        }

        private AuthSite(URL url) {
            this.url = url;
        }

        public AuthSite(Long siteId, URL url) {
            this.siteId = siteId;
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }

        public void setUrl(URL url) {
            this.url = url;
        }

        public Map<String, Object> getParam() {
            return this.param;
        }

        public Long getSiteId() {
            return this.siteId;
        }

        public void setSiteId(Long siteId) {
            this.siteId = siteId;
        }
    }

    public class AuthSiteParamReserve {
        private Site.SiteParamType type = Site.SiteParamType.INFORMHEADER2PARAM;
        private String paramName = "";

        public Site.SiteParamType getType() {
            return this.type;
        }

        public void setType(Site.SiteParamType type) {
            this.type = type;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }
    }

    private class InformSiteMapper
    implements ParameterizedRowMapper<AuthSite> {
        private String query;

        private InformSiteMapper(String query) {
            this.query = query;
        }

        public AuthSite mapRow(ResultSet rs, int rowNum) throws SQLException {
            try {
                String query = AccessValidaterUtility.this.textUtil.nvl(this.query);
                query = !AccessValidaterUtility.this.textUtil.isEmpty(query) ? "?" + query : query;
                URL url = new URL(rs.getString("site_protocol"), rs.getString("site_host"), rs.getInt("site_port"), rs.getString("site_path") + query);
                AuthSite ret = new AuthSite(rs.getLong("site_id"), url);
                return ret;
            }
            catch (MalformedURLException e) {
                SQLException se = new SQLException(e.getMessage());
                se.initCause(e);
                throw se;
            }
        }
    }
}

