/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.common.taglib.db;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.sql.DataSource;
import jp.nyx.pkg.common.taglib.db.NdbTag;
import jp.nyx.pkg.swc.db.SwcManager;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NTransactionTag
extends NdbTag {
    private boolean rollback = false;
    private boolean commit = false;
    private SwcManager appManager;
    private TransactionStatus status;

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (this.appManager == null) {
            WebApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.pageContext.getServletContext());
            this.appManager = (SwcManager)appCtx.getBean("swcManager");
            try {
                this.appManager.init((ApplicationContext)appCtx);
                if (!this.appManager.isInit("select 1")) {
                    DataSource appDs = (DataSource)appCtx.getBean("swcDataSource");
                    Method m = appDs.getClass().getMethod("setDriverClassName", String.class);
                    m.invoke((Object)appDs, this.getSetting("app_jdbc_driver").getValue());
                    m = appDs.getClass().getMethod("setUrl", String.class);
                    m.invoke((Object)appDs, this.getSetting("app_jdbc_url").getValue());
                    m = appDs.getClass().getMethod("setUsername", String.class);
                    m.invoke((Object)appDs, this.getSetting("app_jdbc_user").getValue());
                    m = appDs.getClass().getMethod("setPassword", String.class);
                    m.invoke((Object)appDs, this.getSetting("app_jdbc_pass").getValue());
                }
            }
            catch (Exception e) {
                JspException je = new JspException(e.getMessage());
                je.initCause((Throwable)e);
                throw je;
            }
        }
        this.status = this.appManager.begin();
        return 1;
    }

    @Override
    public int doEndTag() throws JspException {
        if (!this.status.isCompleted()) {
            if (this.commit) {
                this.appManager.commit(this.status);
            } else {
                this.appManager.rollback(this.status);
            }
        }
        return 6;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public SwcManager getAppManager() {
        return this.appManager;
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        this.rollback = rollback;
    }
}

