/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.nyx.NyxException;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.model.AccessContext;
import jp.nyx.common.db.model.AccessUser;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.util.CalendarUtility;
import jp.nyx.common.util.TextUtility;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public abstract class BaseDao
extends JdbcDaoSupport {
    protected static final CalendarUtility calUtil = new CalendarUtility();
    protected static final TextUtility txtUtil = new TextUtility();
    protected SimpleJdbcTemplate simpleTemplate;
    protected NamedParameterJdbcTemplate namedTemplate;
    protected ParameterizedRowMapper<String> stringMapper;
    protected ParameterizedRowMapper<Ext> extMapper;
    protected ParameterizedRowMapper<AccessUser> accessUserMapper;
    protected ParameterizedRowMapper<AccessContext> accessContextMapper;
    public boolean verbose = false;

    protected BaseDao() {
    }

    protected BaseDao(SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate) {
        this.simpleTemplate = simpleTemplate;
        this.namedTemplate = namedTemplate;
        this.initTemplateConfig();
    }

    protected void initTemplateConfig() {
        super.initTemplateConfig();
        this.stringMapper = new DefaultParameterizedRowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        };
        this.extMapper = new DefaultParameterizedRowMapper<Ext>(){

            public Ext mapRow(ResultSet rs, int rowNum) throws SQLException {
                Ext ret = new Ext();
                this.mapRow(ret, rs, rowNum);
                ret.setFieldName(rs.getString("field_name"));
                ret.setFieldValue(rs.getString("field_value"));
                ret.setFieldType(rs.getString("field_type"));
                ret.setFieldModify(rs.getString("field_modify"));
                ret.setFieldDisplay(rs.getString("field_display"));
                return ret;
            }
        };
        this.accessUserMapper = new DefaultParameterizedRowMapper<AccessUser>(){

            public AccessUser mapRow(ResultSet rs, int rowNum) throws SQLException {
                AccessUser ret = new AccessUser();
                this.mapRow(ret, rs, rowNum);
                ret.setVerifyUserId(rs.getString("verify_user_id"));
                ret.setVerifyUserName(rs.getString("verify_user_name"));
                return ret;
            }
        };
        this.accessContextMapper = new DefaultParameterizedRowMapper<AccessContext>(){

            public AccessContext mapRow(ResultSet rs, int rowNum) throws SQLException {
                AccessContext ret = new AccessContext();
                this.mapRow(ret, rs, rowNum);
                ret.setVerifyContextCode(rs.getInt("verify_context_code"));
                ret.setVerifyContextName(rs.getString("verify_context_name"));
                return ret;
            }
        };
    }

    public int update(String sql) throws SQLException {
        if (this.verbose) {
            NyxException.logger.debug((Object)sql);
        }
        return this.simpleTemplate.update(sql, new Object[0]);
    }

    public int update(String macroSql, Object ... params) {
        if (this.verbose) {
            NyxException.logger.debug((Object)macroSql);
        }
        return this.simpleTemplate.update(macroSql, params);
    }

    protected List<String> loadString(final String coloum, String table, ConditionList conditions, int offset, int limit, String orderColoum) throws SQLException {
        ArrayList<Object> cond = new ArrayList<Object>();
        String where = BaseDao.genWhereString(conditions, cond);
        if (this.isPostgreSQL()) {
            cond.add(offset);
            cond.add(limit);
            return this.simpleTemplate.query("select " + coloum + " from " + table + where + " order by " + orderColoum + " offset ? limit ?", (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString(coloum);
                }
            }, cond.toArray());
        }
        if (limit <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (offset < 0) {
            return Collections.EMPTY_LIST;
        }
        List ret = this.simpleTemplate.query("select " + coloum + " from " + table + where + " order by " + orderColoum, (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(coloum);
            }
        }, cond.toArray());
        int n = ret.size();
        if (offset > n || n <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (offset + limit >= n) {
            return ret.subList(offset, n);
        }
        return ret.subList(offset, offset + limit);
    }

    public List<String> loadString(final String coloum, String table, String whereKey, long whereVal) {
        List ret = this.simpleTemplate.query("select " + coloum + " from " + table + " where " + whereKey + "=?", (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(coloum);
            }
        }, new Object[]{whereVal});
        return ret;
    }

    public List<String> loadString(final String coloum, String table, String whereKey, long whereVal, int offset, int limit) throws SQLException {
        if (this.isPostgreSQL()) {
            List ret = this.simpleTemplate.query("select " + coloum + " from " + table + " where " + whereKey + "=? offset ? limit ?", (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString(coloum);
                }
            }, new Object[]{whereVal, offset, limit});
            return ret;
        }
        List ret = this.simpleTemplate.query("select " + coloum + " from " + table + " where " + whereKey + "=?", (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(coloum);
            }
        }, new Object[]{whereVal});
        int n = ret.size();
        if (offset > n || n <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (offset + limit >= n) {
            return ret.subList(offset, n);
        }
        return ret.subList(offset, offset + limit);
    }

    protected List<Long> loadLong(final String coloum, String table, ConditionList conditions, int offset, int limit, String orderColoum) throws SQLException {
        ArrayList<Object> cond = new ArrayList<Object>();
        String where = BaseDao.genWhereString(conditions, cond);
        if (this.isPostgreSQL()) {
            cond.add(offset);
            cond.add(limit);
            return this.simpleTemplate.query("select " + coloum + " from " + table + where + " order by " + orderColoum + " offset ? limit ?", (ParameterizedRowMapper)new ParameterizedRowMapper<Long>(){

                public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getLong(coloum);
                }
            }, cond.toArray());
        }
        if (limit <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (offset < 0) {
            return Collections.EMPTY_LIST;
        }
        List ret = this.simpleTemplate.query("select " + coloum + " from " + table + where + " order by " + orderColoum, (ParameterizedRowMapper)new ParameterizedRowMapper<Long>(){

            public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getLong(coloum);
            }
        }, cond.toArray());
        int n = ret.size();
        if (offset > n || n <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (offset + limit >= n) {
            return ret.subList(offset, n);
        }
        return ret.subList(offset, offset + limit);
    }

    public List<Long> loadLong(final String coloum, String table, String whereKey, Object whereVal) {
        List ret = this.simpleTemplate.query("select " + coloum + " from " + table + " where " + whereKey + "=?", (ParameterizedRowMapper)new ParameterizedRowMapper<Long>(){

            public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getLong(coloum);
            }
        }, new Object[]{whereVal});
        return ret;
    }

    public List<Long> loadLong(final String coloum, String table, String whereKey, Object whereVal, int offset, int limit) throws SQLException {
        if (this.isPostgreSQL()) {
            List ret = this.simpleTemplate.query("select " + coloum + " from " + table + " where " + whereKey + "=? offset ? limit ?", (ParameterizedRowMapper)new ParameterizedRowMapper<Long>(){

                public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getLong(coloum);
                }
            }, new Object[]{whereVal, offset, limit});
            return ret;
        }
        List ret = this.simpleTemplate.query("select " + coloum + " from " + table + " where " + whereKey + "=?", (ParameterizedRowMapper)new ParameterizedRowMapper<Long>(){

            public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getLong(coloum);
            }
        }, new Object[]{whereVal});
        int n = ret.size();
        if (offset > n || n <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (offset + limit >= n) {
            return ret.subList(offset, n);
        }
        return ret.subList(offset, offset + limit);
    }

    public long loadMaxLong(String coloum, String table) {
        return this.simpleTemplate.queryForLong("select max(" + coloum + ") from " + table, new Object[0]);
    }

    public int loadDataCount(String table, ConditionList conditions) {
        ArrayList<Object> cond = new ArrayList<Object>();
        String where = BaseDao.genWhereString(conditions, cond);
        return this.simpleTemplate.queryForInt("select count(*) from " + table + where, cond.toArray());
    }

    public int loadDataCount(String table, String coloum, ConditionList conditions) {
        ArrayList<Object> cond = new ArrayList<Object>();
        String where = BaseDao.genWhereString(conditions, cond);
        return this.simpleTemplate.queryForInt("select count(*) from (select distinct " + coloum + " from " + table + where + ") counts", cond.toArray());
    }

    protected static String genWhereString(ConditionList conditions, List<Object> cond) {
        StringBuffer where = new StringBuffer();
        if (conditions != null) {
            for (Condition c : conditions) {
                String k;
                if (c == null || txtUtil.isEmpty(k = c.getColoumName())) continue;
                if (where.length() <= 0) {
                    where.append(" where ");
                } else {
                    where.append(" and ");
                }
                where.append(k);
                where.append(" ");
                where.append(c.getOperate());
                if (c.isUseMacro()) {
                    where.append(" ?");
                    cond.add(c.getColoumValue());
                    continue;
                }
                where.append(c.getColoumValue());
            }
        }
        return where.toString();
    }

    public List<Map<String, Object>> loadList(String macroSql, Object ... params) {
        if (this.verbose) {
            NyxException.logger.debug((Object)macroSql);
        }
        return this.simpleTemplate.queryForList(macroSql, params);
    }

    public Map<String, Object> loadMap(String macroSql, Object ... params) {
        if (this.verbose) {
            NyxException.logger.debug((Object)macroSql);
        }
        return this.simpleTemplate.queryForMap(macroSql, params);
    }

    public long nextSequence(String sequenceName) throws SQLException {
        if (this.isPostgreSQL()) {
            return this.simpleTemplate.queryForInt("select nextval(?)", new Object[]{sequenceName});
        }
        this.update("update " + sequenceName + " set seq=seq+1");
        return this.simpleTemplate.queryForLong("select max(seq) from " + sequenceName, new Object[0]);
    }

    public long currSequence(String sequenceName) throws SQLException {
        if (this.isPostgreSQL()) {
            return this.simpleTemplate.queryForInt("select currval(?)", new Object[]{sequenceName});
        }
        return this.simpleTemplate.queryForLong("select max(seq) from " + sequenceName, new Object[0]);
    }

    protected void saveSsoDefault(String table, String whereKey, Object whereValue, DefaultModel def) {
        Calendar cal = calUtil.getCalendar();
        def.setLastUpdate(cal);
        StringBuilder sql = new StringBuilder("update ");
        sql.append(table);
        sql.append(" set verify_startdate=:verifyStartdate,verify_enddate=:verifyEnddate,regist_uid=:registUid,update_uid=:updateUid,last_update=:lastUpdate,enable=:enableString where ");
        sql.append(whereKey);
        sql.append("=");
        if (whereValue instanceof String) {
            sql.append("'");
            sql.append(((String)whereValue).replace("'", "\\'"));
            sql.append("'");
        } else {
            sql.append(whereValue);
        }
        this.namedTemplate.update(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)def));
    }

    protected void saveSsoDefault(String table, String whereKey1, Object whereValue1, String whereKey2, String whereParam, DefaultModel def) {
        Calendar cal = calUtil.getCalendar();
        def.setLastUpdate(cal);
        StringBuilder sql = new StringBuilder("update ");
        sql.append(table);
        sql.append(" set verify_startdate=:verifyStartdate,verify_enddate=:verifyEnddate,regist_uid=:registUid,update_uid=:updateUid,last_update=:lastUpdate,enable=:enableString where ");
        sql.append(whereKey1);
        sql.append("=");
        if (whereValue1 instanceof String) {
            sql.append("'");
            sql.append(((String)whereValue1).replace("'", "\\'"));
            sql.append("'");
        } else {
            sql.append(whereValue1);
        }
        sql.append(" and ");
        sql.append(whereKey2);
        sql.append("=:");
        sql.append(whereParam);
        this.namedTemplate.update(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)def));
    }

    protected void saveExt(String table, String whereKey, Object whereValue, Map<String, Ext> ext, DefaultModel base) {
        for (String k : ext.keySet()) {
            Ext ex = ext.get(k);
            ex.setRegistUid(txtUtil.nvl(ex.getRegistUid(), base.getRegistUid()));
            ex.setUpdateUid(txtUtil.nvl(ex.getUpdateUid(), base.getUpdateUid()));
            ex.setLastUpdate(base.getLastUpdate());
            ex.setVerifyStartdate(base.getVerifyStartdate());
            ex.setVerifyEnddate(base.getVerifyEnddate());
            ex.setEnable(base.isEnable());
            if (ex.isSessionDisable()) {
                this.simpleTemplate.update("delete from " + table + " where " + whereKey + "=? and field_name=?", new Object[]{whereValue, ex.getFieldName()});
                continue;
            }
            int n = this.simpleTemplate.update("update " + table + " set field_value=?, field_type=?, field_modify=?, field_display=? where " + whereKey + "=? and field_name=?", new Object[]{ex.getFieldValue(), ex.getFieldType(), ex.getFieldModify(), ex.getFieldDisplay(), whereValue, ex.getFieldName()});
            if (n <= 0) {
                this.simpleTemplate.update("insert into " + table + "(" + whereKey + ", field_name, field_value, field_type, field_modify, field_display) values(?, ?, ?, ?, ?, ?)", new Object[]{whereValue, ex.getFieldName(), ex.getFieldValue(), ex.getFieldType(), ex.getFieldModify(), ex.getFieldDisplay()});
            }
            this.saveSsoDefault(table, whereKey, whereValue, "field_name", "fieldName", ex);
        }
    }

    protected void saveAccessUser(String table, String whereKey, Object whereValue, Set<AccessUser> accessUser) {
        this.simpleTemplate.update("delete from " + table + " where " + whereKey + "=?", new Object[]{whereValue});
        for (AccessUser a : accessUser) {
            this.simpleTemplate.update("insert into " + table + "(" + whereKey + ", verify_user_id) values(?, ?)", new Object[]{whereValue, a.getVerifyUserId()});
            this.saveSsoDefault(table, whereKey, whereValue, "verify_user_id", "verifyUserId", a);
        }
    }

    protected void saveAccessContext(String table, String whereKey, Object whereValue, Set<AccessContext> accessContext) {
        this.simpleTemplate.update("delete from " + table + " where " + whereKey + "=?", new Object[]{whereValue});
        for (AccessContext a : accessContext) {
            this.simpleTemplate.update("insert into " + table + "(" + whereKey + ", verify_context_code) values(?, ?)", new Object[]{whereValue, a.getVerifyContextCode()});
            this.saveSsoDefault(table, whereKey, whereValue, "verify_context_code", "verifyContextCode", a);
        }
    }

    protected void saveRef(String table, String upKey, String upParam, String whereKey, Object whereValue, Set<? extends DefaultModel> ref, DefaultModel base) {
        this.simpleTemplate.update("delete from " + table + " where " + whereKey + "=?", new Object[]{whereValue});
        for (DefaultModel defaultModel : ref) {
            if (whereValue instanceof Long || whereValue instanceof Integer) {
                this.namedTemplate.update("insert into " + table + "(" + whereKey + ", " + upKey + ") values(" + whereValue + ", :" + upParam + ")", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)defaultModel));
            } else {
                this.namedTemplate.update("insert into " + table + "(" + whereKey + ", " + upKey + ") values('" + whereValue + "', :" + upParam + ")", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)defaultModel));
            }
            defaultModel.setRegistUid(txtUtil.nvl(defaultModel.getRegistUid(), base.getRegistUid()));
            defaultModel.setUpdateUid(base.getUpdateUid());
            defaultModel.setLastUpdate(base.getLastUpdate());
            defaultModel.setVerifyStartdate(base.getVerifyStartdate());
            defaultModel.setVerifyEnddate(base.getVerifyEnddate());
            defaultModel.setEnable(base.isEnable());
            this.saveSsoDefault(table, whereKey, whereValue, upKey, upParam, defaultModel);
        }
    }

    public abstract boolean isPostgreSQL() throws SQLException;

    public abstract boolean isDerby() throws SQLException;

    public abstract void clearCashe();
}

