/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.nyx.common.db.NyxDao;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Tieup;
import jp.nyx.common.util.WebUtility;

public class NyxManager {
    private NyxDao dao;
    public final WebUtility webUtil = new WebUtility();

    public void setNyxDao(NyxDao dao) {
        this.dao = dao;
    }

    public void init() throws SQLException {
        int c;
        List<Map<String, Object>> line;
        String ck;
        Matcher m;
        if (this.dao.isInit()) {
            return;
        }
        ResourceBundle conf = ResourceBundle.getBundle("jp.nyx.common.db.nyx_sql");
        Set<String> keys = conf.keySet();
        Pattern create = Pattern.compile("sql\\.create\\.(.+)");
        Pattern update = Pattern.compile("sql\\.update\\.(.+)");
        for (String k : keys) {
            m = create.matcher(k);
            if (!m.find()) continue;
            ck = m.group(1);
            try {
                line = this.dao.query(conf.getString("sql.check." + ck).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck), new Object[0]);
                c = this.webUtil.numUtil.parseInt(line.get(0).get("c").toString(), 0);
                if (c > 0) {
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.dao.update(conf.getString(k).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck));
        }
        for (String k : keys) {
            m = update.matcher(k);
            if (!m.find()) continue;
            ck = m.group(1);
            try {
                line = this.dao.query(conf.getString("sql.check." + ck).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck), new Object[0]);
                c = this.webUtil.numUtil.parseInt(line.get(0).get("c").toString(), 0);
                if (c > 0) {
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.dao.update(conf.getString(k).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck));
        }
    }

    public Map<String, Setting> loadSetting() throws SQLException {
        return this.dao.loadSetting();
    }

    public void saveSetting(Map<String, Setting> setting) {
        this.dao.saveSetting(setting);
    }

    public Tieup loadTieup(long tieupCode) {
        return this.dao.loadTieup(tieupCode);
    }

    public List<Tieup> loadTieup(int offset, int limit, ConditionList conditions) throws SQLException {
        return this.dao.loadTieup(offset, limit, conditions);
    }

    public void saveTieup(Tieup tieup) throws SQLException {
        this.dao.saveTieup(tieup);
    }

    public void deleteTieup(long tieupCode) {
        this.dao.deleteTieup(tieupCode);
    }

    public boolean isAdmin(String userId) throws SQLException {
        Map<String, Setting> nyx = this.loadSetting();
        return NyxManager.isAdmin(nyx, userId);
    }

    public static boolean isAdmin(Map<String, Setting> nyx, String userId) {
        if (nyx == null) {
            return false;
        }
        if (userId.equals(nyx.get("base_admin_main").getValue())) {
            return true;
        }
        if (userId.equals(nyx.get("base_admin_sub1").getValue())) {
            return true;
        }
        return userId.equals(nyx.get("base_admin_sub2").getValue());
    }

    public boolean isPersonalAdmin(String userId) throws SQLException {
        Map<String, Setting> nyx = this.loadSetting();
        return NyxManager.isPersonalAdmin(nyx, userId);
    }

    public static boolean isPersonalAdmin(Map<String, Setting> nyx, String userId) {
        if (userId.equals(nyx.get("base_padmin_main").getValue())) {
            return true;
        }
        if (userId.equals(nyx.get("base_padmin_sub1").getValue())) {
            return true;
        }
        return userId.equals(nyx.get("base_padmin_sub2").getValue());
    }
}

