/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;

public class Site
extends DefaultModel
implements Comparable<Site> {
    private long siteId;
    private String siteName;
    private String siteType = SiteType.TRIGGER.getText();
    private String siteProtocol = "http";
    private String siteHost = "localhost";
    private int sitePort = 80;
    private String sitePath = "/";
    private int sitePriority = 5;
    private Map<String, Ext> param = new TreeMap<String, Ext>();

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return (int)this.siteId;
    }

    @Override
    public int compareTo(Site t) {
        String ns = this.getSiteName();
        String nt = t == null ? "" : t.getSiteName();
        return ns.compareTo(nt);
    }

    public String getSiteHost() {
        return txtUtil.nvl(this.siteHost);
    }

    public void setSiteHost(String siteHost) {
        this.siteHost = siteHost;
    }

    public String getSiteName() {
        return txtUtil.nvl(this.siteName);
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getSitePath() {
        return txtUtil.nvl(this.sitePath);
    }

    public void setSitePath(String sitePath) {
        this.sitePath = sitePath;
    }

    public int getSitePort() {
        return this.sitePort;
    }

    public void setSitePort(int sitePort) {
        this.sitePort = sitePort;
    }

    public String getSiteProtocol() {
        return txtUtil.nvl(this.siteProtocol);
    }

    public void setSiteProtocol(String siteProtocol) {
        this.siteProtocol = siteProtocol;
    }

    public String getSiteType() {
        return txtUtil.nvl(this.siteType);
    }

    public void setSiteType(String siteType) {
        this.siteType = siteType;
    }

    public long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(long siteId) {
        this.siteId = siteId;
    }

    public Map<String, Ext> getParam() {
        return this.param;
    }

    public int getSitePriority() {
        return this.sitePriority;
    }

    public void setSitePriority(int sitePriority) {
        this.sitePriority = sitePriority;
    }

    public static enum SiteParamType {
        VALUE("value", "\u5024", 63),
        LOSEVALUE("losevalue", "\u4e0d\u901a(\u30ad\u30fc\u3092\u8ee2\u9001\u3057\u306a\u3044)", 2),
        UID("uid", "\u30e6\u30fc\u30b6\u30fcID(\u30ad\u30fc\u5024\u6307\u5b9a\u4e0d\u53ef)", 63),
        UPW("upw", "\u30e6\u30fc\u30b6\u30fcPW(\u30ad\u30fc\u5024\u6307\u5b9a\u4e0d\u53ef)", 63),
        PIPE("pipe", "\u53d7\u4fe1\u30ad\u30fc\u5225\u540d\u8ee2\u9001(\u30ad\u30fc\u5024\u304c\u5225\u540d\u30ad\u30fc)", 48),
        USEREXT("userext", "User\u62e1\u5f35\u60c5\u5831\u8ee2\u9001(\u30ad\u30fc\u5024\u304c\u62e1\u5f35\u30ad\u30fc)", 62),
        AUTHEXT("authext", "Auth\u62e1\u5f35\u60c5\u5831\u8ee2\u9001(\u30ad\u30fc\u5024\u304c\u62e1\u5f35\u30ad\u30fc)", 62),
        INFORMHEADER2PARAM("informheader2Param", "\u5bc6\u544a\u5fdc\u7b54\u30d8\u30c3\u30c0\u2192PARAM\u8ee2\u9001(\u30ad\u30fc\u304c\u30d8\u30c3\u30c0\u540d,\u30ad\u30fc\u5024\u304cPARAM\u30ad\u30fc)", 2);

        private String value;
        private String text;
        private int supportSiteType;

        private SiteParamType(String value, String text, int supportSiteType) {
            this.text = text;
            this.value = value;
            this.supportSiteType = supportSiteType;
        }

        public String getText() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }

        public int getSupportSiteType() {
            return this.supportSiteType;
        }

        public boolean isSupportSiteType(SiteType type) {
            return (type.getCode() & this.supportSiteType) > 0;
        }

        public static SiteParamType getSiteParamType(String value) {
            for (SiteParamType t : SiteParamType.values()) {
                if (!t.value.equals(value)) continue;
                return t;
            }
            return VALUE;
        }

        public static Map<String, String> getMap() {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(SiteParamType.VALUE.text, SiteParamType.VALUE.value);
            ret.put(SiteParamType.UID.text, SiteParamType.UID.value);
            ret.put(SiteParamType.UPW.text, SiteParamType.UPW.value);
            ret.put(SiteParamType.PIPE.text, SiteParamType.PIPE.value);
            ret.put(SiteParamType.USEREXT.text, SiteParamType.USEREXT.value);
            ret.put(SiteParamType.AUTHEXT.text, SiteParamType.AUTHEXT.value);
            ret.put(SiteParamType.INFORMHEADER2PARAM.text, SiteParamType.INFORMHEADER2PARAM.value);
            return ret;
        }
    }

    public static enum SiteType {
        TRIGGER("trigger", "\u8a8d\u8a3c\u30b5\u30a4\u30c8", 1),
        VALID("valid", "\u8ee2\u9001\u5148\u30b5\u30a4\u30c8", 2),
        APP("app", "\u30a2\u30d7\u30ea\u30b5\u30a4\u30c8", 4),
        OPERATION("operation", "\u904b\u7528\u7ba1\u7406\u30b5\u30a4\u30c8", 8),
        INFORM("inform", "\u5bc6\u544a\u30b5\u30a4\u30c8", 16),
        FAILER("failer", "\u30a8\u30e9\u30fc\u30b5\u30a4\u30c8", 32);

        private String value;
        private String text;
        private int code = 0;

        private SiteType(String value, String text, int code) {
            this.text = text;
            this.value = value;
            this.code = code;
        }

        public String getText() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }

        public static SiteType getSiteType(String value) {
            for (SiteType t : SiteType.values()) {
                if (!t.value.equals(value)) continue;
                return t;
            }
            return TRIGGER;
        }

        public static Map<String, String> getMap() {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(SiteType.TRIGGER.text, SiteType.TRIGGER.value);
            ret.put(SiteType.VALID.text, SiteType.VALID.value);
            ret.put(SiteType.APP.text, SiteType.APP.value);
            ret.put(SiteType.FAILER.text, SiteType.FAILER.value);
            return ret;
        }
    }
}

