/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalendarUtility {
    private SimpleDateFormat formatter = new SimpleDateFormat();

    public Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public String formatCalendar(Calendar cal, String pattern) {
        this.formatter.applyPattern(pattern);
        return this.formatter.format(cal.getTime());
    }

    public String formatCalendar(Calendar cal, String pattern, Locale locale) {
        SimpleDateFormat f = new SimpleDateFormat(pattern, locale);
        return f.format(cal.getTime());
    }

    public String formatCalendar(Date date, String pattern) {
        this.formatter.applyPattern(pattern);
        return this.formatter.format(date);
    }

    public String formatCalendar(Date date, String pattern, boolean retEmpty) {
        if (retEmpty && date == null) {
            return "";
        }
        this.formatter.applyPattern(pattern);
        return this.formatter.format(date);
    }

    public Calendar parseCalendar(String dateString, String pattern) {
        return this.parseCalendar(dateString, pattern, null);
    }

    public Calendar parseCalendar(String dateString, String pattern, Calendar def) {
        try {
            this.formatter.setLenient(false);
            this.formatter.applyPattern(pattern);
            Date dt = this.formatter.parse(dateString);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dt);
            return cal;
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean canParseCalendar(String dateString, String pattern) {
        try {
            this.formatter.applyPattern(pattern);
            this.formatter.parse(dateString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Calendar parseCalendar(String dateString, String pattern, boolean lenient) throws ParseException {
        this.formatter.setLenient(lenient);
        this.formatter.applyPattern(pattern);
        Date dt = this.formatter.parse(dateString);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal;
    }

    public void chopDay(Calendar cal) {
        cal.set(11, 0);
        this.chopHour(cal);
    }

    public void chopHour(Calendar cal) {
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public Calendar cloneCalendar(Calendar cal) {
        long l = cal.getTimeInMillis();
        Calendar ret = Calendar.getInstance();
        ret.setTimeInMillis(l);
        return ret;
    }

    public String addDay(String dateString, String pattern, int day) throws ParseException {
        Calendar cal = this.parseCalendar(dateString, pattern);
        cal.add(5, day);
        return this.formatCalendar(cal, pattern);
    }

    public Timestamp addDay(Timestamp date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return new Timestamp(cal.getTimeInMillis());
    }

    public java.sql.Date parseDate(String dateString, String pattern) throws ParseException {
        this.formatter.applyPattern(pattern);
        Date dt = this.formatter.parse(dateString);
        return new java.sql.Date(dt.getTime());
    }
}

