/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class IOUtil {
    public static boolean jdk14lator;

    public static void createDirectory(String string) throws IOException {
        IOUtil.createDirectory(new File(string));
    }

    public static void createDirectory(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Directory [" + file + "] creation failed.");
        }
    }

    public static boolean createFile(String string) throws IOException {
        return IOUtil.createFile(new File(string));
    }

    public static boolean createFile(File file) throws IOException {
        File file2 = file.getParentFile();
        IOUtil.createDirectory(file2);
        return file.createNewFile();
    }

    public static boolean delete(String string) throws IOException {
        return IOUtil.delete(new File(string));
    }

    public static boolean delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                IOUtil.delete(fileArray[i]);
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        block11: {
            if (jdk14lator) {
                FileChannel fileChannel = new FileInputStream(file).getChannel();
                FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
                try {
                    int n = (int)fileChannel.size();
                    if (n < 10000000) {
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)fileChannel.size());
                        byteBuffer.clear();
                        fileChannel.read(byteBuffer);
                        byteBuffer.flip();
                        fileChannel2.write(byteBuffer);
                        break block11;
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(10000000);
                    while (true) {
                        byteBuffer.clear();
                        if (fileChannel.read(byteBuffer) < 0) {
                            break block11;
                        }
                        byteBuffer.flip();
                        fileChannel2.write(byteBuffer);
                    }
                }
                finally {
                    fileChannel.close();
                    fileChannel2.close();
                }
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = fileInputStream.read(byArray)) >= 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                fileInputStream.close();
                fileOutputStream.close();
            }
        }
    }

    private IOUtil() {
    }

    static {
        try {
            Class.forName("java.nio.channels.FileChannel");
            jdk14lator = true;
        }
        catch (Exception exception) {
            jdk14lator = false;
        }
    }
}

