/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.pape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.pape.PapeMessage;

public class PapeRequest
extends PapeMessage {
    private static Logger _log = Logger.getLogger((Class)PapeRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List PAPE_FIELDS = Arrays.asList("preferred_auth_policies", "max_auth_age");

    protected PapeRequest() {
        this.set("preferred_auth_policies", "");
        if (DEBUG) {
            _log.debug((Object)"Created empty Pape request.");
        }
    }

    public static PapeRequest createPapeRequest() {
        return new PapeRequest();
    }

    protected PapeRequest(ParameterList params) {
        this._parameters = params;
    }

    public static PapeRequest createPapeRequest(ParameterList params) throws MessageException {
        PapeRequest req = new PapeRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a PAPE request");
        }
        if (DEBUG) {
            _log.debug((Object)("Created PAPE request from parameter list:\n" + params));
        }
        return req;
    }

    public String getPreferredAuthPolicies() {
        return this.getParameterValue("preferred_auth_policies");
    }

    public void setPreferredAuthPolicies(String policyUris) {
        this.set("preferred_auth_policies", policyUris);
    }

    public void addPreferredAuthPolicy(String policyUri) {
        String policies = this.getPreferredAuthPolicies();
        if (policies == null || policies.length() == 0) {
            this.setPreferredAuthPolicies(policyUri);
        } else {
            this.setPreferredAuthPolicies(policies + " " + policyUri);
        }
    }

    public List getPreferredAuthPoliciesList() {
        String policies = this.getParameterValue("preferred_auth_policies");
        if (policies != null) {
            return Arrays.asList(policies.split(" "));
        }
        return new ArrayList();
    }

    public void setMaxAuthAge(int seconds) {
        this.set("max_auth_age", Integer.toString(seconds));
    }

    public int getMaxAuthAge() {
        String maxAuthAge = this.getParameterValue("max_auth_age");
        if (maxAuthAge != null) {
            return Integer.parseInt(maxAuthAge);
        }
        return -1;
    }

    public boolean isValid() {
        if (!this._parameters.hasParameter("preferred_auth_policies")) {
            _log.warn((Object)"preferred_auth_policies is required in a PAPE request.");
            return false;
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (PAPE_FIELDS.contains(paramName)) continue;
            _log.warn((Object)("Invalid parameter name in PAPE request: " + paramName));
            return false;
        }
        return true;
    }
}

