/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.openid4java.OpenIDException;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.association.DiffieHellmanSession;
import org.openid4java.message.AssociationError;
import org.openid4java.message.AssociationRequest;
import org.openid4java.message.AssociationResponse;
import org.openid4java.message.AuthFailure;
import org.openid4java.message.AuthImmediateFailure;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.IndirectError;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.message.VerifyRequest;
import org.openid4java.message.VerifyResponse;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.IncrementalNonceGenerator;
import org.openid4java.server.NonceGenerator;
import org.openid4java.server.RealmVerifier;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerException;

public class ServerManager {
    private static Logger _log = Logger.getLogger((Class)ServerManager.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private ServerAssociationStore _sharedAssociations = new InMemoryServerAssociationStore();
    private ServerAssociationStore _privateAssociations = new InMemoryServerAssociationStore();
    private NonceGenerator _nonceGenerator = new IncrementalNonceGenerator();
    private AssociationSessionType _minAssocSessEnc = AssociationSessionType.NO_ENCRYPTION_SHA1MAC;
    private AssociationSessionType _prefAssocSessEnc = AssociationSessionType.DH_SHA256;
    private int _expireIn = 1800;
    private String _userSetupUrl = null;
    private String _signFields;
    private String[] _signExtensions;
    private RealmVerifier _realmVerifier = new RealmVerifier();
    private String _opEndpointUrl;

    public ServerAssociationStore getSharedAssociations() {
        return this._sharedAssociations;
    }

    public void setSharedAssociations(ServerAssociationStore sharedAssociations) {
        this._sharedAssociations = sharedAssociations;
    }

    public ServerAssociationStore getPrivateAssociations() {
        return this._privateAssociations;
    }

    public void setPrivateAssociations(ServerAssociationStore privateAssociations) {
        this._privateAssociations = privateAssociations;
    }

    public AssociationSessionType getMinAssocSessEnc() {
        return this._minAssocSessEnc;
    }

    public NonceGenerator getNonceGenerator() {
        return this._nonceGenerator;
    }

    public void setNonceGenerator(NonceGenerator nonceGenerator) {
        this._nonceGenerator = nonceGenerator;
    }

    public void setMinAssocSessEnc(AssociationSessionType minAssocSessEnc) {
        this._minAssocSessEnc = minAssocSessEnc;
    }

    public AssociationSessionType getPrefAssocSessEnc() {
        return this._prefAssocSessEnc;
    }

    public void setPrefAssocSessEnc(AssociationSessionType type) throws ServerException {
        if (!Association.isHmacSupported(type.getAssociationType()) || !DiffieHellmanSession.isDhSupported(type)) {
            throw new ServerException("Unsupported association / session type: " + type.getSessionType() + " : " + type.getAssociationType());
        }
        if (this._minAssocSessEnc.isBetter(type)) {
            throw new ServerException("Minimum encryption settings cannot be better than the preferred");
        }
        this._prefAssocSessEnc = type;
    }

    public int getExpireIn() {
        return this._expireIn;
    }

    public void setExpireIn(int _expireIn) {
        this._expireIn = _expireIn;
    }

    public String getUserSetupUrl() {
        return this._userSetupUrl;
    }

    public void setUserSetupUrl(String userSetupUrl) {
        this._userSetupUrl = userSetupUrl;
    }

    public void setSignFields(String signFields) {
        this._signFields = signFields;
    }

    public String getSignFields() {
        return this._signFields;
    }

    public void setSignExtensions(String[] extensins) {
        this._signExtensions = extensins;
    }

    public String[] getSignExtensions() {
        return this._signExtensions;
    }

    public RealmVerifier getRealmVerifier() {
        return this._realmVerifier;
    }

    public void setRealmVerifier(RealmVerifier realmVerifier) {
        this._realmVerifier = realmVerifier;
    }

    public String getOPEndpointUrl() {
        return this._opEndpointUrl;
    }

    public void setOPEndpointUrl(String opEndpointUrl) {
        this._opEndpointUrl = opEndpointUrl;
    }

    public Message associationResponse(ParameterList requestParams) {
        boolean isVersion2 = requestParams.hasParameter("openid.ns");
        _log.info((Object)"Processing association request...");
        try {
            AssociationRequest assocReq = AssociationRequest.createAssociationRequest(requestParams);
            isVersion2 = assocReq.isVersion2();
            AssociationSessionType type = assocReq.getType();
            if (!Association.isHmacSupported(type.getAssociationType()) || !DiffieHellmanSession.isDhSupported(type) || this._minAssocSessEnc.isBetter(type)) {
                throw new AssociationException("Unable create association for: " + type.getSessionType() + " / " + type.getAssociationType());
            }
            Association assoc = this._sharedAssociations.generate(type.getAssociationType(), this._expireIn);
            _log.info((Object)("Returning shared association; handle: " + assoc.getHandle()));
            return AssociationResponse.createAssociationResponse(assocReq, assoc);
        }
        catch (OpenIDException e) {
            if (isVersion2) {
                _log.warn((Object)"Cannot establish association, responding with an OpenID2 association error.", (Throwable)e);
                return AssociationError.createAssociationError(e.getMessage(), this._prefAssocSessEnc);
            }
            _log.warn((Object)"Error processing an OpenID1 association request; responding with a dummy association", (Throwable)e);
            try {
                Association dummyAssoc = this._sharedAssociations.generate("HMAC-SHA1", 0);
                AssociationRequest dummyRequest = AssociationRequest.createAssociationRequest(AssociationSessionType.NO_ENCRYPTION_COMPAT_SHA1MAC);
                return AssociationResponse.createAssociationResponse(dummyRequest, dummyAssoc);
            }
            catch (OpenIDException ee) {
                _log.error((Object)"Error creating negative OpenID1 association response.", (Throwable)e);
                return null;
            }
        }
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved) {
        return this.authResponse(requestParams, userSelId, userSelClaimed, authenticatedAndApproved, this._opEndpointUrl, true);
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, boolean signNow) {
        return this.authResponse(requestParams, userSelId, userSelClaimed, authenticatedAndApproved, this._opEndpointUrl, signNow);
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, String opEndpoint) {
        return this.authResponse(requestParams, userSelId, userSelClaimed, authenticatedAndApproved, opEndpoint, true);
    }

    public Message authResponse(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, String opEndpoint, boolean signNow) {
        _log.info((Object)"Processing authentication request...");
        boolean isVersion2 = true;
        try {
            new URL(opEndpoint);
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Invalid OP-endpoint configured; cannot issue OpenID authentication responses." + opEndpoint));
            return DirectError.createDirectError("Invalid OpenID Provider endpoint URL; cannot issue authentication response", isVersion2);
        }
        try {
            String claimed;
            String id;
            AuthRequest authReq = AuthRequest.createAuthRequest(requestParams, this._realmVerifier);
            isVersion2 = authReq.isVersion2();
            if (authReq.getReturnTo() == null) {
                _log.error((Object)"Received valid auth request, but no return_to specified; authResponse() should not be called.");
                return null;
            }
            if ("http://specs.openid.net/auth/2.0/identifier_select".equals(authReq.getIdentity())) {
                id = userSelId;
                claimed = userSelClaimed;
            } else {
                id = userSelId != null ? userSelId : authReq.getIdentity();
                String string = claimed = userSelClaimed != null ? userSelClaimed : authReq.getClaimed();
            }
            if (id == null) {
                throw new ServerException("No identifier provided by the authntication requestor by the OpenID Provider");
            }
            if (DEBUG) {
                _log.debug((Object)("Using ClaimedID: " + claimed + " OP-specific ID: " + id));
            }
            if (authenticatedAndApproved) {
                Association assoc = null;
                String handle = authReq.getHandle();
                String invalidateHandle = null;
                if (handle != null) {
                    assoc = this._sharedAssociations.load(handle);
                    if (assoc == null) {
                        _log.info((Object)("Invalidating handle: " + handle));
                        invalidateHandle = handle;
                    } else {
                        _log.info((Object)("Loaded shared association; handle: " + handle));
                    }
                }
                if (assoc == null) {
                    assoc = this._privateAssociations.generate(this._prefAssocSessEnc.getAssociationType(), this._expireIn);
                    _log.info((Object)("Generated private association; handle: " + assoc.getHandle()));
                }
                AuthSuccess response = AuthSuccess.createAuthSuccess(opEndpoint, claimed, id, !isVersion2, authReq.getReturnTo(), isVersion2 ? this._nonceGenerator.next() : null, invalidateHandle, assoc, false);
                if (this._signFields != null) {
                    response.setSignFields(this._signFields);
                }
                if (this._signExtensions != null) {
                    response.setSignExtensions(this._signExtensions);
                }
                if (signNow) {
                    response.setSignature(assoc.sign(response.getSignedText()));
                }
                _log.info((Object)("Returning positive assertion for " + response.getReturnTo()));
                return response;
            }
            if (authReq.isImmediate()) {
                _log.error((Object)("Responding with immediate authentication failure to " + authReq.getReturnTo()));
                return AuthImmediateFailure.createAuthImmediateFailure(this._userSetupUrl, authReq.getReturnTo(), !isVersion2);
            }
            _log.error((Object)("Responding with authentication failure to " + authReq.getReturnTo()));
            return new AuthFailure(!isVersion2, authReq.getReturnTo());
        }
        catch (OpenIDException e) {
            if (requestParams.hasParameter("openid.return_to")) {
                _log.error((Object)"Error processing an authentication request; responding with an indirect error message.", (Throwable)e);
                return IndirectError.createIndirectError(e.getMessage(), requestParams.getParameterValue("openid.return_to"), !isVersion2);
            }
            _log.error((Object)"Error processing an authentication request; responding with an direct error message.", (Throwable)e);
            return DirectError.createDirectError(e.getMessage(), isVersion2);
        }
    }

    public void sign(Message msg) throws ServerException, AssociationException {
        if (!(msg instanceof AuthSuccess)) {
            throw new ServerException("Cannot sign message of type: " + msg.getClass());
        }
        AuthSuccess authResp = (AuthSuccess)msg;
        String handle = authResp.getHandle();
        Association assoc = this._sharedAssociations.load(handle);
        if (assoc == null) {
            assoc = this._privateAssociations.load(handle);
        }
        if (assoc == null) {
            throw new ServerException("No association found for handle: " + handle);
        }
        authResp.setSignature(assoc.sign(authResp.getSignedText()));
    }

    public Message verify(ParameterList requestParams) {
        _log.info((Object)"Processing verification request...");
        boolean isVersion2 = true;
        try {
            VerifyRequest vrfyReq = VerifyRequest.createVerifyRequest(requestParams);
            isVersion2 = vrfyReq.isVersion2();
            String handle = vrfyReq.getHandle();
            boolean verified = false;
            Association assoc = this._privateAssociations.load(handle);
            if (assoc != null) {
                _log.info((Object)("Loaded private association; handle: " + handle));
                verified = assoc.verifySignature(vrfyReq.getSignedText(), vrfyReq.getSignature());
                this._privateAssociations.remove(handle);
            }
            VerifyResponse vrfyResp = VerifyResponse.createVerifyResponse(!vrfyReq.isVersion2());
            vrfyResp.setSignatureVerified(verified);
            if (verified) {
                String invalidateHandle = vrfyReq.getInvalidateHandle();
                if (invalidateHandle != null && this._sharedAssociations.load(invalidateHandle) == null) {
                    _log.info((Object)("Confirming shared association invalidate handle: " + invalidateHandle));
                    vrfyResp.setInvalidateHandle(invalidateHandle);
                }
            } else {
                _log.error((Object)("Signature verification failed, handle: " + handle));
            }
            _log.info((Object)("Responding with " + (verified ? "positive" : "negative") + " verification response"));
            return vrfyResp;
        }
        catch (OpenIDException e) {
            _log.error((Object)"Error processing verification request; responding with verificatioin error.", (Throwable)e);
            return DirectError.createDirectError(e.getMessage(), !isVersion2);
        }
    }
}

