/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BlobOutputStream;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;

public class Blob
extends Lob
implements java.sql.Blob {
    byte[] binaryString_ = null;
    InputStream binaryStream_ = null;
    int dataOffset_;

    public Blob(byte[] byArray, Agent agent, int n) {
        super(agent);
        this.binaryString_ = byArray;
        this.dataType_ |= 0x40;
        this.sqlLength_ = byArray.length - n;
        this.lengthObtained_ = true;
        this.dataOffset_ = n;
    }

    public Blob(Agent agent, InputStream inputStream, int n) {
        super(agent);
        this.binaryStream_ = inputStream;
        this.dataType_ |= 0x20;
        this.sqlLength_ = n;
        this.lengthObtained_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "length");
            }
            long l = super.sqlLength();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "length", l);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBytes", (int)l, n);
            }
            if (l <= 0L || n < 0) {
                throw new SqlException(this.agent_.logWriter_, "Invalid position " + l + " or length " + n);
            }
            byte[] byArray = this.getBytesX(l, n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
            }
            return byArray;
        }
    }

    private byte[] getBytesX(long l, int n) throws SqlException {
        this.checkForClosedConnection();
        long l2 = Math.min(this.length() - l + 1L, (long)n);
        byte[] byArray = new byte[(int)l2];
        System.arraycopy(this.binaryString_, (int)l + this.dataOffset_ - 1, byArray, 0, (int)l2);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBinaryStream");
            }
            InputStream inputStream = this.getBinaryStreamX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", inputStream);
            }
            return inputStream;
        }
    }

    private InputStream getBinaryStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isBinaryStream()) {
            return this.binaryStream_;
        }
        return new ByteArrayInputStream(this.binaryString_, this.dataOffset_, this.binaryString_.length - this.dataOffset_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] byArray, long l) throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "position(byte[], long)", (Object)byArray, l);
            }
            if (byArray == null) {
                throw new SqlException(this.agent_.logWriter_, "Search pattern cannot be null.");
            }
            long l2 = this.positionX(byArray, l);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "position(byte[], long)", l2);
            }
            return l2;
        }
    }

    private long positionX(byte[] byArray, long l) throws SqlException {
        this.checkForClosedConnection();
        return this.binaryStringPosition(byArray, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(java.sql.Blob blob, long l) throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "position(Blob, long)", (Object)blob, l);
            }
            if (blob == null) {
                throw new SqlException(this.agent_.logWriter_, "Search pattern cannot be null.");
            }
            long l2 = this.positionX(blob, l);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "position(Blob, long)", l2);
            }
            return l2;
        }
    }

    private long positionX(java.sql.Blob blob, long l) throws SqlException {
        this.checkForClosedConnection();
        try {
            return this.binaryStringPosition(blob.getBytes(1L, (int)blob.length()), l);
        }
        catch (SQLException sQLException) {
            throw new SqlException(this.agent_.logWriter_, sQLException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray) throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBytes", (int)l, byArray);
            }
            int n = this.setBytesX(l, byArray, 0, byArray.length);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "setBytes", n);
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBytes", (int)l, (Object)byArray, n, n2);
            }
            int n3 = this.setBytesX(l, byArray, n, n2);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "setBytes", n3);
            }
            return n3;
        }
    }

    public int setBytesX(long l, byte[] byArray, int n, int n2) throws SqlException {
        int n3 = 0;
        if ((int)l <= 0 || l > (long)(this.binaryString_.length - this.dataOffset_)) {
            throw new SqlException(this.agent_.logWriter_, "Invalid position " + l + " , offset " + n + " or length " + n2);
        }
        if (n < 0 || n > byArray.length || n2 < 0) {
            throw new SqlException(this.agent_.logWriter_, "Invalid position " + l + " , offset " + n + " or length " + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        n3 = Math.min(byArray.length - n, n2);
        if (this.binaryString_.length - this.dataOffset_ - (int)l + 1 < n3) {
            byte[] byArray2 = new byte[(int)l + n3 + this.dataOffset_ - 1];
            System.arraycopy(this.binaryString_, 0, byArray2, 0, this.binaryString_.length);
            this.binaryString_ = byArray2;
        }
        System.arraycopy(byArray, n, this.binaryString_, (int)l + this.dataOffset_ - 1, n3);
        this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
        this.sqlLength_ = this.binaryString_.length - this.dataOffset_;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setBinaryStream(long l) throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", (int)l);
            }
            BlobOutputStream blobOutputStream = new BlobOutputStream(this, l);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "setBinaryStream", blobOutputStream);
            }
            return blobOutputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SqlException {
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, " truncate", (int)l);
            }
            if (l < 0L || l > this.length()) {
                throw new SqlException(this.agent_.logWriter_, "Invalid length " + l);
            }
            if (l == this.length()) {
                return;
            }
            long l2 = (int)l + this.dataOffset_;
            byte[] byArray = new byte[(int)l + this.dataOffset_];
            System.arraycopy(this.binaryString_, 0, byArray, 0, (int)l2);
            this.binaryString_ = byArray;
            this.binaryStream_ = new ByteArrayInputStream(this.binaryString_);
            this.sqlLength_ = this.binaryString_.length - this.dataOffset_;
        }
    }

    public boolean isBinaryString() {
        return (this.dataType_ & 0x40) == 64;
    }

    public boolean isBinaryStream() {
        return (this.dataType_ & 0x20) == 32;
    }

    public byte[] getBinaryString() {
        return this.binaryString_;
    }

    protected long binaryStringPosition(byte[] byArray, long l) {
        int n = (int)l + this.dataOffset_ - 1;
        while (n + byArray.length <= this.binaryString_.length) {
            if (this.isSubString(byArray, n)) {
                return n - this.dataOffset_ + 1;
            }
            ++n;
        }
        return -1L;
    }

    protected boolean isSubString(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != this.binaryString_[n]) {
                return false;
            }
            ++n2;
            ++n;
        }
        return true;
    }
}

