/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.MailUtility;
import com.sk_jp.mail.Retriever;
import com.sk_jp.mail.Sender;
import java.util.Properties;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailSession {
    private Properties account = new Properties();
    private Session session = Session.getInstance((Properties)this.account, null);
    private InternetAddress localAddress;
    private Retriever retriever;
    private Sender sender;
    private String storePassword = null;
    private String transportPassword = null;

    public MailSession(String string) throws AddressException {
        this(MailUtility.parseAddresses(string)[0]);
    }

    public MailSession(InternetAddress internetAddress) {
        this.localAddress = internetAddress;
        String string = internetAddress.getAddress();
        if (string.indexOf(64) == -1) {
            throw new IllegalArgumentException("Bad address:" + string);
        }
        this.account.put("mail.from", string);
        this.account.put("mail.user", string.substring(0, string.lastIndexOf(64)));
        this.account.put("mail.host", string.substring(string.lastIndexOf(64) + 1));
        this.session.setDebug(Boolean.getBoolean("mail.debug"));
    }

    public InternetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void useSMTPAuth(boolean bl) {
        this.account.put("mail.smtp.auth", String.valueOf(bl));
    }

    public void setTransportAccount(String string, String string2) {
        this.setTransportAccount(string, string2, -1, null, null);
    }

    public void setTransportAccount(String string, String string2, int n, String string3, String string4) {
        if (string == null) {
            string = "smtp";
        }
        this.account.put("mail.transport.protocol", string);
        this.setAccount(string, string2, n, string3);
        this.transportPassword = string4;
    }

    public void setStoreAccount(String string, String string2, int n, String string3, String string4) {
        if (string == null) {
            string = "imap";
        }
        this.account.put("mail.store.protocol", string);
        this.setAccount(string, string2, n, string3);
        this.storePassword = string4;
    }

    private void setAccount(String string, String string2, int n, String string3) {
        if (string2 != null) {
            this.account.put("mail." + string + ".host", string2);
        }
        if (n != -1) {
            this.account.put("mail." + string + ".port", String.valueOf(n));
        }
        if (string3 != null) {
            this.account.put("mail." + string + ".user", string3);
        }
    }

    public Retriever getRetriever() throws NoSuchProviderException {
        if (this.retriever == null) {
            this.retriever = new Retriever(this, this.session.getStore());
        }
        return this.retriever;
    }

    public Sender getSender() throws NoSuchProviderException {
        if (this.sender == null) {
            this.sender = new Sender(this, this.session, this.session.getTransport());
        }
        return this.sender;
    }

    public Sender getSender(String string) throws NoSuchProviderException {
        this.setTransportAccount(null, string);
        return this.getSender();
    }

    public String getTransportProtocol() {
        return this.account.getProperty("mail.transport.protocol");
    }

    public String getStoreProtocol() {
        return this.account.getProperty("mail.store.protocol");
    }

    public String getTransportHost() {
        String string = this.account.getProperty("mail." + this.getTransportProtocol() + ".host");
        if (string == null) {
            string = this.account.getProperty("mail.host");
        }
        return string;
    }

    public String getStoreHost() {
        String string = this.account.getProperty("mail." + this.getStoreProtocol() + ".host");
        if (string == null) {
            string = this.account.getProperty("mail.host");
        }
        return string;
    }

    public String getTransportUser() {
        String string = this.account.getProperty("mail." + this.getTransportProtocol() + ".user");
        if (string == null) {
            string = this.account.getProperty("mail.user");
        }
        return string;
    }

    public String getStoreUser() {
        String string = this.account.getProperty("mail." + this.getStoreProtocol() + ".user");
        if (string == null) {
            string = this.account.getProperty("mail.user");
        }
        return string;
    }

    String getTransportPassword() {
        return this.transportPassword;
    }

    String getStorePassword() {
        return this.storePassword;
    }
}

