/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.db;

import com.sk_jp.util.ArrayIterator;
import com.sk_jp.util.NestedException;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Record
extends HashMap {
    private String[] columnNames;

    public Record() {
    }

    public Record(Map map) {
        this.putAll(map);
    }

    public Record(Map map, String[] stringArray) {
        this.putAll(map);
        this.setColumnNames(stringArray);
    }

    public Record(String[] stringArray) {
        this.setColumnNames(stringArray);
    }

    public final void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    protected final String[] getColumnNames() {
        return this.columnNames;
    }

    public int getInteger(int n) {
        if (this.columnNames == null) {
            throw new UnsupportedOperationException();
        }
        return this.getInteger(this.columnNames[n]);
    }

    public int getInteger(String string) {
        try {
            return (Integer)this.get(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(this.get(string).toString());
        }
    }

    public boolean getBoolean(int n) {
        if (this.columnNames == null) {
            throw new UnsupportedOperationException();
        }
        return this.getBoolean(this.columnNames[n]);
    }

    public boolean getBoolean(String string) {
        Object v = this.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return Boolean.valueOf(v.toString());
    }

    public double getDouble(int n) {
        if (this.columnNames == null) {
            throw new UnsupportedOperationException();
        }
        return this.getDouble(this.columnNames[n]);
    }

    public double getDouble(String string) {
        try {
            return (Double)this.get(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.parseDouble(this.get(string).toString());
        }
    }

    public String getString(int n) {
        if (this.columnNames == null) {
            throw new UnsupportedOperationException();
        }
        return this.getString(this.columnNames[n]);
    }

    public String getString(String string) {
        return (String)this.get(string);
    }

    public Object get(int n) {
        if (this.columnNames == null) {
            throw new UnsupportedOperationException();
        }
        return this.get(this.columnNames[n]);
    }

    public int put(String string, int n) {
        int n2 = this.getInteger(string);
        this.put(string, new Integer(n));
        return n2;
    }

    public boolean put(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        this.put(string, new Boolean(bl));
        return bl2;
    }

    public double put(String string, double d) {
        double d2 = this.getDouble(string);
        this.put(string, new Double(d));
        return d2;
    }

    public String put(String string, String string2) {
        return this.put(string, string2);
    }

    public String toSerializedString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayIterator arrayIterator = this.columnNames == null ? this.keySet().iterator() : new ArrayIterator(this.columnNames);
        if (arrayIterator.hasNext()) {
            string = (String)arrayIterator.next();
            stringBuffer.append(string).append('=').append(this.getString(string));
        }
        while (arrayIterator.hasNext()) {
            string = (String)arrayIterator.next();
            stringBuffer.append(',').append(string).append('=').append(this.getString(string));
        }
        return new String(stringBuffer);
    }

    public void parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            String string3 = string2.substring(0, n);
            this.put(string3, this.getCanonicalObject(string3, string2.substring(n + 1)));
        }
    }

    protected Object getCanonicalObject(String string, String string2) {
        return string2;
    }

    public void parseResultSet(ResultSet resultSet) {
    }

    public void updateResultSet(ResultSet resultSet) {
    }

    public void setObject(Object object) {
        Class<?> clazz = object.getClass();
        this.put("class", clazz.getName());
    }

    public Object toObject() throws NestedException {
        try {
            Class<?> clazz = Class.forName((String)this.get("class"));
            Object obj = clazz.newInstance();
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if ("class".equals(k)) continue;
                System.out.println("iteration:" + k);
            }
            return obj;
        }
        catch (Exception exception) {
            throw new NestedException("Object Construction failed.", exception);
        }
    }
}

