/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.storeconfig.IStoreConfig;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFileMover;
import org.apache.catalina.storeconfig.StoreRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreConfig
implements IStoreConfig {
    private static Log log = LogFactory.getLog((Class)StoreConfig.class);
    private String serverFilename = "conf/server.xml";
    private StoreRegistry registry;

    public String getServerFilename() {
        return this.serverFilename;
    }

    public void setServerFilename(String string) {
        this.serverFilename = string;
    }

    public StoreRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(StoreRegistry aRegistry) {
        this.registry = aRegistry;
    }

    public synchronized void storeConfig() {
        this.store(ServerFactory.getServer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeServer(String aServerName, boolean backup, boolean externalAllowed) throws MalformedObjectNameException {
        block10: {
            ObjectName objectName;
            if (aServerName == null || aServerName.length() == 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Please, call with a correct server ObjectName!");
                }
                return;
            }
            MBeanServer mserver = MBeanUtils.createServer();
            if (mserver.isRegistered(objectName = new ObjectName(aServerName))) {
                try {
                    Server aServer = (Server)mserver.getAttribute(objectName, "managedResource");
                    StoreDescription desc = null;
                    desc = this.getRegistry().findDescription(StandardContext.class);
                    if (desc != null) {
                        boolean oldSeparate = desc.isStoreSeparate();
                        boolean oldBackup = desc.isBackup();
                        boolean oldExternalAllowed = desc.isExternalAllowed();
                        try {
                            desc.setStoreSeparate(true);
                            desc.setBackup(backup);
                            desc.setExternalAllowed(externalAllowed);
                            this.store(aServer);
                            Object var12_12 = null;
                            desc.setStoreSeparate(oldSeparate);
                            desc.setBackup(oldBackup);
                            desc.setExternalAllowed(oldExternalAllowed);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var12_13 = null;
                            desc.setStoreSeparate(oldSeparate);
                            desc.setBackup(oldBackup);
                            desc.setExternalAllowed(oldExternalAllowed);
                            throw throwable;
                        }
                    }
                    this.store(aServer);
                }
                catch (Exception e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Object " + aServerName + " is no a Server instance or store exception"), (Throwable)e);
                    }
                    break block10;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Server " + aServerName + " not found!"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeContext(String aContextName, boolean backup, boolean externalAllowed) throws MalformedObjectNameException {
        block12: {
            ObjectName objectName;
            if (aContextName == null || aContextName.length() == 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Please, call with a correct context ObjectName!");
                }
                return;
            }
            MBeanServer mserver = MBeanUtils.createServer();
            if (mserver.isRegistered(objectName = new ObjectName(aContextName))) {
                try {
                    Context aContext = (Context)mserver.getAttribute(objectName, "managedResource");
                    String configFile = aContext.getConfigFile();
                    if (configFile != null) {
                        try {
                            StoreDescription desc = null;
                            desc = this.getRegistry().findDescription(aContext.getClass());
                            if (desc == null) break block12;
                            boolean oldSeparate = desc.isStoreSeparate();
                            boolean oldBackup = desc.isBackup();
                            boolean oldExternalAllowed = desc.isExternalAllowed();
                            try {
                                desc.setStoreSeparate(true);
                                desc.setBackup(backup);
                                desc.setExternalAllowed(externalAllowed);
                                desc.getStoreFactory().store(null, -2, aContext);
                                Object var13_14 = null;
                                desc.setStoreSeparate(oldSeparate);
                                desc.setBackup(oldBackup);
                                desc.setBackup(oldExternalAllowed);
                                break block12;
                            }
                            catch (Throwable throwable) {
                                Object var13_15 = null;
                                desc.setStoreSeparate(oldSeparate);
                                desc.setBackup(oldBackup);
                                desc.setBackup(oldExternalAllowed);
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                        break block12;
                    }
                    log.error((Object)("Missing configFile at Context " + aContext.getPath() + " to store!"));
                }
                catch (Exception e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Object " + aContextName + " is no a context instance or store exception"), (Throwable)e);
                    }
                    break block12;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Context " + aContextName + " not found!"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(Server aServer) {
        StoreFileMover mover = new StoreFileMover(System.getProperty("catalina.base"), this.getServerFilename(), this.getRegistry().getEncoding());
        try {
            PrintWriter writer = mover.getWriter();
            try {
                this.store(writer, -2, aServer);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    writer.flush();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                writer.close();
                throw throwable;
            }
            try {
                writer.flush();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            writer.close();
            mover.move();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(Context aContext) {
        block7: {
            String configFile = aContext.getConfigFile();
            if (configFile != null) {
                try {
                    StoreDescription desc = null;
                    desc = this.getRegistry().findDescription(aContext.getClass());
                    if (desc == null) break block7;
                    boolean old = desc.isStoreSeparate();
                    try {
                        desc.setStoreSeparate(true);
                        desc.getStoreFactory().store(null, -2, aContext);
                    }
                    finally {
                        desc.setStoreSeparate(old);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            } else {
                log.error((Object)("Missing configFile at Context " + aContext.getPath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(PrintWriter aWriter, int indent, Context aContext) {
        boolean oldSeparate = true;
        StoreDescription desc = null;
        try {
            desc = this.getRegistry().findDescription(aContext.getClass());
            oldSeparate = desc.isStoreSeparate();
            desc.setStoreSeparate(false);
            desc.getStoreFactory().store(aWriter, indent, aContext);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (desc != null) {
                desc.setStoreSeparate(oldSeparate);
            }
        }
    }

    public synchronized void store(PrintWriter aWriter, int indent, Host aHost) {
        try {
            StoreDescription desc = this.getRegistry().findDescription(aHost.getClass());
            desc.getStoreFactory().store(aWriter, indent, aHost);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public synchronized void store(PrintWriter aWriter, int indent, Service aService) {
        try {
            StoreDescription desc = this.getRegistry().findDescription(aService.getClass());
            desc.getStoreFactory().store(aWriter, indent, aService);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public synchronized void store(PrintWriter writer, int indent, Server aServer) {
        try {
            StoreDescription desc = this.getRegistry().findDescription(aServer.getClass());
            desc.getStoreFactory().store(writer, indent, aServer);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

