/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.sound;

import com.sk_jp.sound.SKClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SKSourceSoundClip
implements SKClip {
    private String name;
    private byte[] bytes;
    private AudioFormat format;
    private SourceDataLine line;
    private BooleanControl muteControl;
    private FloatControl panControl;
    private FloatControl sampleRateControl;
    private FloatControl volumeControl;
    volatile Thread t;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public SKSourceSoundClip(URL uRL) throws IOException {
        this(new BufferedInputStream(uRL.openStream()), uRL.toString());
    }

    public SKSourceSoundClip(InputStream inputStream, String string) throws IOException {
        this.name = string;
        this.init(inputStream);
    }

    public SKSourceSoundClip(byte[] byArray, String string) {
        this.name = string;
        try {
            this.init(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    private void init(InputStream inputStream) throws IOException {
        try {
            int n;
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            byte[] byArray = new byte[2048];
            while ((n = audioInputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.bytes = byteArrayOutputStream.toByteArray();
            this.init(audioInputStream.getFormat());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public SKSourceSoundClip(SKClip sKClip) {
        this.name = sKClip.getName();
        this.bytes = ((SKSourceSoundClip)sKClip).bytes;
        try {
            this.init(((SKSourceSoundClip)sKClip).format);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new RuntimeException(lineUnavailableException.toString());
        }
    }

    public byte[] getData() {
        return this.bytes;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    private void init(AudioFormat audioFormat) throws LineUnavailableException {
        this.format = audioFormat;
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SKSourceSoundClip.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        this.line.open(audioFormat, this.bytes.length + 1);
        this.line.start();
        this.muteControl = (BooleanControl)this.line.getControl(BooleanControl.Type.MUTE);
        this.panControl = (FloatControl)this.line.getControl(FloatControl.Type.PAN);
        this.sampleRateControl = (FloatControl)this.line.getControl(FloatControl.Type.SAMPLE_RATE);
        this.volumeControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.line.stop();
        this.line.close();
    }

    public void setMute(boolean bl) {
        this.muteControl.setValue(bl);
    }

    public void setPan(float f) {
        this.panControl.setValue(f);
    }

    public void setSampleRate(float f) {
        this.sampleRateControl.setValue(f);
    }

    public void setVolume(float f) {
        this.volumeControl.setValue(f);
    }

    public void play(int n) {
        if (Boolean.getBoolean("sound.mute")) {
            return;
        }
        this.line.flush();
        this.line.write(this.bytes, n, this.bytes.length - n);
    }

    public void play() {
        if (Boolean.getBoolean("sound.mute")) {
            return;
        }
        this.line.flush();
        this.line.write(this.bytes, 0, this.bytes.length);
    }

    public void loop() {
        if (Boolean.getBoolean("sound.mute")) {
            return;
        }
        this.t = new Thread(){

            public void run() {
                while (SKSourceSoundClip.this.t != null) {
                    SKSourceSoundClip.this.line.write(SKSourceSoundClip.this.bytes, 0, SKSourceSoundClip.this.bytes.length);
                }
            }
        };
        this.t.start();
    }

    public void stop() {
        this.t = null;
        this.line.flush();
        Thread.yield();
        this.line.flush();
    }

    protected void finalize() {
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

