/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class NodeReplaceHandler
extends DefaultHandler {
    private Stack stack_ = new Stack();
    private PrintWriter writer_;
    private String encoding_;
    private Map replaces_;

    public NodeReplaceHandler(OutputStream outputStream, String string, Map map) throws UnsupportedEncodingException {
        this.writer_ = new PrintWriter(new OutputStreamWriter(outputStream, string));
        this.encoding_ = string;
        this.replaces_ = map;
    }

    public void startDocument() {
        this.writer_.print("<?xml version=\"1.0\"");
        if (this.encoding_ != null) {
            this.writer_.print(" encoding=\"" + this.encoding_ + "\"");
        }
        this.writer_.println("?>");
    }

    public void endDocument() {
        this.writer_.flush();
    }

    public void startElement(String string, Attributes attributes) {
        this.tagEndCheck();
        Object v = this.replaces_.get(string);
        if (v != null) {
            this.stack_.push(new CurrentElement(string, true));
            this.writer_.print(v);
            return;
        }
        this.stack_.push(new CurrentElement(string, false));
        this.writer_.print('<');
        this.writer_.print(string);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.writer_.print(' ');
            this.writer_.print(attributes.getQName(i));
            this.writer_.print("=\"");
            this.writer_.print(attributes.getValue(i));
            this.writer_.print('\"');
        }
    }

    public void endElement(String string) {
        CurrentElement currentElement = (CurrentElement)this.stack_.pop();
        if (currentElement.replaced) {
            return;
        }
        if (!currentElement.hasChild) {
            this.writer_.print(" />");
            return;
        }
        this.writer_.print("</");
        this.writer_.print(string);
        this.writer_.print('>');
    }

    public void characters(char[] cArray, int n, int n2) {
        this.tagEndCheck();
        this.writer_.write(cArray, n, n2);
    }

    private void tagEndCheck() {
        try {
            CurrentElement currentElement = (CurrentElement)this.stack_.peek();
            if (!currentElement.hasChild) {
                currentElement.hasChild = true;
                this.writer_.print('>');
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private class CurrentElement {
        final String name;
        final boolean replaced;
        boolean hasChild;

        CurrentElement(String string, boolean bl) {
            this.name = string;
            this.replaced = bl;
            this.hasChild = false;
        }
    }
}

