/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.UnknownCharacterException;

public class ByteToCharUTF7
extends ByteToCharConverter {
    private boolean b64Context = false;
    private int currentB64Off = 0;
    private char currentChar = '\u0000';

    public String getCharacterEncoding() {
        return "UTF7";
    }

    public int flush(char[] cArray, int n, int n2) {
        this.byteOff = 0;
        this.charOff = 0;
        this.b64Context = false;
        this.currentB64Off = 0;
        this.currentChar = '\u0000';
        return 0;
    }

    public void reset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.b64Context = false;
        this.currentB64Off = 0;
        this.currentChar = '\u0000';
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws ConversionBufferFullException, UnknownCharacterException {
        this.charOff = n3;
        this.byteOff = n;
        while (this.byteOff < n2) {
            if (this.charOff >= n4) {
                throw new ConversionBufferFullException();
            }
            if (this.b64Context) {
                if (byArray[this.byteOff] == 45) {
                    if (this.currentB64Off != 0 && this.currentChar > '\u0000') {
                        cArray[this.charOff] = this.currentChar;
                        ++this.charOff;
                    }
                    this.b64Context = false;
                } else {
                    int n5 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(byArray[this.byteOff]);
                    if (n5 == -1) {
                        throw new UnknownCharacterException("Invalid UTF-7 code: " + (char)byArray[this.byteOff]);
                    }
                    switch (this.currentB64Off) {
                        case 0: {
                            this.currentChar = (char)(n5 << 10);
                            break;
                        }
                        case 1: {
                            this.currentChar = (char)(this.currentChar | (char)(n5 << 4));
                            break;
                        }
                        case 2: {
                            cArray[this.charOff] = this.currentChar = (char)(this.currentChar | (char)(n5 >> 2));
                            ++this.charOff;
                            this.currentChar = (char)((n5 & 3) << 14);
                            break;
                        }
                        case 3: {
                            this.currentChar = (char)(this.currentChar | (char)(n5 << 8));
                            break;
                        }
                        case 4: {
                            this.currentChar = (char)(this.currentChar | (char)(n5 << 2));
                            break;
                        }
                        case 5: {
                            cArray[this.charOff] = this.currentChar = (char)(this.currentChar | (char)(n5 >> 4));
                            ++this.charOff;
                            this.currentChar = (char)((n5 & 0xF) << 12);
                            break;
                        }
                        case 6: {
                            this.currentChar = (char)(this.currentChar | (char)(n5 << 6));
                            break;
                        }
                        case 7: {
                            cArray[this.charOff] = this.currentChar = (char)(this.currentChar | (char)n5);
                            ++this.charOff;
                        }
                    }
                    this.currentB64Off = (this.currentB64Off + 1) % 8;
                }
            } else if (byArray[this.byteOff] == 43) {
                this.b64Context = true;
                this.currentB64Off = 0;
            } else {
                cArray[this.charOff] = (char)byArray[this.byteOff];
                ++this.charOff;
            }
            ++this.byteOff;
        }
        return this.charOff - n3;
    }
}

