/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import com.sk_jp.io.UnicodeCorrector;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class CorrectOutputStreamWriter
extends OutputStreamWriter {
    private UnicodeCorrector corrector;

    public CorrectOutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.corrector = UnicodeCorrector.getInstance(this.getEncoding());
    }

    public CorrectOutputStreamWriter(OutputStream outputStream) {
        super(outputStream);
        try {
            this.corrector = UnicodeCorrector.getInstance(this.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        char[] cArray2 = this.corrector.correct(cArray, n, n2);
        super.write(cArray2, 0, cArray2.length);
    }
}

