/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.lang;

public abstract class AsyncMethod
implements Runnable {
    private final Receiver receiver;

    public AsyncMethod(Receiver receiver) {
        this.receiver = receiver;
    }

    public Thread invoke() {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }

    protected abstract Object process() throws Exception;

    public final void run() {
        try {
            Object object = this.process();
            if (this.receiver != null) {
                this.receiver.completed(object);
            }
        }
        catch (Throwable throwable) {
            if (this.receiver != null) {
                this.receiver.exceptionOccured(throwable);
            }
            throwable.printStackTrace();
        }
    }

    protected final void progress(Object object) {
        if (this.receiver != null) {
            this.receiver.progress(object);
        }
    }

    public static interface Receiver {
        public void progress(Object var1);

        public void completed(Object var1);

        public void exceptionOccured(Throwable var1);
    }
}

