/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class CSVTokenizer {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private boolean isNextLine = false;
    private BufferedReader reader;
    private String next = null;
    private String line = null;
    private int currentIndex = 0;
    private int columnNumber = -2;
    private int lineNumber = 0;

    public static String[] split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            CSVTokenizer cSVTokenizer = new CSVTokenizer(new BufferedReader(new StringReader(string)));
            while (cSVTokenizer.hasNext()) {
                arrayList.add(cSVTokenizer.next());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    public CSVTokenizer(BufferedReader bufferedReader) throws IOException {
        this.reader = bufferedReader;
        this.line = this.readLine();
        this.readNextToken();
    }

    public final boolean hasNext() {
        return this.next != null;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final String next() throws IOException {
        String string = this.next;
        this.readNextToken();
        return string;
    }

    public final boolean isNextLine() {
        return this.isNextLine;
    }

    private void readNextToken() throws IOException {
        this.next = this.nextToken();
        ++this.columnNumber;
        if (this.next == null) {
            this.line = this.readLine();
            this.currentIndex = 0;
            this.isNextLine = true;
            this.next = this.nextToken();
        } else if (this.isNextLine) {
            this.isNextLine = false;
            ++this.lineNumber;
            this.columnNumber = 0;
        }
    }

    protected String nextToken() {
        if (this.line == null || this.currentIndex > this.line.length()) {
            return null;
        }
        int n = this.nextSeparatorIndex();
        StringBuffer stringBuffer = new StringBuffer(n - this.currentIndex);
        for (int i = this.currentIndex; i < n; ++i) {
            char c = this.line.charAt(i);
            if (c == '\"') {
                if (i == this.currentIndex || this.line.charAt(i - 1) != '\"') continue;
                stringBuffer.append('\"');
                continue;
            }
            stringBuffer.append(c);
        }
        this.currentIndex = n + 1;
        return new String(stringBuffer);
    }

    private int nextSeparatorIndex() {
        boolean bl = false;
        for (int i = this.currentIndex; i < this.line.length(); ++i) {
            char c = this.line.charAt(i);
            if (!bl && c == ',') {
                return i;
            }
            if (c != '\"') continue;
            bl = !bl;
        }
        return this.line.length();
    }

    private String readLine() throws IOException {
        String string;
        String string2 = this.reader.readLine();
        if (string2 == null) {
            return null;
        }
        int n = CSVTokenizer.countQuotationMarks(string2);
        if ((n & 1) == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() * 3);
        stringBuffer.append(string2);
        while ((n & 1) != 0 && (string = this.reader.readLine()) != null) {
            n += CSVTokenizer.countQuotationMarks(string);
            stringBuffer.append("\\n").append(string);
        }
        return new String(stringBuffer);
    }

    private static int countQuotationMarks(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        CSVTokenizer cSVTokenizer = new CSVTokenizer(new BufferedReader(new StringReader("a,b,c,d\n0,\"12\ns3\",4,5\n\"1,2,3\ns,4\",,a,\n\"ab\"\"c\",,,")));
        while (cSVTokenizer.hasNext()) {
            String string = cSVTokenizer.next();
            System.out.println(cSVTokenizer.lineNumber() + ":" + cSVTokenizer.columnNumber() + "  value = " + string + "\t\t  nextLine = " + cSVTokenizer.isNextLine());
        }
    }
}

