/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.text;

import com.sk_jp.text.Translator;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class EntityRefEncoder
implements Translator {
    public static final EntityRefEncoder CANONICAL_INSTANCE = new EntityRefEncoder(true);
    public static final EntityRefEncoder INSTANCE = new EntityRefEncoder(false);
    private boolean canonicalStatus;

    public EntityRefEncoder() {
        this(false);
    }

    public EntityRefEncoder(boolean bl) {
        this.setCanonical(bl);
    }

    private void setCanonical(boolean bl) {
        this.canonicalStatus = bl;
    }

    public void translate(Reader reader, Writer writer) throws IOException {
        int n;
        while ((n = reader.read()) != -1) {
            EntityRefEncoder.translate((char)n, writer, this.canonicalStatus);
        }
        writer.flush();
    }

    public String translate(String string) {
        return EntityRefEncoder.encode(string);
    }

    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 128);
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return new String(stringBuffer);
    }

    public static void translate(char c, Writer writer, boolean bl) throws IOException {
        switch (c) {
            case '<': {
                writer.write("&lt;");
                break;
            }
            case '>': {
                writer.write("&gt;");
                break;
            }
            case '&': {
                writer.write("&amp;");
                break;
            }
            case '\"': {
                writer.write("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (bl) {
                    writer.write("&#");
                    writer.write(Integer.toString(c));
                    writer.write(59);
                    break;
                }
                writer.write(c);
                break;
            }
            default: {
                writer.write(c);
            }
        }
    }

    public static String decode(String string) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '&' || i > n - 4) {
                stringBuffer.append(c);
                continue;
            }
            if ((string.charAt(i + 2) == 't' || string.charAt(i + 2) == 'T') && string.charAt(i + 3) == ';') {
                switch (string.charAt(i + 1)) {
                    case 'L': 
                    case 'l': {
                        stringBuffer.append('<');
                        i += 3;
                        continue block4;
                    }
                    case 'G': 
                    case 'g': {
                        stringBuffer.append('>');
                        i += 3;
                        continue block4;
                    }
                }
            } else {
                if (!(i >= n - 4 || string.charAt(i + 1) != 'a' && string.charAt(i + 1) != 'A' || string.charAt(i + 2) != 'm' && string.charAt(i + 2) != 'M' || string.charAt(i + 3) != 'p' && string.charAt(i + 3) != 'P' || string.charAt(i + 4) != ';')) {
                    stringBuffer.append('&');
                    i += 4;
                    continue;
                }
                if (!(i >= n - 5 || string.charAt(i + 1) != 'q' && string.charAt(i + 1) != 'Q' || string.charAt(i + 2) != 'u' && string.charAt(i + 2) != 'U' || string.charAt(i + 3) != 'o' && string.charAt(i + 3) != 'O' || string.charAt(i + 4) != 't' && string.charAt(i + 4) != 'T' || string.charAt(i + 5) != ';')) {
                    stringBuffer.append('\"');
                    i += 5;
                    continue;
                }
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }
}

