/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml.extractor;

import com.sk_jp.xml.extractor.DescendantNodeIterator;
import com.sk_jp.xml.extractor.Extractor;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChildNodeExtractor
implements Extractor {
    private String elementName_;
    private ArrayList extractors_;

    public ChildNodeExtractor() {
        this(null);
    }

    public ChildNodeExtractor(String string) {
        this.elementName_ = string;
    }

    public ChildNodeExtractor addExtractor(Extractor extractor) {
        if (this.extractors_ == null) {
            this.extractors_ = new ArrayList();
        }
        this.extractors_.add(extractor);
        return this;
    }

    public boolean canExtract(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        if (this.elementName_ != null) {
            NodeList nodeList = ((Element)node).getElementsByTagName(this.elementName_);
            if (this.extractors_ == null && nodeList.getLength() > 0) {
                return true;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1 || !this.canExtractChild((Element)nodeList.item(i))) continue;
                return true;
            }
            return false;
        }
        if (this.extractors_ == null) {
            return true;
        }
        DescendantNodeIterator descendantNodeIterator = new DescendantNodeIterator(node);
        while (descendantNodeIterator.hasNext()) {
            node = (Node)descendantNodeIterator.next();
            if (node.getNodeType() != 1 || !this.canExtractChild((Element)node)) continue;
            return true;
        }
        return false;
    }

    private boolean canExtractChild(Element element) {
        if (this.extractors_ == null) {
            return true;
        }
        Iterator iterator = this.extractors_.iterator();
        while (iterator.hasNext()) {
            if (((Extractor)iterator.next()).canExtract(element)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Child:");
        stringBuffer.append(this.elementName_);
        stringBuffer.append("=(");
        if (this.extractors_ != null) {
            stringBuffer.append('\n');
            Iterator iterator = this.extractors_.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    ");
                stringBuffer.append(iterator.next().toString());
                stringBuffer.append('\n');
            }
        }
        stringBuffer.append(")]\n");
        return stringBuffer.toString();
    }
}

