/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;

public class SampleConsumer {
    public ConsumerManager manager = new ConsumerManager();

    public String authRequest(String userSuppliedString, HttpServletRequest httpReq, HttpServletResponse httpResp) throws IOException {
        try {
            String returnToUrl = "http://example.com/openid";
            List discoveries = this.manager.discover(userSuppliedString);
            DiscoveryInformation discovered = this.manager.associate(discoveries);
            httpReq.getSession().setAttribute("openid-disc", (Object)discovered);
            AuthRequest authReq = this.manager.authenticate(discovered, returnToUrl);
            FetchRequest fetch = FetchRequest.createFetchRequest();
            fetch.addAttribute("email", "http://schema.openid.net/contact/email", true);
            authReq.addExtension(fetch);
            if (!discovered.isVersion2()) {
                httpResp.sendRedirect(authReq.getDestinationUrl(true));
                return null;
            }
        }
        catch (OpenIDException e) {
            // empty catch block
        }
        return null;
    }

    public Identifier verifyResponse(HttpServletRequest httpReq) {
        try {
            VerificationResult verification;
            Identifier verified;
            ParameterList response = new ParameterList(httpReq.getParameterMap());
            DiscoveryInformation discovered = (DiscoveryInformation)httpReq.getSession().getAttribute("openid-disc");
            StringBuffer receivingURL = httpReq.getRequestURL();
            String queryString = httpReq.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(httpReq.getQueryString());
            }
            if ((verified = (verification = this.manager.verify(receivingURL.toString(), response, discovered)).getVerifiedId()) != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0-draft4")) {
                    FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0-draft4");
                    List emails = fetchResp.getAttributeValues("email");
                    String email = (String)emails.get(0);
                }
                return verified;
            }
        }
        catch (OpenIDException openIDException) {
            // empty catch block
        }
        return null;
    }
}

