/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.update;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import jp.nyx.SecureSwitchUtility;
import jp.nyx.loader.NyxBootLoader;
import jp.nyx.update.NyxDownloadBean;
import jp.nyx.update.NyxDownloadItem;
import jp.nyx.update.NyxDownloadObsever;

public class NyxDownload {
    private String proxyHost = null;
    private int proxyPort = 8080;
    private File nyxHome;
    private File updateDir;
    private String[] startUrls;
    private NyxDownloadObsever obsever;

    public NyxDownload(File nyxHome, String[] startUrls, File updateDir, NyxDownloadObsever observer) throws IOException {
        this.nyxHome = nyxHome;
        this.obsever = observer;
        this.startUrls = startUrls;
        this.updateDir = updateDir;
        if (!this.updateDir.canRead() || !this.updateDir.canWrite()) {
            throw new IOException("Don't read or write directory. " + this.updateDir);
        }
        if (!this.updateDir.isDirectory()) {
            throw new FileNotFoundException("Not directory. " + this.updateDir);
        }
    }

    public void download(NyxBootLoader loader) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        double crtVer = SecureSwitchUtility.loadCrtKernelVersion(loader);
        SecureSwitchUtility.setUseAll(false);
        this.downloadMain(this.startUrls, crtVer);
    }

    private void downloadMain(String[] nexts, double crtVer) throws IOException {
        for (int i = 0; i < nexts.length; ++i) {
            NyxDownloadBean bean = this.downloadBean(new URL(nexts[i]));
            File downDir = new File(this.updateDir, String.valueOf(bean.getCrtVar()));
            downDir.mkdirs();
            this.writeBean(bean, downDir);
            if (crtVer <= bean.getStartVar() || bean.getEndVar() < crtVer) {
                this.downloadMain(bean.getNexts(), crtVer);
                continue;
            }
            NyxDownloadItem[] item = bean.getItems();
            SecureSwitchUtility.setUseAll(false);
            for (int j = 0; j < item.length; ++j) {
                this.obsever.startDownload(j + 1, item.length);
                String writeFile = item[j].getTo().replace("${nyx.home}", this.nyxHome.getAbsolutePath());
                writeFile = writeFile.trim().replace(this.nyxHome.getAbsolutePath(), "");
                URL url = new URL(item[j].getFrom());
                this.downloadFile(url, new File(new File(this.updateDir, String.valueOf(bean.getCrtVar())), writeFile));
            }
        }
    }

    private void writeBean(NyxDownloadBean bean, File downDir) throws IOException {
        File beanFile = new File(downDir, "update.list.xml");
        String confirm = " File found. " + beanFile.getAbsolutePath() + "\n Orver write?";
        if (beanFile.exists() && !SecureSwitchUtility.getYesNo(confirm, true)) {
            this.obsever.endDownloadBean(" Download Skip.");
            return;
        }
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(beanFile));
        XMLEncoder encoder = new XMLEncoder(bout);
        encoder.writeObject(bean);
        encoder.close();
        bout.close();
        this.obsever.endDownloadBean(" Donload Complete.");
    }

    private URLConnection getConnection(URL url) throws IOException {
        if (this.proxyHost != null && this.proxyPort > 0) {
            InetSocketAddress proxyAddr = new InetSocketAddress(this.proxyHost, this.proxyPort);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
            return url.openConnection(proxy);
        }
        return url.openConnection();
    }

    private NyxDownloadBean downloadBean(URL url) throws IOException {
        URLConnection con = this.getConnection(url);
        this.obsever.startDownloadBean(url);
        XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(con.getInputStream()));
        NyxDownloadBean bean = (NyxDownloadBean)decoder.readObject();
        decoder.close();
        return bean;
    }

    private void downloadFile(URL url, File writeFile) throws IOException {
        writeFile.getParentFile().mkdirs();
        URLConnection con = this.getConnection(url);
        this.obsever.startFile(url, writeFile, con.getContentLength());
        String confirm = " File found. Orver write?";
        if (writeFile.exists() && !SecureSwitchUtility.getYesNo(confirm, true)) {
            this.obsever.endFile("Download Skip.");
            return;
        }
        FileOutputStream out = new FileOutputStream(writeFile);
        InputStream in = con.getInputStream();
        this.pipe(in, out);
        out.close();
        in.close();
        this.obsever.endFile("Download Complete.");
    }

    private void pipe(InputStream in, OutputStream out) throws IOException {
        int bufsize = 65536;
        BufferedInputStream bin = new BufferedInputStream(in, bufsize);
        BufferedOutputStream bout = new BufferedOutputStream(out, bufsize);
        long crtLength = 0L;
        byte[] b = new byte[bufsize];
        int n = -1;
        while ((n = bin.read(b, 0, bufsize)) > 0) {
            bout.write(b, 0, n);
            this.obsever.downloading(crtLength += (long)n);
        }
        bout.flush();
    }

    public void outputSampleXML(OutputStream out) {
        NyxDownloadBean bean = new NyxDownloadBean();
        bean.setStartVar(0.6);
        bean.setCrtVar(0.61);
        bean.setEndVar(0.6);
        bean.setTitle("SecureSwitch v0.6.0 -> v0.6.1");
        bean.setMemo("This sample update file.");
        bean.setNexts(new String[]{"http://nyx.sourceforge.jp/update/v0.6.0/update.list.xml"});
        NyxDownloadItem portal = new NyxDownloadItem();
        portal.setFrom("http://nyx.sourceforge.jp/update/portal.war");
        portal.setTo("${nyx.home}/servlet/webapps/portal.war");
        portal.setDeply("confirm");
        portal.setMemo("Portal war file.");
        NyxDownloadItem ROOT = new NyxDownloadItem();
        ROOT.setFrom("http://nyx.sourceforge.jp/update/ROOT.war");
        ROOT.setTo("${nyx.home}/servlet/webapps/ROOT.war");
        ROOT.setDeply("confirm");
        ROOT.setMemo("ROOT war file.");
        bean.setItems(new NyxDownloadItem[]{portal, ROOT});
        XMLEncoder encoder = new XMLEncoder(out);
        encoder.writeObject(bean);
        encoder.flush();
    }

    public String[] getStartUrls() {
        return this.startUrls;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }
}

