/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Map;
import javax.xml.crypto.NoSuchMechanismException;

final class XMLDSigSecurity {
    static /* synthetic */ Class class$javax$xml$crypto$dsig$XMLSignatureFactory;
    static /* synthetic */ Class class$javax$xml$crypto$dsig$keyinfo$KeyInfoFactory;
    static /* synthetic */ Class class$javax$xml$crypto$dsig$TransformService;

    private XMLDSigSecurity() {
    }

    private static ProviderProperty getEngineClassName(String alg, Map.Entry attr, String engineType, String key, boolean mech) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        boolean found = false;
        ProviderProperty entry = null;
        for (int i = 0; i < provs.length && !found; ++i) {
            try {
                entry = XMLDSigSecurity.getEngineClassName(alg, attr, engineType, key, provs[i], mech);
                found = true;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!found) {
            if (mech) {
                throw new NoSuchMechanismException("Mechanism type " + alg + " not available");
            }
            throw new NoSuchAlgorithmException("Algorithm type " + alg + " not available");
        }
        return entry;
    }

    private static ProviderProperty getEngineClassName(String alg, Map.Entry attr, String engineType, String key, Provider provider, boolean mech) throws NoSuchAlgorithmException {
        String className = XMLDSigSecurity.getProviderProperty(key, attr, provider);
        if (className == null) {
            String stdName = XMLDSigSecurity.getStandardName(alg, engineType, provider);
            if (stdName != null) {
                key = engineType + "." + stdName;
            }
            if (stdName == null || (className = XMLDSigSecurity.getProviderProperty(key, attr, provider)) == null) {
                if (mech) {
                    throw new NoSuchMechanismException("no such mechanism type: " + alg + " for provider " + provider.getName());
                }
                throw new NoSuchAlgorithmException("no such algorithm: " + alg + " for provider " + provider.getName());
            }
        }
        ProviderProperty entry = new ProviderProperty();
        entry.className = className;
        entry.provider = provider;
        return entry;
    }

    private static boolean checkSuperclass(Class subclass, Class superclass) {
        return superclass.isAssignableFrom(subclass);
    }

    static Object[] getImpl(String mechType, String type, Provider provider) throws NoSuchAlgorithmException {
        return XMLDSigSecurity.getImpl(mechType, null, type, provider);
    }

    static Object[] getImpl(String alg, Map.Entry attr, String type, Provider provider) throws NoSuchAlgorithmException {
        Class typeClass = null;
        boolean m = true;
        if (type.equals("XMLSignatureFactory")) {
            typeClass = class$javax$xml$crypto$dsig$XMLSignatureFactory == null ? (class$javax$xml$crypto$dsig$XMLSignatureFactory = XMLDSigSecurity.class$("javax.xml.crypto.dsig.XMLSignatureFactory")) : class$javax$xml$crypto$dsig$XMLSignatureFactory;
        } else if (type.equals("KeyInfoFactory")) {
            typeClass = class$javax$xml$crypto$dsig$keyinfo$KeyInfoFactory == null ? (class$javax$xml$crypto$dsig$keyinfo$KeyInfoFactory = XMLDSigSecurity.class$("javax.xml.crypto.dsig.keyinfo.KeyInfoFactory")) : class$javax$xml$crypto$dsig$keyinfo$KeyInfoFactory;
        } else if (type.equals("TransformService")) {
            typeClass = class$javax$xml$crypto$dsig$TransformService == null ? (class$javax$xml$crypto$dsig$TransformService = XMLDSigSecurity.class$("javax.xml.crypto.dsig.TransformService")) : class$javax$xml$crypto$dsig$TransformService;
            m = false;
        }
        String key = type + "." + alg;
        if (provider == null) {
            return XMLDSigSecurity.doGetImpl(type, typeClass, XMLDSigSecurity.getEngineClassName(alg, attr, type, key, m), m);
        }
        return XMLDSigSecurity.doGetImpl(type, typeClass, XMLDSigSecurity.getEngineClassName(alg, attr, type, key, provider, m), m);
    }

    private static Object[] doGetImpl(String type, Class typeClass, ProviderProperty pp, boolean mech) throws NoSuchAlgorithmException {
        String className = pp.className;
        String providerName = pp.provider.getName();
        try {
            ClassLoader cl = pp.provider.getClass().getClassLoader();
            Class<?> implClass = cl != null ? cl.loadClass(className) : Class.forName(className);
            if (XMLDSigSecurity.checkSuperclass(implClass, typeClass)) {
                return new Object[]{implClass.newInstance(), pp.provider};
            }
            if (mech) {
                throw new NoSuchMechanismException("class configured for " + type + ": " + className + " not a " + type);
            }
            throw new NoSuchAlgorithmException("class configured for " + type + ": " + className + " not a " + type);
        }
        catch (ClassNotFoundException e) {
            if (mech) {
                throw new NoSuchMechanismException("class configured for " + type + "(provider: " + providerName + ")" + "cannot be found.\n", e);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class configured for " + type + "(provider: " + providerName + ")" + "cannot be found.\n").initCause(e);
        }
        catch (InstantiationException e) {
            if (mech) {
                throw new NoSuchMechanismException("class " + className + " configured for " + type + "(provider: " + providerName + ") cannot be " + "instantiated. ", e);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + className + " configured for " + type + "(provider: " + providerName + ") cannot be " + "instantiated. ").initCause(e);
        }
        catch (IllegalAccessException e) {
            if (mech) {
                throw new NoSuchMechanismException("class " + className + " configured for " + type + "(provider: " + providerName + ") cannot be accessed.\n", e);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + className + " configured for " + type + "(provider: " + providerName + ") cannot be accessed.\n").initCause(e);
        }
    }

    private static String getProviderProperty(String key, Map.Entry attr, Provider prov) {
        String prop = prov.getProperty(key);
        if (prop == null) {
            Enumeration<Object> e = prov.keys();
            while (e.hasMoreElements()) {
                String matchKey = (String)e.nextElement();
                if (!key.equalsIgnoreCase(matchKey)) continue;
                prop = prov.getProperty(matchKey);
                break;
            }
        }
        if (!(prop == null || attr == null || prov.entrySet().contains(attr) || attr.getValue().equals("DOM") && prov.get(attr.getKey()) == null)) {
            prop = null;
        }
        return prop;
    }

    private static String getStandardName(String alias, String engineType, Provider prov) {
        return XMLDSigSecurity.getProviderProperty("Alg.Alias." + engineType + "." + alias, null, prov);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

