/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public abstract class ReloadableResource {
    private final URL url_;
    private final File file_;
    private long lastModified_ = -1L;
    private Object target_;
    private boolean reloadable_ = true;

    public ReloadableResource(File file) {
        this(file, 0L);
    }

    public ReloadableResource(File file, long l) {
        this.file_ = file;
        this.url_ = null;
    }

    public ReloadableResource(URL uRL) {
        this(uRL, 0L);
    }

    public ReloadableResource(URL uRL, long l) {
        this.file_ = null;
        this.url_ = uRL;
    }

    public final Object get() throws IOException {
        if (!this.reloadable_ && this.target_ != null) {
            return this.target_;
        }
        return this.reload();
    }

    public synchronized boolean isUpdated() throws IOException {
        URLConnection uRLConnection;
        long l;
        long l2;
        return this.file_ != null ? (l2 = this.file_.lastModified()) > this.lastModified_ : (l = (uRLConnection = this.url_.openConnection()).getLastModified()) > this.lastModified_;
    }

    protected synchronized void writed() throws IOException {
        if (this.file_ != null) {
            this.lastModified_ = this.file_.lastModified();
        } else {
            URLConnection uRLConnection = this.url_.openConnection();
            this.lastModified_ = uRLConnection.getLastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object reload() throws IOException {
        if (this.file_ != null) {
            long l = this.file_.lastModified();
            if (l > this.lastModified_) {
                this.lastModified_ = l;
                InputStream inputStream = this.getInputStream();
                try {
                    this.target_ = this.update(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
        } else {
            URLConnection uRLConnection = this.url_.openConnection();
            long l = uRLConnection.getLastModified();
            if (l > this.lastModified_) {
                this.lastModified_ = l;
                InputStream inputStream = uRLConnection.getInputStream();
                try {
                    this.target_ = this.update(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
        }
        return this.target_;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file_ != null) {
            return new BufferedInputStream(new FileInputStream(this.file_));
        }
        return this.url_.openConnection().getInputStream();
    }

    public void setAutoReloadable(boolean bl) {
        this.reloadable_ = bl;
    }

    protected abstract Object update(InputStream var1) throws IOException;

    public File getOriginalFile() {
        return this.file_;
    }

    public URL getOriginalURL() {
        return this.url_;
    }

    public String toString() {
        return "FILE=" + this.file_ + " URL=" + this.url_;
    }
}

