/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private String id;
    private int encAlgorithm;
    private int certificationLevel;
    private char[] passPhrase;
    private boolean useSHA1;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private SecureRandom rand;
    private String provider;

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, int n2, char[] cArray, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this(n, pGPKeyPair, string, n2, cArray, false, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, secureRandom, string2);
    }

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, int n2, char[] cArray, boolean bl, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this.certificationLevel = n;
        this.masterKey = pGPKeyPair;
        this.id = string;
        this.encAlgorithm = n2;
        this.passPhrase = cArray;
        this.useSHA1 = bl;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        this.rand = secureRandom;
        this.provider = string2;
        this.keys.add(new PGPSecretKey(n, pGPKeyPair, string, n2, cArray, bl, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, secureRandom, string2));
    }

    public void addSubKey(PGPKeyPair pGPKeyPair) throws PGPException {
        this.addSubKey(pGPKeyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2) throws PGPException {
        try {
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.masterKey.getPublicKey().getAlgorithm(), 2, this.provider);
            pGPSignatureGenerator.initSign(24, this.masterKey.getPrivateKey());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            arrayList.add(pGPSignatureGenerator.generateCertification(this.masterKey.getPublicKey(), pGPKeyPair.getPublicKey()));
            this.keys.add(new PGPSecretKey(pGPKeyPair, null, arrayList, this.encAlgorithm, this.passPhrase, this.useSHA1, this.rand, this.provider));
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception adding subkey: ", exception);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator iterator = this.keys.iterator();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        arrayList.add(((PGPSecretKey)iterator.next()).getPublicKey());
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = new PGPPublicKey(((PGPSecretKey)iterator.next()).getPublicKey());
            pGPPublicKey.publicPk = new PublicSubkeyPacket(pGPPublicKey.getAlgorithm(), pGPPublicKey.getCreationTime(), pGPPublicKey.publicPk.getKey());
            arrayList.add(pGPPublicKey);
        }
        return new PGPPublicKeyRing(arrayList);
    }
}

