;;; 1998 Copyright OMURA Shinichi, all rights reserved
;;; test data for Object Classifier cyclic version

(if (not (string= (lisp-implementation-type) "Macintosh Common Lisp"))
  (require 'object-classifier (merge-pathnames "objclasr.lsp" (current-directory)))
)
;(in-package "ocp")

(format t
";;;;;;;;;;;;;;;;;;;; TEST1 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
")

;;; test data ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass document ()
  ((title    :initarg :title    :reader doc-title)
   (lang     :initarg :lang     :reader doc-lang)
   (author   :initarg :author   :reader doc-author)
   (category :initarg :category :reader doc-category)
   (keyword  :initarg :keyword  :reader doc-keyword :initform nil)
   (pub-year :initarg :pub-year :reader doc-pub-year :initform 1997)
   )
  )

(defmethod display ((doc document))
  (format t "{~A by ~A#~A#~A#~S# ~S# ~S}"
    (and (slot-boundp doc 'title) (doc-title doc))
    (and (slot-boundp doc 'author) (doc-author doc))
    (and (slot-boundp doc 'category) (doc-category doc))
    (and (slot-boundp doc 'lang) (doc-lang doc))
    (and (slot-boundp doc 'keyword) (doc-keyword doc))
    (and (slot-boundp doc 'pub-year) (doc-pub-year doc))
    doc
    )
  )


(defclass report (document)
    ((organization    :initarg :organization    :reader report-organization))
   )

(defclass annual (document)
    ((period :initarg :period   :reader annual-period))
   )

(defmethod display ((doc report))
   (let ()
      (call-next-method)
      (format t "+org = ~A" (report-organization doc))
      )
   )

(defmethod display ((doc annual))
   (let ()
      (call-next-method)
      (format t "+period = ~A" (annual-period doc))
      )
   )


#|
1 1category 1partition, 1object
2 1category 1partition, 3object
3 1category, 2 par*, 2obj/par correct par contains them
4 2category(2 root), 1par/cat, 1obj/par case two cat under t
5 2cat, 1par/cat, 1obj/*  correctly object is placed
6 3cat, 2par/cat, 1obj/node   every node has obj
7 3cat, 2par/cat, 2obj/node   correct node has 2 obj
8 union cat, 1par/cat, 1obj/join par  join par has correct obj
9 same 2 classifier don't interfere each others.
|#


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "~%;;; case 1 1category 1partition, 1object~%")

(format t "~%;;case 1 (1)  -- at leaf ~%~%")

(setf doc11 (list
             (make-instance 'document
               :title     "case 1 book"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )))

(defclassifier
  case11
  nil
  (Author ()
    (lambda (obj part) (doc-author obj) )
    (lambda (obj part) (slot-exists-boundp obj 'author)))
  )

(setf case11d (make-classifier 'case11))
(put-object* case11d doc11)
(show case11d 'display)
(format t "CHECK: /[T]/[OMURA]/{case 1 book#}~%")


(format t "~%case 1 (2) -- at root~%")

(setf doc12 (list
             (make-instance 'document
               :title     "case 1 book"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               )))

(defclassifier case12
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (and (slot-exists-p x 'author)
                     (slot-boundp x 'author))))
    )

(setf case12d (make-classifier 'case12))
(put-object* case12d doc12)
(show case12d 'display)

(format t "CHECK /[T]/{case 1 book#}~%")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "~%;;; case 2 1category 1partition, 3object~%")
(format t "~%;;; case 2 (1) -- leaf~%")

(setf doc21 (list
             (make-instance 'document
               :title     "case 2 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 2 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 2 book 3"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )
              ))

(defclassifier case21
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-boundp x 'author)))
  )


(setf case21d (make-classifier 'case21))
(put-object* case21d doc21)
(show case21d 'display t)

(format t "~%[T]/[OMURA]/{1,2,3}~%")

(format t "~%;;; case 2 (2) -- at root~%")
(setf doc22 (list
             (make-instance 'document
               :title     "case 2 book 1"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 2 book 2"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 2 book 3"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               )
              ))

(defclassifier case22
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-boundp x 'author)))
  )

(setf case22d (make-classifier 'case22))
(put-object* case22d doc22)
(show case22d 'display)

(format t "~%;; [T]/{1,2,3}~%")

;;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
(format t "~%~%;;; case 3 1category, 2 par*, 2obj/par correct par contains them~%")
(format t "~%;; caes 3 (1)~%")

(setf doc31 (list
             (make-instance 'document
               :title     "case 3 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 3 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 3 book 3"
               :lang      'Japanese
               :author    'shin
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 3 book 4"
               :lang      'Japanese
               :author    'shin
               :category  "test document"
               :keyword   '(otherwise)
               ))
      )

(defclassifier case31
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-boundp x 'author)))
  )

(setf case31d (make-classifier 'case31))
(put-object* case31d doc31)

(show-partition case31d)
(format t "
;; /[T]/[OMURA]
;; /[T]/[SHIN]
")

(show case31d 'display)
(format t "
;; /[T]/[OMURA]/{1,2}
;; /[T]/[SHIN]/{3,4}
")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "
;;; case 4 2category(2 root), 1par/cat, 1obj/par  two cat under t
")



(setf doc41 (list
             (make-instance 'report
               :title     "case 4 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
             (make-instance 'annual
               :title     "case 4 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
              )
      )

(defclassifier case41
  nil
  (period ()
    (lambda (x y) (annual-period x) )
    (lambda (x y) (slot-exists-boundp x 'period)))
  (organization ()
    (lambda (x y) (report-organization x) )
    (lambda (x y) (slot-exists-p x 'organization)))
  )


(setf case41d (make-classifier 'case41))
(put-object* case41d doc41)

(show-partition case41d)
(format t "
;; /[T]/[annual]
;; /[T]/[report]
")
(show case41d 'display)

(format t "
;; /[T]/[annual]/{1}
;; /[T]/[report]/{2}
")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "
;;; case 5 2cat, 1par/cat, 1obj/* correctly object is placed
")
(format t "
;; case 5 (1) -- leaf (lang)
")

(setf doc51 (list
             (make-instance 'document
               :title     "case 5 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )))

(defclassifier case51
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-boundp x 'author)))
  (Lang (Author)
    (lambda (x y) (doc-lang x) )
    (lambda (x y) (slot-exists-boundp x 'lang)))
  )


(setf case51d (make-classifier 'case51))
(put-object* case51d doc51)

(show-partition case51d)
(format t "
;; /[T]/[author]/[Lang]
")

(show case51d 'display)

(format t "


;; /[T]/[author]/[lang]/{1}
")

(format t "
;; case 5 (2) -- intermediate (author)
")

(setf doc52 (list
             (make-instance 'document
               :title     "case 5 book 1"
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )))

(defclassifier case52
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-boundp x 'author)))
  (Lang (Author)
    (lambda (x y) (doc-lang x) )
    (lambda (x y) (slot-exists-boundp x 'lang)))
  )


(setf case52d (make-classifier 'case52))
(put-object* case52d doc52)


(show-partition case52d)
(format t "
;; /[T]/[author]/
")

(show case52d 'display)
(format t "
;; /[T]/[author]/{1}
")

(format t "

;; case 5 (3)
")

(setf doc53 (list
             (make-instance 'document
               :title     "case 5 book 1"
               :category  "test document"
               :keyword   '(otherwise)
               )))

(defclassifier case53
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-boundp x 'author)))
  (Lang (Author)
    (lambda (x y) (doc-lang x) )
    (lambda (x y) (slot-exists-boundp x 'lang)))
  )


(setf case53d (make-classifier 'case53))
(put-object* case53d doc53)

(show-partition case53d)
(format t "
;; /[T]
")

(show case53d 'display)

(format t "
;; /[T]/{1}
")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "
;;; case 6 3cat, 2par/cat, 1obj/node  every node has obj
")

(format t "

;; case 6 (1)
")

(setf doc61 (list
             (make-instance 'document
               :title     "case 6 book 1"
               :category  "test document"
               :author    "OMURA"
               :lang      'japan
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 6 book 2"
               :author     "OMURA"
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 6 book 3"
               :author     "OMURA"
               :keyword   '(otherwise)
               )
              ))

(defclassifier case61
  nil
  (Author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-boundp x 'author)))
  (Category (Author)
    (lambda (x y) (doc-category x))
    (lambda (x y) (slot-exists-boundp x 'category)))
  (Lang (Category)
    (lambda (x y) (doc-lang x) )
    (lambda (x y) (slot-exists-boundp x 'lang)))
  )

(setf case61d (make-classifier 'case61))
(put-object* case61d doc61)

(show-partition case61d)
(format t "
;; /[T]/[author]/[Category]/[Lang]
")

(show case61d 'display)

(format t "
/[T]/
/[T]/[Author]/{3}
/[T]/[Author]/[Category]/{2}
/[T]/[Author]/[Category]/[Lang]/{1}
")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "
;;; case 7 3cat, 2par/cat, 2obj/node  correct node has 2 obj
")

(format t "

;; case 7 (1) disjunction
")

(setf doc71 (list
             (make-instance 'report
               :title     "case 7 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
              (make-instance 'report
               :title     "case 7 book 3"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 4"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
              (make-instance 'report
               :title     "case 7 book 5"
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 6"
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
             (make-instance 'annual
               :title     "case 4 book 7"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 8"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 9"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 10"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 11"
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 12"
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )

              )
      )

(defclassifier case71
  nil
  (period ()
    (lambda (x y) (annual-period x) )
    (lambda (x y) (slot-exists-boundp x 'period)))
  (ann-lang (period)
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  (ann-author (ann-lang)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (organization ()
    (lambda (x y) (report-organization x) )
    (lambda (x y) (slot-exists-p x 'organization)))
  (par-lang (organization)
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  (par-author (par-lang)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  )


(setf case71d (make-classifier 'case71))
(put-object* case71d doc71)

(show-partition case71d)
(format t "
/[T]/[annual]/[Lang]/[Author]
    /[report]/[Lang]/[Author]
")

(show case71d 'display)

(format t "
/[T]/
/[T]/[report]/{5,6}
/[T]/[report]/[Lang]/{3,4}
/[T]/[report]/[Lang]/[Author]/{1,2}
/[T]/[annual]/{11,12}
/[T]/[annual]/[Lang]/{9,10}
/[T]/[annual]/[Lang]/[Author]/{7,8}
")


(format t "

;; case 7 (2) conjunction
")

(setf doc72 (list
             (make-instance 'document
               :title     "case 7 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :pub-year 1998
               )
            (make-instance 'document
               :title     "case 7 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :pub-year 1997
               )
              (make-instance 'document
               :title     "case 7 book 3"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :pub-year 1996
               )
            (make-instance 'document
               :title     "case 7 book 4"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :pub-year 1995
               )
              (make-instance 'document
               :title     "case 7 book 5"
               :category  "test document"
               :keyword   '(otherwise)
               :pub-year 1994
               )
            (make-instance 'document
               :title     "case 7 book 6"
               :category  "test document"
               :keyword   '(otherwise)
               :pub-year 1993
               )
              )
      )

(defclassifier case72
  nil
  (category ()
    (lambda (x y) (doc-category x) )
    (lambda (x y) (slot-exists-boundp x 'category)))
  (cat-lang (category)
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  (cat-author (cat-lang)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (lang ()
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  (lang-author (lang)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (pub-year (lang-author)
    (lambda (x y) (doc-pub-year x) )
    (lambda (x y) (slot-exists-p x 'pub-year)))
  )


(setf case72d (make-classifier 'case72))
(put-object* case72d doc72)

(show-partition case72d)
(format t "
/[T]/[test document]/[omura]/1997
                            /1998
    /[japanese]/[omura]/1997
                       /1998
")

(show case72d 'display t)

(format t "
/[T]/
/[T]/[testdoc]/{5,6}
              /[japanese]/{3,4}
                         /[OMURA]/{1,2}
/[T]/[japanese]/{3,4}
               /[omura]/[1997]/{2}
                       /[1998]/{1}
")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(format t "
;;; case 8 (3) union 1 object in same partition -- simple
")

(setf doc83 (list
             (make-instance 'document
               :title     "case 7 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 4 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               )
              )
      )

(defclassifier case83
  nil
  (category ()
    (lambda (x y) (doc-category x) )
    (lambda (x y) (slot-exists-boundp x 'category)))
  (author ()
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  (lang (category author)
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  )


(setf case83d (make-classifier 'case83))
(put-object* case83d doc83)

(show-partition case83d)
(format t "
/[T]/[test document]/[japanese]
    /[omura]/[same japanese]
")

(show case83d 'display t 0)

(format t "
/[T]/
/[T]/[test document]/[japanese]/{1,2}
/[T]/[omura]/[same japanese]/{1,2}
")


;;; ----
(format t "
;;; case 8 union 2 object in same partition -- simple
")

(setf doc82 (list
             (make-instance 'document
               :title     "case 8 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "category A"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 8 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "category B"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 8 book 3"
               :lang      'Japanese
               :author    'shin
               :category  "category A"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 8 book 4"
               :lang      'Japanese
               :author    'shin
               :category  "category B"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 8 book 5"
               :lang      'Japanese
               :author    'omura
               :category  "category A"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 8 book 6"
               :lang      'Japanese
               :author    'omura
               :category  "category B"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 8 book 7"
               :lang      'Japanese
               :author    'shin
               :category  "category A"
               :keyword   '(otherwise)
               )
             (make-instance 'document
               :title     "case 8 book 8"
               :lang      'Japanese
               :author    'shin
               :category  "category B"
               :keyword   '(otherwise)
               )
              )
              )

(defclassifier case82
  nil
  (category ()
    (lambda (x y) (doc-category x) )
    (lambda (x y) (slot-exists-boundp x 'category)))
  (author ()
    (lambda (x y) (doc-author x) )
    (lambda (x y) (slot-exists-p x 'author)))
  (lang (category author)
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  )


(setf case82d (make-classifier 'case82))
(put-object* case82d doc82)

(show-partition case82d)
(format t "
/[T]/[category]/[japanese]
    /[author]/[as above]
")

(show case82d 'display t)

(format t "
/[T]/
/[T]/[category A]/[OMURA]/[Lang]/{1,5}
/[T]/[category B]/[OMURA]/[Lang]/{2,6}
/[T]/[category A]/[SHIN]/[Lang]/{3,7}
/[T]/[category B]/[SHIN]/[Lang]/{4,8}
")

;;;----
(format t "
;;; case 8 union cat, 1par/cat, 1obj/join par join par has correct obj
")

(setf doc81 (list
             (make-instance 'report
               :title     "case 7 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
              (make-instance 'report
               :title     "case 7 book 3"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 4"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
              (make-instance 'report
               :title     "case 7 book 5"
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 6"
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
             (make-instance 'annual
               :title     "case 4 book 7"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 8"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 9"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 10"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 11"
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 12"
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )

              )
      )

(defclassifier case81
  nil
  (period ()
    (lambda (x y) (annual-period x) )
    (lambda (x y) (slot-exists-boundp x 'period)))
  (organization ()
    (lambda (x y) (report-organization x) )
    (lambda (x y) (slot-exists-p x 'organization)))
  (lang (period organization)
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  (ann-author (lang)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  )


(setf case81d (make-classifier 'case81))
(put-object* case81d doc81)

(show-partition case81d)
(format t "
/[T]/[1998]/[japanese]/[omura]
    /[nasa]/[same japanese]/[same omura]
")

(show case81d 'display)

(format t "
/[T]/
/[T]/[report]/{5,6}
/[T]/[report]/[Lang]/{3,4}
/[T]/[report]/[Lang]/[Author]/{1,2}
/[T]/[annual]/{11,12}
/[T]/[annual]/[Lang]/{9,10}
/[T]/[annual]/[Lang]/[Author]/{7,8}
")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(format t "
;;;  case 9 same 2 classifier don't interfere each others.
")
(setf doc911 (list
             (make-instance 'report
               :title     "case 7 book 1"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 2"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
              (make-instance 'report
               :title     "case 7 book 3"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 4"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
              (make-instance 'report
               :title     "case 7 book 5"
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            (make-instance 'report
               :title     "case 7 book 6"
               :category  "test document"
               :keyword   '(otherwise)
               :organization 'nasa
               )
            ))
(setf doc912 (list
             (make-instance 'annual
               :title     "case 4 book 7"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 8"
               :lang      'Japanese
               :author    'omura
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 9"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 10"
               :lang      'Japanese
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 11"
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )
             (make-instance 'annual
               :title     "case 4 book 12"
               :category  "test document"
               :keyword   '(otherwise)
               :period    1998
               )

              )
      )

(defclassifier case91
  nil
  (lang ()
    (lambda (x y) (doc-lang x))
    (lambda (x y) (slot-exists-boundp x 'lang)))
  (ann-author (lang)
    (lambda (x y) (doc-author x))
    (lambda (x y) (slot-exists-boundp x 'author)))
  )


(setf case911d (make-classifier 'case91))
(setf case912d (make-classifier 'case91))

(put-object* case911d doc911)
(put-object* case912d doc912)

(show-partition case911d)
(show-partition case912d)
(format t "
/[T]/[japanese]/[omura]
")

(format t "~%911d ....~%")
(show case911d 'display)
(format t "~%912d ....~%")
(show case912d 'display)
