;;; 1998 Copyright OMURA Shinichi, all rights reserved
;;(require 'object-classifier "lispwork\\objclass\\objclass.lsp")
;;(in-package 'classifier)

(defclass document ()
  ((title    :initarg :title    :reader doc-title)
   (lang     :initarg :lang     :reader doc-lang)
   (author   :initarg :author   :reader doc-author)
   (thema :initarg :thema :reader doc-thema)
   (keyword  :initarg :keyword  :reader doc-keyword :initform nil)
   (pub-year :initarg :pub-year :reader doc-pub-year :initform 1997)
   )
  )

(defmethod display ((doc document))
  (format t "{~A by ~A#~A#~A#~S}"
    (and (slot-boundp doc 'title) (doc-title doc))
    (and (slot-boundp doc 'author) (doc-author doc))
    (and (slot-boundp doc 'thema) (doc-thema doc))
    (and (slot-boundp doc 'lang) (doc-lang doc))
    (and (slot-boundp doc 'keyword) (doc-keyword doc))
    (and (slot-boundp doc 'pub-year) (doc-pub-year doc))
    )
  )

(defclassifier
    simple-classifier1
    nil
   (thema (t)
         (lambda (obj part) (doc-thema obj))
         (lambda (obj part) (slot-exists-boundp obj 'thema)))
   (author (thema)
         (lambda (obj part) (slot-value obj 'author))
         (lambda (obj part) (slot-exists-boundp obj 'author) ))
   (lang (author)
         (lambda (obj part) (doc-lang obj) )
         (lambda (obj part) (slot-exists-boundp obj 'lang)))
   )

(setf doc (list
            (make-instance 'document
                           :title "reference manual"
                           :lang  'japan
                           :author "omura"
                           :thema "Computer Science"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "user's manual"
                           :lang  'japan
                           :author "omura"
                           :thema "mathematics"
                           :keyword '("Object Oriented" "Lisp")
                           )
            (make-instance 'document
                           :title "Quick Start"
                           :lang  'japan
                           :author "tanaka"
                           :thema "Novel"
                           :keyword '("Object Oriented" "Lisp")
                           )))

(setf bug1 (make-classifier 'simple-classifier1))

(put-object* bug1 doc)

(show bug1 'display)

(objectbrowser 'simple-classifier1 doc)