;;; 1998 Copyright OMURA Shinichi, all rights reserved
;; Object Browser


(provide 'object-browser)

(if (not (string= (lisp-implementation-type) "Macintosh Common Lisp"))
  (require 'my-debug (merge-pathnames "mydebug.lsp" (current-directory)))
  (require 'my-debug  "mydebug.lsp" )
)

(if (not (string= (lisp-implementation-type) "Macintosh Common Lisp"))
  (require 'object-classifier (merge-pathnames "objclasr.lsp" (current-directory)))
)

#|

(if (not (string= (lisp-implementation-type) "Macintosh Common Lisp"))
  (require 'object-classifier-extension (merge-pathnames "objexten.lsp" (current-directory)))
)
|#

#|
;(in-package 'obp)
|#
#|
;;; history
1998.0418 Should I grouping the same representations to one? try it.
--

1. I dont know how to communicate another widgets...
2. I will must be catch the key event for eval-field... ?
3. what is set-region-fn?

bugs
1998.04.15 when i change the browser's frame size, the partition-tree pane is
           not changed.

works
1998.04.21 add :test #'equeal for hash-table in grouping. -- for doubled same name partition
1998.04.21 *pure-theorist* loss the object* in t. so, i default to t.
1998.04.18 i make a item for The same representation. this neglectify the join effect.
1998.04.15 add display-method to browser's arg. it change the appearance of object in it.
1998.04.15 t representation is show or not is parameterized. *pure-theorist*
1998.04.15 *debug-mode* affects the debug trace macro

|#
;;;


;;; Browser mode
;;;
;;; *pure-theorist* = t   ==> t partition is presented
;;; *pure-theorist* = nil ==> t partition is disappear

(defparameter *pure-theorist* t)

(defclass Object-Browser-Window (Dialog)
    (
     (bag       :initform nil   :accessor bag)
     (part-tree :initform nil   :accessor part-tree)
     (display   :initform nil   :accessor display)
     )
   )

(defun ObjectBrowser (classifier object* &optional display)
   (let (bag obw)
      (setf bag (make-classifier classifier))
      (put-object* bag object*)
      (setf obw (make-object-browser-window bag :display display
                 ))
      )
   )

(defparameter *classifier* nil)

;;  partition tree to outline-item structure

(defmethod make-partition-item ((cl classifier) display)
   (if *pure-theorist*
      (make-virtual-partition-item (list (get-t-partition cl)) display)
      (make-virtual-partition-item (child* (get-t-partition cl)) display)
      )
   )

(defun grouping-by-name (part*)
   (loop
     with hash = (make-hash-table :test #'equal)
     for part in part*
     do
     (debug '(grouping-by-name) t "/~A/~%" (name part))
     (push  part (gethash (name part) hash))
     finally (return hash)
     )
   )

(defun make-virtual-partition-item (part* display)
   (let ((htable (grouping-by-name part*)))
      (debug '(make-virtual-partition-item) t "~S~%" (loop for name being the hash-keys in htable
                                                       collect name))
      (loop for name being the hash-keys in htable
        using (hash-value sibling*)
        collect
        (progn
          (debug '(make-virtual-partition-item) t "~A -> ~S~%" name sibling*)
          (make-outline-item
            name
            nil
            :closed
            (append (make-virtual-partition-item
                     (gather-child* sibling*) display)
              (make-object-item* (gather-object* sibling*) display))
            :selected-p nil
            :font  #.(make-font nil :terminal 18 '(:normal))
            :foreground-color #S(rgb red 0 green 0 blue 0)
            )
          )
        )
      )
   )

(defun gather-object* (part*)
   (loop for part in part* append (object* part)))

(defun gather-child* (part*)
   (loop for part in part* append (child* part)))

#|
(defmethod make-partition-item (part display)
   (make-outline-item
     (name part)
     nil
     :closed
     (append (make-virtual-partition-item (child* part) display)
              (make-object-item* (object* part) display))
     :selected-p nil
     :font  #.(make-font nil :terminal 18 '(:normal))
     :foreground-color #S(rgb red 0 green 0 blue 0)
     )
   )

(defun make-partition-item* (part* display)
   (loop for part in part* collect
     (make-partition-item part display)
     )
   )
|#


(defun make-object-item* (object* display)
   (loop for object in object* collect
     (make-object-item object display)
     )
   )


(defun make-object-item (object display)
   (make-outline-item
     (if display (funcall display object) object)
     nil
     :closed
     nil
     :selected-p nil
     :font  #.(make-font-ex nil :courier 15 '(:normal))
     :foreground-color #S(rgb red 0 green 0 blue 0)
     )
   )

#|
(defparameter *classifier* nil)

(defmethod put-obj* ((win object-browser-window) object*)
   (put-object* (bag win) object*)
   (setf (outline-item (widget :partition-tree win) t)
         (make-partition-item* (bag win) (display win)))
   (delay-redraw (widget :partition-tree w1))
   (resume-redraw (widget :partition-tree w1))
   )
|#

;; representation normal order
(defun rep-gt (x y)
   (if (and (typep x partition)(typep y partition))
      (or (string> (string (name (category x)))(string (name (category y))))
          (and (string= (string (name (category x)))(string (name (category y))))
               (string> (string (name x))(string (name y))))
          )
      t)
   )

;;

(defun new-position ()
   (let ((win (window ':object-browser-window)))
      (if win
         (box-move (window-interior win)
           (make-position 20 20))
         (make-box 388 76 1131 730)
         )
      )
   )

;;;;; maintain linkage for classifer to item

;; if change the child* or object*, i must redraw the (part-item part)

;(defmethod put-object :after ((part partition) object)





;;;;;;

(defun make-object-browser-window (bag &key (parent *lisp-main-window*)
                                   (window-interior (new-position))
                                   (name :object-browser-window)
                                   (title "Object Browser")
                                    (display nil))
   (setq *loaded-but-uncreated-windows*
      (delete 'object-browser-window *loaded-but-uncreated-windows*))
   (let (window-0 window-1 window-2 window-3 window-4 itemlist)
      (setq itemlist (make-partition-item bag display))
      (setq window-0
         (open-dialog
            (list
               (make-dialog-item
                  :widget 'static-text
                  :name :classifier-name-title
                  :title (delete #\Newline "Static Text 3")
                  :value (delete #\Newline "Classifier :")
                  :box (make-box 5 5 82 27)
                  :tabstop nil
                  :groupstart t
                  :font (make-font-ex :swiss :arial 15 '(:bold)))
              (make-dialog-item
                  :widget 'static-text
                  :name :classifier-name
                  :title (delete #\Newline "classifier-name")
                  :value (delete #\Newline (string (class-name (class-of bag))))
                  :box (make-box 86 5 564 27)
                  :tabstop nil
                  :groupstart t
                  :font (make-font-ex :swiss :arial 15 nil))
               (make-dialog-item
                  :widget 'outline
                  :name :partition-tree
                  :title (delete #\Newline "partition tree")
                  :value :top-2
                  :box (make-box 4 31 743 654)
                  :tabstop t
                  :groupstart nil
                  :editable-in-place-p nil
                  :key 'capitalize-object
                  :range itemlist
                  :font (make-font-ex :swiss :arial 13 nil)
                  :editable-in-place-p nil
                  :user-scrollable t
                 )
               )
            'object-browser-window parent
            :name name
            :title title
            :font (make-font nil :system 22 nil)
            :window-state :shrunk
            :window-border :frame
            :left-attachment nil
            :top-attachment nil
            :right-attachment nil
            :bottom-attachment nil
            :user-movable t
            :user-resizable t
            :user-closable t
            :user-shrinkable t
            :user-scrollable nil
            :overlapped nil
            :background-color light-gray
            :pop-up-p nil
            :window-interior window-interior))
      (setf (bag window-0) bag)
      (setf (part-tree window-0) itemlist)
      (setf (display window-0) display)
      (setf (window-editable-p window-0) t)
      (setf (getf (stream-plist window-0) :path)
         (let* ((pathname (load-time-value *load-pathname*)))
            (if
               (or (not (pathnamep pathname))
                  (member (pathname-type pathname) *fsl-extensions*
                     :test #'string-equal))
               "K:\\ALLEGRO\\LISPWORK\\ObjClass\\objbrow.bil" (namestring pathname))))
      (setf (getf (stream-plist window-0) :startup-state) nil)
      (setf (getf (stream-plist window-0) :top-level-p) nil)
      (setf (help-string window-0) (delete #\Newline nil))
      (setf (getf (stream-plist window-0) :package) nil)
      nil
      (let* ((box (getf *window-exteriors* (object-name window-0))))
         (when box (reshape-window-exterior window-0 box)))
      (show-window window-0 nil)
      window-0))


t
