/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha.h,v 1.17.2.5 2004/12/30 14:15:50 fuyu Exp $
 */

#ifndef _OCHUSHA_H_
#define _OCHUSHA_H_

#include "config.h"

#include <glib.h>
#include <iconv.h>

#include <zlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_BOARDLIST_XML		"boardlist.xml.gz"
#define OCHUSHA_CONFIG_XML		"config.xml.gz"
#define OCHUSHA_THREADLIST_XML		"threadlist.xml.gz"

#define OCHUSHA_USER_AGENT		"Monazilla/1.00 (Ochusha/" VERSION ")"

/*
 * ʲ2ch˰¸ƤΤǡ̤ξΤ˾
 * 櫡ġ
 */
#define OCHUSHA_DEFAULT_BBSMENU_URL	"http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html"
#define OCHUSHA_SUBJECT_TXT		"subject.txt"
#define OCHUSHA_SUBBACK_HTML		"subback.html"

#define OCHUSHA_DOLIB_URL		"https://2chv.tora3.net/futen.cgi"
#define OCHUSHA_DOLIB_USER_AGENT	"DOLIB/1.00"
#define OCHUSHA_DOLIB_X_2CH_UA		"Ochusha/" VERSION
#define OCHUSHA_CA_BUNDLE_CRT		PKGDATADIR "/ca-bundle.crt"

#define OCHUSHA_2CH_BE_LOGIN_URL	"http://be.2ch.net/test/login.php"


/*
 * 2ch1000쥹¤ΤǡѤʾ1024
 * ʬJBBSФȤ⤽¤ʤäꤹ͡
 * ʤΤǡߤlibochushaǤMAX_RESPONSEϥ쥹㤹̤
 * ͤȤƤΤ߻ȤäƤ롣
 */
#define MAX_RESPONSE			1024


typedef struct _OchushaConfig OchushaConfig;


/*
 * Ū˴ؤΤɤ
 */
struct _OchushaConfig
{
  /* ochushaΥ桼ۡǥ쥯ȥؤPATH̾(ɸǤ$HOME/.ochusha) */
  char *home;


  /* İμѤURL: 2ch¸ʤΤ;ɤ٤⤷ */
  char *bbsmenu_url;

  char *login_2ch_url;
  gboolean login_2ch;
  char *session_id_2ch;

  char *login_2ch_be_url;
  char *session_id_2ch_be;

  gboolean use_2ch_be_id_for_2ch;


  /* proxyϢ */
  gboolean enable_proxy;
  gboolean enable_proxy_only_for_posting;
  gboolean enable_proxy_auth;

  char *proxy_url;
  char *proxy_user;
  char *proxy_password;


  /* chunksize */
  int threadlist_chunksize;
  int thread_chunksize;


  /* network˥åȤ */
  gboolean offline;
};


/*
 * OCHUSHA_HOMEϢ
 */
void ochusha_config_prepare_home(OchushaConfig *config);
char *ochusha_config_find_file(const OchushaConfig *config,
			       const char *filename, const char *dir);
char *ochusha_config_find_directory(const OchushaConfig *config,
				    const char *filename, const char *dir);
int ochusha_config_open_file(const OchushaConfig *config, const char *filename,
			     const char *dir, int flags);
void ochusha_config_unlink_file(const OchushaConfig *config,
				const char *filename, const char *dir);
void ochusha_config_unlink_directory(const OchushaConfig *config,
				     const char *dirname);

gboolean ochusha_config_cache_file_exist(const OchushaConfig *config,
					 const char *url);
char *ochusha_config_cache_find_file(const OchushaConfig *config,
				     const char *url);
int ochusha_config_cache_open_file(const OchushaConfig *config,
				   const char *url, int flags);
void ochusha_config_cache_unlink_file(const OchushaConfig *config,
				      const char *url);
int ochusha_config_image_cache_open_file(const OchushaConfig *config,
					 const char *url, int flags);
void ochusha_config_image_cache_unlink_file(const OchushaConfig *config,
					    const char *url);


/*
 * config.xmlϢ
 */
typedef void WritePreferenceElementFunc(gzFile config_xml,
					gpointer user_data);
typedef void ReadPreferenceElementFunc(GHashTable *pref_attrs,
				       gpointer user_data);

gboolean ochusha_write_config_xml(OchushaConfig *config, const char *subdir,
				  WritePreferenceElementFunc *optional,
				  gpointer user_data);
void ochusha_read_config_xml(OchushaConfig *config, const char *subdir,
			     ReadPreferenceElementFunc *optional,
			     gpointer user_data);


/*
 * GHashTableͤФؿ
 */
gboolean ochusha_utils_get_attribute_boolean(GHashTable *hash_table,
					     const char *attr_name);
int ochusha_utils_get_attribute_int(GHashTable *hash_table,
				    const char *attr_name);
char *ochusha_utils_get_attribute_string(GHashTable *hash_table,
					 const char *attr_name);


typedef struct _OchushaBBSThread OchushaBBSThread;
typedef struct _OchushaBBSThreadClass OchushaBBSThreadClass;

typedef gboolean EachThreadCallback(OchushaBBSThread *thread,
				    gpointer user_data);
typedef struct _OchushaBBSResponse OchushaBBSResponse;
typedef gboolean StartThreadCallback(OchushaBBSThread *thread,
				     const char *title,
				     gpointer callback_data);
typedef gboolean EachResponseCallback(OchushaBBSThread *thread, int number,
				      const OchushaBBSResponse *response,
				      gpointer callback_data);
typedef gboolean BrokenResponseCallback(OchushaBBSThread *thread, int number,
					gpointer callback_data);
typedef gboolean EndThreadCallback(OchushaBBSThread *thread, gboolean finished,
				   gpointer callback_data);
typedef void StartParsingCallback(gpointer callback_data);
typedef void BeforeWaitCallback(gpointer callback_data);
typedef void AfterWaitCallback(gpointer callback_data);
typedef void EndParsingCallback(gpointer callback_data);

struct _OchushaBBSResponse
{
  const gchar *name;
  const gchar *mailto;
  const gchar *date_id;
  const gchar *content;
};


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_H_ */
