/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id$
 */

#ifndef _THREADLIST_VIEW_H_
#define _THREADLIST_VIEW_H_

#include "ochusha.h"

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif


#define THREADLIST_VIEW_TYPE			(threadlist_view_get_type())
#define THREADLIST_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), THREADLIST_VIEW_TYPE, ThreadlistView))
#define THREADLIST_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), THREADLIST_VIEW_TYPE, ThreadlistViewClass))
#define IS_THREADLIST_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), THREADLIST_VIEW_TYPE))
#define IS_THREADLIST_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), THREADLIST_VIEW_TYPE))
#define THREADLIST_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), THREADLIST_VIEW_TYPE, ThreadlistViewClass))


typedef struct _ThreadlistView ThreadlistView;
typedef struct _ThreadlistViewClass ThreadlistViewClass;

typedef struct _ThreadlistInfo ThreadlistInfo;


struct _ThreadlistView
{
  GtkScrolledWindow container;

  GtkTreeView *view;
  GtkTreeModel *model;

  GtkTreeViewColumn *rank_column;
  GtkTreeViewColumn *mark_column;
  GtkTreeViewColumn *title_column;
  GtkTreeViewColumn *n_res_column;
  GtkTreeViewColumn *n_read_column;
  GtkTreeViewColumn *rank_diff_column;

  GtkTreeSelection *selection;

  gint last_rank_diff;

  gint number_of_threads;

  ThreadlistInfo *(*threadlist_info_new)(BBSThread *thread);

  BBSThread *recently_pointed_thread;

  gboolean model_is_opened;
};


struct _ThreadlistViewClass
{
  GtkScrolledWindowClass parent_class;

  void (*open_view)(ThreadlistView *threadlist_view, BBSThread *thread,
		    gboolean in_tab);

  void (*thread_mouse_over)(ThreadlistView *threadlist_view,
			    BBSThread *thread);
  void (*thread_mouse_out)(ThreadlistView *threadlist_view, BBSThread *thread);

  void (*toggle_mark)(ThreadlistView *threadlist_view, BBSThread *thread);
  void (*toggle_hide)(ThreadlistView *threadlist_view, BBSThread *thread);
  void (*mark_thread)(ThreadlistView *threadlist_view, BBSThread *thread,
		      gboolean do_mark);
  gboolean (*advance_view)(ThreadlistView *threadlist_view, BBSThread *thread);
  gboolean (*back_view)(ThreadlistView *threadlist_view, BBSThread *thread);

  gboolean (*move_cursor)(ThreadlistView *threadlist_view,
			  GtkMovementStep step, gint count);

  void (*do_on_selection)(ThreadlistView *threadlist_view, gint what_to_do);
  void (*do_on_thread_at_cursor)(ThreadlistView *threadlist_view,
				 gint what_to_do);
};


struct _ThreadlistInfo
{
  GtkTreeIter iter;
  ThreadlistView *threadlist_view;

  /* Ǹ˥򹹿Ȥν */
  gint view_rank;

  /* ˤ(ThreadlistEntryStateORȤä) */
  gint view_flags;
};


typedef enum
{
  BBS_THREAD_FAVORITE = 1 << 0,
  BBS_THREAD_HIDDEN = 1 << 1,
  BBS_THREAD_HIGHLIGHT = 1 << 2,
} ThreadlistEntryState;


GType threadlist_view_get_type(void);
GtkWidget *threadlist_view_new(void);


typedef ThreadlistInfo *ThreadlistInfoNewFunc(BBSThread *thread);

gboolean threadlist_view_open(ThreadlistView *view,
			      ThreadlistInfoNewFunc *factory);
void threadlist_view_close(ThreadlistView *view);
void threadlist_view_append_thread(ThreadlistView *view, BBSThread *thread,
				   gint rank);
void threadlist_view_update_thread(ThreadlistView *view, BBSThread *thread);
void threadlist_view_scroll_to_thread(ThreadlistView *view, BBSThread *thread);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _THREADLIST_VIEW_H_ */
