/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_network_broker.h,v 1.1 2003/05/25 08:44:04 fuyu Exp $
 */

#ifndef _OCHUSHA_NETWORK_BROKER_H_
#define _OCHUSHA_NETWORK_BROKER_H_

#include "ochusha.h"
#include "ochusha_async_buffer.h"

#include <ghttp.h>

#include <glib-object.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif


#define OCHUSHA_TYPE_NETWORK_BROKER		(ochusha_network_broker_get_type())
#define OCHUSHA_NETWORK_BROKER(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_NETWORK_BROKER, OchushaNetworkBroker))
#define OCHUSHA_NETWORK_BROKER_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_NETWORK_BROKER, OchushaNetworkBrokerClass))
#define OCHUSHA_IS_NETWORK_BROKER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_NETWORK_BROKER))
#define OCHUSHA_IS_NETWORK_BROKER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_NETWORK_BROKER))
#define OCHUSHA_NETWORK_BROKER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_NETWORK_BROKER, OchushaTypeNetworkBrokerClass))


typedef struct _OchushaNetworkBroker OchushaNetworkBroker;
typedef struct _OchushaNetworkBrokerClass OchushaNetworkBrokerClass;


typedef enum
{
  OCHUSHA_NETWORK_BROKER_CACHE_IGNORE,
  OCHUSHA_NETWORK_BROKER_CACHE_ONLY,
  OCHUSHA_NETWORK_BROKER_CACHE_AS_IS,
  OCHUSHA_NETWORK_BROKER_CACHE_TRY_UPDATE,
  OCHUSHA_NETWORK_BROKER_CACHE_TRY_REFRESH
} OchushaNetworkBrokerCacheMode;


typedef enum {
  OCHUSHA_NETWORK_BROKER_FAILURE_REASON_UNKNOWN,
  OCHUSHA_NETWORK_BROKER_FAILURE_REASON_NOT_CONNECTED,
  OCHUSHA_NETWORK_BROKER_FAILURE_REASON_MMAP_FAILED,
  OCHUSHA_NETWORK_BROKER_FAILURE_REASON_CACHE_NOT_FOUND,
  OCHUSHA_NETWORK_BROKER_FAILURE_REASON_INVALID_PROXY,
  OCHUSHA_NETWORK_BROKER_FAILURE_REASON_ACCESS_TERMINATED,
} OchushaNetworkBrokerFailureReason;


struct _OchushaNetworkBroker
{
  GObject parent_object;

  const OchushaConfig *config;
};


struct _OchushaNetworkBrokerClass
{
  GObjectClass parent_class;

  /* signal handlers */
  gboolean (*access_started)(OchushaNetworkBroker *broker,
			     OchushaAsyncBuffer *buffer);
  gboolean (*access_progressed)(OchushaNetworkBroker *broker,
				OchushaAsyncBuffer *buffer,
				int bytes_read, int bytes_total);
  gboolean (*access_completed)(OchushaNetworkBroker *broker,
			       OchushaAsyncBuffer *buffer);
  gboolean (*access_terminated)(OchushaNetworkBroker *broker,
				OchushaAsyncBuffer *buffer);
  gboolean (*access_failed)(OchushaNetworkBroker *broker,
			    OchushaAsyncBuffer *buffer,
			    OchushaNetworkBrokerFailureReason reason_code,
			    const gchar *reason);
};


typedef enum
{
  OCHUSHA_NETWORK_BROKER_BUFFER_STATE_UNKNOWN,
  OCHUSHA_NETWORK_BROKER_BUFFER_STATE_DIRECT_ACCESS,
  OCHUSHA_NETWORK_BROKER_BUFFER_STATE_CACHE_HIT,
  OCHUSHA_NETWORK_BROKER_BUFFER_STATE_CACHE_IS_OK,
  OCHUSHA_NETWORK_BROKER_BUFFER_STATE_CACHE_IS_DIRTY,
  OCHUSHA_NETWORK_BROKER_BUFFER_STATE_ACCESS_OK,
  OCHUSHA_NETWORK_BROKER_BUFFER_STATE_ACCESS_FAILED
} OchushaNetworkBrokerBufferState;


typedef struct _OchushaNetworkBrokerBufferStatus
{
  volatile OchushaNetworkBrokerBufferState state;
  int status_code;
  char *last_modified;
} OchushaNetworkBrokerBufferStatus;


GType ochusha_network_broker_get_type(void);
OchushaNetworkBroker *ochusha_network_broker_new(OchushaConfig *config);

OchushaAsyncBuffer *ochusha_network_broker_read_from_url(
					OchushaNetworkBroker *broker,
					const char *url,
					const char *if_modified_since,
					OchushaNetworkBrokerCacheMode mode);

const char *ochusha_network_broker_get_response_header(
						  OchushaNetworkBroker *broker,
						  OchushaAsyncBuffer *buffer,
						  const char *header);
int ochusha_network_broker_get_header_names(OchushaNetworkBroker *broker,
					    OchushaAsyncBuffer *buffer,
					    char ***headers, int *num_headers);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_NETWORK_BROKER_H_ */
