/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: response_editor.c,v 1.1 2003/06/27 08:35:50 fuyu Exp $
 */

#include "config.h"

#include "ochusha.h"
#include "ochusha_private.h"

#include "response_editor.h"

#include "marshal.h"

#include "utils.h"

#include <glib.h>
#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


static void response_editor_class_init(ResponseEditorClass *klass);
static void response_editor_init(ResponseEditor *editor);
static void response_editor_finalize(GObject *object);
static void response_editor_destroy(GtkObject *object);


GType
response_editor_get_type(void)
{
  static GType response_editor_type = 0;

  if (response_editor_type == 0)
    {
      static const GTypeInfo response_editor_info =
	{
	  sizeof(ResponseEditorClass),
	  NULL,	/* base_init */
	  NULL,	/* base_finalize */
	  (GClassInitFunc)response_editor_class_init,
	  NULL,	/* class_finalize */
	  NULL,	/* class_data */
	  sizeof(ResponseEditor),
	  0,	/* n_preallocs */
	  (GInstanceInitFunc)response_editor_init,
	};

      response_editor_type = g_type_register_static(GTK_TYPE_VBOX,
						    "ResponseEditor",
						    &response_editor_info, 0);
    }

  return response_editor_type;
}


GtkVBoxClass *parent_class;


static void
response_editor_class_init(ResponseEditorClass *klass)
{
  GObjectClass *o_class = (GObjectClass *)klass;
  GtkObjectClass *object_class = (GtkObjectClass *)klass;

  parent_class = g_type_class_peek_parent(klass);

  /* GObject signals */
  o_class->finalize = response_editor_finalize;

  /* GtkObject signals */
  object_class->destroy = response_editor_destroy;
}


static void
response_editor_init(ResponseEditor *editor)
{
}


static void
response_editor_finalize(GObject *object)
{
}


static void
response_editor_destroy(GtkObject *object)
{
}
