/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ugly_gtk2utils.c,v 1.4 2003/06/07 14:35:31 fuyu Exp $
 */

#include "ugly_gtk2utils.h"

#include <gdk/gdkkeysyms.h>
#include <glib.h>
#include <gtk/gtk.h>

#include <stdio.h>


void
ugly_gtk_tree_view_unbind_keys(void)
{
  GObjectClass *klass = g_type_class_ref(GTK_TYPE_TREE_VIEW);
  GtkBindingSet *binding_set = gtk_binding_set_by_class(klass);

  gtk_binding_entry_remove(binding_set, GDK_space, 0);
  gtk_binding_entry_remove(binding_set, GDK_BackSpace, 0);
  gtk_binding_entry_remove(binding_set, GDK_f, GDK_CONTROL_MASK);
  gtk_binding_entry_remove(binding_set, GDK_F, GDK_CONTROL_MASK);
  gtk_binding_entry_remove(binding_set, GDK_Up, 0);
  gtk_binding_entry_remove(binding_set, GDK_Down, 0);
  gtk_binding_entry_remove(binding_set, GDK_p, GDK_CONTROL_MASK);
  gtk_binding_entry_remove(binding_set, GDK_n, GDK_CONTROL_MASK);

  g_type_class_unref(klass);

  klass = g_type_class_ref(GTK_TYPE_TEXT_VIEW);
  binding_set = gtk_binding_set_by_class(klass);
  gtk_binding_entry_remove(binding_set, GDK_End, GDK_CONTROL_MASK);
  gtk_binding_entry_remove(binding_set, GDK_KP_End, GDK_CONTROL_MASK);
  gtk_binding_entry_remove(binding_set, GDK_Home, GDK_CONTROL_MASK);
  gtk_binding_entry_remove(binding_set, GDK_KP_Home, GDK_CONTROL_MASK);

  g_type_class_unref(klass);
}


static gboolean
delayed_g_object_unref_real(gpointer data)
{
  g_return_val_if_fail(G_IS_OBJECT(data), FALSE);
#if DEBUG_GUI
  fprintf(stderr, "delayed_g_object_unref_real: data=%p data->ref_count=%d\n",
	  data, G_OBJECT(data)->ref_count);
#endif
  if (G_OBJECT(data)->ref_count > 1)
    return TRUE;

  g_object_unref(G_OBJECT(data));
#if DEBUG_GUI
  fprintf(stderr, "delayed_g_object_unref_real:  data=%p data->ref_count=%d\n",
	  data, ((GObject *)data)->ref_count);
#endif
  return FALSE;
}


/*
 * GtkTreeViewGtkTextFiewʤGTK+ǡidleؿϿƤ륦
 * åȤξ硢idleؿƤ֤˥åȤ
 * GTK+롣кΤᡢΥץ饤ƥϿ
 * idleؿưޤǥ֥ȤƤȤǡ
 * ʲǽʸ¤˲򤹤롣
 */
void
delayed_g_object_unref(GObject *object)
{
  g_return_if_fail(G_IS_OBJECT(object));

  g_idle_add_full(G_PRIORITY_LOW, delayed_g_object_unref_real, object, NULL);
}

