(define (list-entry-decorate-default
 	 new-responses filter-enabled filter-ok new-thread marked hidden)
  (cond (hidden (cons list-entry-fg-hidden list-entry-bg-hidden))
 	(new-thread (cons list-entry-fg-strong list-entry-bg-strong))
 	(filter-ok
	 (cons (if new-responses list-entry-fg-emph list-entry-fg-normal)
	       (if filter-enabled list-entry-bg-normal list-entry-bg-emph)))
 	nil))

(define (list-entry-decorate-default-old
	 new-responses filter-enabled filter-ok new-thread marked hidden)
  (cons (if hidden
	    list-entry-fg-hidden
	    (if (and new-responses marked) list-entry-fg-emph
		list-entry-fg-normal))
	(if new-thread list-entry-bg-strong
	    (if (and new-responses filter-ok) list-entry-bg-emph
		list-entry-bg-normal))))


(define list-entry-decorate list-entry-decorate-default)
;(define list-entry-decorate list-entry-decorate-default-old)


(define (calculate-weight-default
	 rank n-res n-got n-read dead new marked hidden)
  (+ (if hidden 1000 0)
     (if marked 0 100)
     (if (> n-got 0) (if (> n-res n-got) 0 200) 400)
     (if new 0 100)
     (if dead 500 0)))

(define (calculate-weight-default-old
	 rank n-res n-got n-read dead new marked hidden)
  (+ (if hidden 1000 0)
     (if marked 0 200)
     (if (> n-got 0) (- n-got n-res) 100)
     (if new 0 50)
     (if dead 100 0)))

(define calculate-weight calculate-weight-default)
;(define calculate-weight calculate-weight-default-old)
