/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_ui.h,v 1.62 2004/01/15 03:27:45 fuyu Exp $
 */

#ifndef _OCHUSHA_UI_H_
#define _OCHUSHA_UI_H_

#include "config.h"
#include "ochusha.h"
#include "ochusha_private.h"
#include "ochusha_async_buffer.h"
#include "ochusha_bbs_table.h"
#include "ochusha_network_broker.h"

#include "ochusha_ui_private.h"

#include "icon_label.h"

#include <glib.h>
#include <gtk/gtk.h>


#define ENABLE_DEBUG_CONSOLE						1
#define ENABLE_MAIN_TOOLBAR						0

#define OCHUSHA_GTKRC					"ochusha-gtkrc"
#define OCHUSHA_BOOKMARK_XML				"bookmark.xml.gz"
#define OCHUSHA_SESSION_XML				"session.xml.gz"
#define OCHUSHA_INIT_SCM				"ochusha-init.scm"

#define OCHUSHA_CURRENT_CONFIG_VERSION					2

#define OCHUSHA_DEFAULT_WIDTH						600
#define OCHUSHA_DEFAULT_HEIGHT						400
#define OCHUSHA_DEFAULT_BOARDLIST_WIDTH					150
#define OCHUSHA_DEFAULT_THREADLIST_HEIGHT				100

#define OCHUSHA_DEFAULT_BOARD_TAB_SHRINKABLE				FALSE
#define OCHUSHA_DEFAULT_BOARD_TAB_MINIMUM_SIZE				80
#define OCHUSHA_DEFAULT_BOARD_TAB_ENABLE_TOOLTIPS			FALSE

#define OCHUSHA_DEFAULT_THREADLIST_FILTER_RULE			"FhDrSNsa"

#define OCHUSHA_DEFAULT_THREAD_TAB_SHRINKABLE				TRUE
#define OCHUSHA_DEFAULT_THREAD_TAB_MINIMUM_SIZE				80
#define OCHUSHA_DEFAULT_THREAD_TAB_ENABLE_TOOLTIPS			TRUE
#define OCHUSHA_DEFAULT_SHOW_THREADLIST_ENTRY_WHEN_THREAD_SELECTED	FALSE

#define OCHUSHA_DEFAULT_THREADLIST_VIEW_CONTENTS		"RMTVuDL"

#define OCHUSHA_DEFAULT_ENABLE_POPUP_TITLE				FALSE
#define OCHUSHA_DEFAULT_ENABLE_POPUP_RESPONSE				TRUE

#define OCHUSHA_DEFAULT_POPUP_DELAY					500
#define OCHUSHA_DEFAULT_POPUP_CLOSE_DELAY				100
#define OCHUSHA_DEFAULT_MAXIMUM_NUMBER_OF_POPUP_RESPONSES		5

#define OCHUSHA_DEFAULT_ENABLE_SMART_POPUP_PLACEMENT			TRUE
#define OCHUSHA_DEFAULT_ANALYZE_INFORMAL_LINKS				TRUE

#define OCHUSHA_DEFAULT_HIDE_HIDDEN_BOARDLIST_ITEMS			FALSE
#define OCHUSHA_DEFAULT_HIDE_HIDDEN_THREADS				FALSE

#define OCHUSHA_DEFAULT_SHOW_MAILTO_MODE	THREAD_VIEW_MAILTO_MODE_DEFAULT

#define OCHUSHA_DEFAULT_WEB_BROWSER_TEMPLATE	"mozilla -raise -remote \"openURL(%s,new-window)\""

#define THREAD_VIEW_EXTRA_WIDTH			30

#define OCHUSHA_MINIMIZED_ICON			"Ochusha-Minimized"

#define OCHUSHA_STOCK_WRITE_RESPONSE		"Ochusha-Write-Response"
#define OCHUSHA_STOCK_NET_PROGRESS0		"Ochusha-Net-Progress-0"
#define OCHUSHA_STOCK_NET_PROGRESS1		"Ochusha-Net-Progress-1"
#define OCHUSHA_STOCK_NET_PROGRESS2		"Ochusha-Net-Progress-2"
#define OCHUSHA_STOCK_NET_PROGRESS3		"Ochusha-Net-Progress-3"
#define OCHUSHA_STOCK_NET_PREPARATION		"Ochusha-Net-Preparation"
#define OCHUSHA_STOCK_NET_DONE			"Ochusha-Net-Done"
#define OCHUSHA_STOCK_NET_ERROR			"Ochusha-Net-Error"


#define TAB_LABEL_ICON_PROGRESS0		0
#define TAB_LABEL_ICON_PROGRESS1		1
#define TAB_LABEL_ICON_PROGRESS2		2
#define TAB_LABEL_ICON_PROGRESS3		3
#define TAB_LABEL_ICON_PREPARATION		4
#define TAB_LABEL_ICON_DONE			5
#define TAB_LABEL_ICON_ERROR			6


#ifdef __cplusplus
extern "C" {
#endif

typedef struct _OchushaApplication OchushaApplication;


#include "threadlist_filter.h"

typedef enum
{
  THREAD_VIEW_MAILTO_MODE_DEFAULT = 0,
  THREAD_VIEW_MAILTO_MODE_SHOW,
  THREAD_VIEW_MAILTO_MODE_HIDE
} ThreadViewMailtoMode;


struct _OchushaApplication
{
  int config_version;

  GtkWindow *top_level;
  GtkBox *main_window;

  GtkWidget *menu_bar;

#if ENABLE_MAIN_TOOLBAR
  GtkToolbar *toolbar;

  /* toolbar */
  GtkCombo *url_box;
#endif

  GtkWidget *contents_window;		/* PanedNotebook */

  /* contents_windowselectorʬ */
  GtkWidget *boardlist_view;		/* BoardlistView */

  /* ߤĤΥ˥ե륿ŬѤ뤫ɤɽ */
  GtkToggleButton *filter_button;

  GtkStatusbar *statusbar;

  GtkClipboard *clipboard;
  GtkClipboard *clipboard_primary;


  /* Ϣ */
  GtkWidget *threadlist_search_window;

  int threadlist_search_direction;
  gboolean threadlist_search_enable_wrap;
  gboolean threadlist_search_match_case;
  gboolean threadlist_search_use_regexp;


  /* ⸡Ϣ */
  GtkWidget *thread_search_window;
  GtkWidget *last_search_target_widget;

  int thread_search_direction;
  gboolean thread_search_enable_wrap;
  gboolean thread_search_match_case;
  gboolean thread_search_use_regexp;


  /* İθǡ */
  OchushaBoardCategory *my_folder;
  OchushaBulletinBoard *favorites;
  OchushaBulletinBoard *all_threads;
  OchushaBBSTable *table;


  /* window(ǥե)ʤ */
  int x_pos;
  int y_pos;
  int width;
  int height;
  int boardlist_width;
  int threadlist_height;


  /* paneɽˡʤ */
  int boardlist_pane_style;
  gboolean board_tab_shrinkable;
  guint board_tab_minimum_size;
  gboolean board_tab_enable_tooltips;
  gboolean board_tab_always_show;
  gboolean hide_hidden_boardlist_items;
  gboolean expand_only_one_category;


  int threadlist_pane_style;
  gboolean thread_tab_shrinkable;
  guint thread_tab_minimum_size;
  gboolean thread_tab_enable_tooltips;
  gboolean thread_tab_always_show;
  gboolean show_threadlist_entry_when_thread_selected;
  char *threadlist_view_contents;
  gboolean use_builtin_calculate_weight;
  gboolean sort_threadlist_by_weight;

  gboolean default_open_in_tab;
  gboolean select_tab_when_opened;


  /* ɽϢ */
  char *thread_view_font_name;
  gboolean enable_transparent_a_bone;
  gboolean disable_popup_a_bone;

  gboolean hide_bookmark;
  gboolean stick_bookmark;
  gchar *bookmark_text;


  /* ΤΥǥե */
  ThreadViewMailtoMode show_mailto_mode;


  gboolean a_bone_by_name;
  gchar *a_bone_by_name_pattern;

  gboolean a_bone_by_id;
  gchar *a_bone_by_id_pattern;

  gboolean a_bone_by_content;
  gchar *a_bone_by_content_pattern;


  /* 쥿Υݥåץå״Ϣ */
  gboolean enable_popup_title;
  guint popup_title_delay;

  
  /* 쥹Υݥåץå״Ϣ */
  gboolean enable_popup_response;
  guint popup_response_delay;
  guint popup_close_delay;
  gboolean enable_smart_popup_placement;
  int maximum_number_of_popup_responses;
  gboolean analyze_informal_links;


  /* ֥֥饦Υޥɥ饤ƥץ졼 */
  char *web_browser_template;


  /* Υ桼ǥեȥե륿롼 */
  ThreadlistFilter user_default_filter;
  gboolean hide_hidden_threads;

  OchushaNetworkBroker *broker;


  /* Ǹν񤭹߻̾ */
  gchar *last_name;

  /* Ǹν񤭹߻Υᥤ */
  gchar *last_mail;

  /* ˽λɤ */
  gboolean shutdown_succeeded;
  gboolean recover_mode;
  gboolean states_saved;


  /* XSMPϢ */
  int argc;
  char **argv;

  gpointer ice_connection;
  guint ice_connection_poll_id;

  gpointer smc_connection;
  char *sm_client_id;
  char *previous_sm_client_id;

  char *session_id;
  char *session_subdir;

  FILE *log_file;

  OchushaConfig config;
};


typedef enum
{
  MAIN_MENU_QUIT = 1,
  MAIN_MENU_OPEN_URL,
  MAIN_MENU_REFRESH_BOARDLIST,
  MAIN_MENU_CREATE_NEW_CATEGORY,
  MAIN_MENU_ADD_BOARD,
  MAIN_MENU_CREATE_NEW_VIRTUAL_BOARD,
  MAIN_MENU_HIDE_HIDDEN_BOARDLIST_ITEMS,
  MAIN_MENU_REFRESH_THREAD,
  MAIN_MENU_REFRESH_THREAD_ALL,
  MAIN_MENU_REFRESH_THREADLIST,
  MAIN_MENU_REFRESH_THREADLIST_ALL,
  MAIN_MENU_USE_BUILTIN_CALCULATE_WEIGHT,
  MAIN_MENU_SORT_THREADLIST_BY_WEIGHT,
  MAIN_MENU_HIDE_HIDDEN_THREADS,
  MAIN_MENU_DEBUG_CONSOLE,
  MAIN_MENU_OPTIONS,
  MAIN_MENU_ABOUT,
} OchushaMainMenuAction;


void ochusha_write_preferences(OchushaApplication *application);
void ochusha_init_application(OchushaApplication *application);
void ochusha_set_main_menu_sensitive(OchushaMainMenuAction action,
				     gboolean sensitive);

void ochusha_clipboard_set_text(OchushaApplication *application,
				const gchar *text);

void ochusha_open_url(OchushaApplication *application, const char *url,
		      gboolean in_tab, gboolean use_web_browser);
#if ENABLE_MAIN_TOOLBAR
void set_current_url(OchushaApplication *application, const char *url);
const char *get_current_url(OchushaApplication *application);
#endif

void setup_for_tab_label_animation(OchushaAsyncBuffer *buffer,
				   IconLabel *tab_label);
GtkWidget *get_tab_label(const gchar *label_text);

void ochusha_create_new_category(OchushaApplication *application);
void ochusha_add_board(OchushaApplication *application, const char *url);
void ochusha_create_new_virtual_board(OchushaApplication *application);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_UI_H_ */
