/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ugly_gtk2utils.c,v 1.12 2004/01/16 08:01:46 fuyu Exp $
 */

#include "config.h"

#include "ochusha_private.h"
#include "ochusha_ui.h"

#include "ugly_gtk2utils.h"

#include <glib.h>
#include <gtk/gtk.h>

#include <stdio.h>


static gboolean
delayed_g_object_unref_real(gpointer data)
{
#if DEBUG_REF_COUNT
  GtkWidget *child;
#endif
  g_return_val_if_fail(G_IS_OBJECT(data), FALSE);
#if DEBUG_GUI
  fprintf(stderr, "delayed_g_object_unref_real: data=%p data->ref_count=%d\n",
	  data, G_OBJECT(data)->ref_count);
#endif
  if (((GObject *)data)->ref_count > 1)
    {
#if DEBUG_REF_COUNT
      fprintf(stderr, "delayed_g_object_unref_real: data=%p is still alive\n",
	      data);
#endif
      return TRUE;
    }

#if DEBUG_REF_COUNT
  if (GTK_IS_BIN(data))
    {
      child = gtk_bin_get_child(GTK_BIN(data));
      fprintf(stderr, "delayed_g_object_unref_real: child(%p)->ref_count=%d\n",
	      child, G_OBJECT(child)->ref_count);
    }
  else
    child = NULL;
#endif

  /* OCHU_THREADS_ENTER(); */
  gdk_threads_enter();

  OCHU_OBJECT_UNREF(data);

  gdk_threads_leave();
  /* OCHU_THREADS_LEAVE(); */

#if DEBUG_REF_COUNT
  if (child != NULL)
    {
      fprintf(stderr, "delayed_g_object_unref_real: child(%p)->ref_count=%d\n",
	      child, ((GObject *)child)->ref_count);
    }
#endif

#if DEBUG_GUI
  fprintf(stderr, "delayed_g_object_unref_real:  data=%p data->ref_count=%d\n",
	  data, ((GObject *)data)->ref_count);
#endif
  return FALSE;
}


/*
 * GtkTreeViewGtkTextFiewʤGTK+ǡidleؿϿƤ륦
 * åȤξ硢idleؿƤ֤˥åȤ
 * GTK+롣кΤᡢΥץ饤ƥϿ
 * idleؿưޤǥ֥ȤƤȤǡ
 * ʲǽʸ¤˲򤹤롣
 */
void
delayed_g_object_unref(GObject *object)
{
  g_return_if_fail(G_IS_OBJECT(object));

  g_idle_add_full(G_PRIORITY_LOW, delayed_g_object_unref_real, object, NULL);
}

