/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: utils.h,v 1.13 2004/01/14 12:23:23 fuyu Exp $
 */

#ifndef _UTILS_H_
#define _UTILS_H_

#include <glib-object.h>
#include <glib.h>
#include <iconv.h>
#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef OCHUSHA_UTILS_IMPLEMENTATION
extern iconv_t utf8_to_native;
#endif

/*
 * utilityؿʤ
 */
typedef size_t iconv_helper(const char **inbuf, size_t *inbytesleft,
			    char **outbuf, size_t *outbytesleft);

void initialize_common_converters(void);
char *convert_string(iconv_t converter, iconv_helper *helper,
		     const char *src, int length);
size_t cp932_to_utf8_helper(const char **inbuf, size_t *inbytesleft,
			    char **outbuf, size_t *outbytesleft);

gchar *wipe_string(const gchar *string);

char *ochusha_utils_url_extract_scheme(const char *url);
char *ochusha_utils_url_extract_http_server(const char *url);
char *ochusha_utils_url_extract_http_absolute_path(const char *url);
char *ochusha_utils_url_encode_string(const char *src);
char *ochusha_utils_url_decode_string(const char *src);

time_t ochusha_utils_get_utc_time(const char *date_string);

const char *mempbrk(const char *string, const char *charset, size_t len);
const char *reverse_strpbrk(const char *string, const char *charset);
int parse_int(const gchar *start, size_t len);


typedef struct _CGIQueryKeyTuple
{
  const char *name;
  int name_len;
  const char *value;
  int value_len;
} CGIQueryKeyTuple;

char *ochusha_utils_find_cgi_query_key(const char *src,
				       CGIQueryKeyTuple *result);

int mkdir_p(const char *path);


#if TRACE_MEMORY_USAGE
/*
 * ꡼åϢ
 */
void init_memory_trace(void);
void register_pointer(gpointer pointer, const char *where);
void unregister_pointer(gpointer pointer, const char *where);
void dump_pointers(void);
#endif


#if TRACE_REFCOUNT
void init_refcount_trace(void);
void trace_register_g_object(gpointer pointer, const char *file, int line);
void trace_g_object_ref(gpointer pointer, const char *file, int line);
void trace_g_object_unref(gpointer pointer, const char *file, int line);
void ochu_object_ref(gpointer pointer);
void ochu_object_unref(gpointer pointer);
void dump_objects(void);
#endif


#ifdef __cplusplus
} // extern "C"
#endif

#endif
