/**********************************************************************

  big5.c -  Oniguruma (regular expression library)

  Copyright (C) 2003  K.Kosako (kosako@sofnec.co.jp)

**********************************************************************/
#include "regint.h"

static CodePoint
big5_mbc_to_code(UChar* p, UChar* end)
{
  return enc_mbn_mbc_to_code(REG_ENCODING_BIG5, p, end);
}

static int
big5_code_to_mbc(CodePoint code, UChar *buf)
{
  return enc_mb2_code_to_mbc(REG_ENCODING_BIG5, code, buf);
}

static int
big5_mbc_to_lower(UChar* p, UChar* lower)
{
  return enc_mbn_mbc_to_lower(REG_ENCODING_BIG5, p, lower);
}

static int
big5_code_is_ctype(CodePoint code, unsigned int ctype)
{
  return enc_mb2_code_is_ctype(REG_ENCODING_BIG5, code, ctype);
}

static const char BIG5_CAN_BE_TRAIL_TABLE[256] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0
};

#define ismb_first(byte)  (RegEncodingBIG5.len_table[byte] > 1)
#define ismb_trail(byte)  BIG5_CAN_BE_TRAIL_TABLE[(byte)]

static UChar*
big5_left_adjust_char_head(UChar* start, UChar* s)
{
  UChar *p;
  int len;

  if (s <= start) return s;
  p = s;

  if (ismb_trail(*p)) {
    while (p > start) {
      if (! ismb_first(*--p)) {
	p++;
	break;
      }
    } 
  }
  len = enc_len(REG_ENCODING_BIG5, *p);
  if (p + len > s) return p;
  p += len;
  return p + ((s - p) & ~1);
}

static int
big5_is_allowed_reverse_match(UChar* s, UChar* end)
{
  UChar c = *s;

  return (ismb_trail(c) ? FALSE : TRUE);
}

RegCharEncodingType RegEncodingBIG5 = {
  {
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1
  },
  "Big5",    /* name */
  2,         /* max byte length */
  FALSE,     /* is_fold_match */
  ENC_CTYPE_SUPPORT_LEVEL_SB_ONLY,  /* ctype_support_level */
  FALSE,     /* is continuous sb mb codepoint */
  big5_mbc_to_code,
  enc_mb2_code_to_mbclen,
  enc_mb2_code_to_mbc_first,
  big5_code_to_mbc,
  big5_mbc_to_lower,
  enc_mbn_mbc_is_case_ambig,
  big5_code_is_ctype,
  enc_nothing_get_ctype_code_range,
  big5_left_adjust_char_head,
  big5_is_allowed_reverse_match,
  enc_nothing_get_all_fold_match_code,
  enc_nothing_get_fold_match_info
};
