﻿using System;
using System.Text;
using System.Linq;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.ComponentModel.Composition;

/** \brief ゲームオンのプラグインの名前空間 */
namespace OGSNET.Plugins.GameOn
{
    using OGSNET.Plugin;

    /** \brief GameOnの運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "GameOn")]
    public class Operation : OperationPluginBase
    {
        /** \brief 基本情報の初期化 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo("1.0.1.0", "ゲームオン運営プラグイン", "pine",
                    "ゲームオンが運営しているゲームの開始に使用されます。");

            this.OperationInfo =
                new OperationInfo("ゲームオン", "http://www.gamechu.jp/");
        }

        /** \brief ログイン処理をを開始する */
        protected override void StartPlugin()
        {
            // トップページを読み込む
            this.LoadLoginPage();
        }

        /** \brief ログインページを読み込む */
        private void LoadLoginPage()
        {
            this.Notice("ゲームチューのログインページを読み込んでいます。");
            this.Navigate("http://www.gamechu.jp/top/relogin", this.Login);
        }

        /** \brief ログイン処理 */
        private void Login()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("ゲームチューへログインしています。");

            // フォームを取得
            var forms = this.Document.All.GetElementsByName("fo_login");

            // input 要素のコレクションを取得
            var elements = forms[0].GetElementsByTagName("input").Cast<HtmlElement>();

            // 値をセット
            foreach (var element in elements)
            {
                if (element.Name == "accountid")
                {
                    element.SetAttribute("value", this.UserName);
                }
                else if (element.Name == "passwd")
                {
                    element.SetAttribute("value", this.Password);
                }
            }

            // ログイン後のページ (ワンタイムキーのページ) のアクションを追加
            this.AddAction(new Regex("^http://www.gamechu.jp/immortal/login/otkinfo"), this.EndLogin);

            // フォームを送信
            this.Document.InvokeScript("fo_finish", new object [] { false });
        }

        /** \brief ログイン処理を終了する */
        private void EndLogin()
        {
            this.EndPlugin("ゲームチューへのログインに成功しました。");
        }
    }
}
