﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;

namespace OGSNET.Plugins.GameYarou
{
    using OGSNET.Plugin;

    /** \brief ゲームヤロウゲームプラグイン ベースクラス */
    class GameYarouBase : GamePluginBase
    {
        /** \brief プラグインを開始する処理 */
        protected override void StartPlugin()
        {
            this.CallPlugin("GameYarou", this.LoadTopPage);
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice(this.GameInfo.GameName + "のトップページを読み込んでいます。");
            this.Navigate(this.GameStartUrl, this.GameStart);
        }

        /** \brief ゲームを起動する */
        private void GameStart()
        {
            // アクションをクリア
            this.ClearAction();

            // ゲームを開始
            this.Document.InvokeScript("eval", new object [] { "GameStartControl.StartExecuteGame()" });
            this.EndPlugin(this.GameInfo.GameName + "のクライアントを起動します。");
        }

        /** \brief ゲームを開始するURL */
        protected string GameStartUrl
        {
            get;
            set;
        }
    }

    /** \brief サドンアタックのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "GameYarou.SuddenAttack")]
    class SuddenAttack : GameYarouBase
    {
        /** \brief プラグインの初期化処理 */
        public SuddenAttack()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "サドンアタック (ゲームヤロウ) 起動プラグイン", "pine",
                    "サドンアタック (ゲームヤロウ) の起動プラグインです。");

            this.GameInfo =
                new GameInfo("ゲームヤロウ", "GameYarou", "サドンアタック", "http://suddenattack.gameyarou.jp/");

            this.GameStartUrl = "http://suddenattack.gameyarou.jp/index.asp";
        }
    }

    /** \brief デカロンのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "GameYarou.Dekaron")]
    class Dekaron : GameYarouBase
    {
        /** \brief プラグインの初期化処理 */
        public Dekaron()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "デカロン (ゲームヤロウ) 起動プラグイン", "pine",
                    "デカロン (ゲームヤロウ) の起動プラグインです。");

            this.GameInfo =
                new GameInfo("ゲームヤロウ", "GameYarou", "デカロン", "http://dekaron.gameyarou.jp/");

            this.GameStartUrl = "http://dekaron.gameyarou.jp/index.asp";
        }
    }

    /** \brief 三国志豪傑伝のプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "GameYarou.Sangokushi")]
    class Sangokushi : GameYarouBase
    {
        /** \brief プラグインの初期化処理 */
        public Sangokushi()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "三国志豪傑伝 (ゲームヤロウ) 起動プラグイン", "pine",
                    "三国志豪傑伝 (ゲームヤロウ) の起動プラグインです。");

            this.GameInfo =
                new GameInfo("ゲームヤロウ", "GameYarou", "三国志豪傑伝", "http://sangokushi-hero.gameyarou.jp/");

            this.GameStartUrl = "http://sangokushi-hero.gameyarou.jp/main/index.asp";
        }
    }

    /** \brief トランスピーのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "GameYarou.Transpee")]
    class Transpee : GameYarouBase
    {
        /** \brief プラグインの初期化処理 */
        public Transpee()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "トランスピー (ゲームヤロウ) 起動プラグイン", "pine",
                    "トランスピー (ゲームヤロウ) の起動プラグインです。");

            this.GameInfo =
                new GameInfo("ゲームヤロウ", "GameYarou", "トランスピー", "http://transpee.gameyarou.jp/");

            this.GameStartUrl = "http://transpee.gameyarou.jp/index.asp";
        }
    }

    /** \brief ノーステイルのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "GameYarou.Nostale")]
    class Nostale : GameYarouBase
    {
        /** \brief プラグインの初期化処理 */
        public Nostale()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ノーステイル (ゲームヤロウ) 起動プラグイン", "pine",
                    "ノーステイル (ゲームヤロウ) の起動プラグインです。");

            this.GameInfo =
                new GameInfo("ゲームヤロウ", "GameYarou", "ノーステイル", "http://nostale.gameyarou.jp/");

            this.GameStartUrl = "http://nostale.gameyarou.jp/";
        }
    }

    /** \brief 鉄鬼のプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "GameYarou.Tekki")]
    class Tekki : GameYarouBase
    {
        /** \brief プラグインの初期化処理 */
        public Tekki()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "鉄鬼 (ゲームヤロウ) 起動プラグイン", "pine",
                    "鉄鬼 (ゲームヤロウ) の起動プラグインです。");

            this.GameInfo =
                new GameInfo("ゲームヤロウ", "GameYarou", "鉄鬼", "http://tekki.gameyarou.jp/");

            this.GameStartUrl = "http://tekki.gameyarou.jp/";
        }
    }
}
