﻿using System;
using System.Windows.Forms;
using System.ComponentModel.Composition;

/** \brief ハンゲームのプラグイン */
namespace OGSNET.Plugins.Hangame
{
    using OGSNET.Plugin;

    /** \brief ハンゲームの運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "Hangame")]
    public class Operation : OperationPluginBase
    {
        /** \brief 基本情報の初期化 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ハンゲーム運営プラグイン", "pine",
                    "ハンゲームが運営しているゲームの開始に使用されます。");

            this.OperationInfo =
                new OperationInfo("ハンゲーム", "http://www.hangame.co.jp/");

        }

        /** \brief ログイン処理をを開始する */
        protected override void StartPlugin()
        {
            // トップページを読み込む
            this.LoadTopPage();
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.StartCallback(CallbackStatus.Notice, "ハンゲームのトップページを読み込みます。");
            this.Navigate(this.OperationInfo.Url, this.LoginOrLogout);
        }

        /** ログインフォームの存在をチェックし、ログインまたはログアウトする */
        private void LoginOrLogout()
        {
            this.RemoveAction(this.OperationInfo.Url);

            var document = this.Browser.Document;
            var form     = document.GetElementById("loginform"); // ログインフォームの取得

            // 既にログインしている場合、ログアウト処理を行う
            if (form == null)
            {
                this.StartCallback(CallbackStatus.Notice, "ハンゲームからログアウトしています。");
                this.Navigate(
                    "http://ctrad.hangame.co.jp/go?loc=clate.logout&ad=AD1138864266428",
                    this.EndLogout,
                    "http://top.hangame.co.jp/logout/index.nhn"
                );
            }
            
            // ログインしてない場合、ログイン処理を行う
            else
            {
                this.StartCallback(CallbackStatus.Notice, "ハンゲームにログインしています。");
                this.AddAction(this.OperationInfo.Url, this.EndLogin);
                this.AddAction("http://top.hangame.co.jp/login/loginfailed.nhn?type=lfc", this.Capture);

                document.GetElementById("strmemberid").SetAttribute("value", this.Account.UserName);
                document.GetElementById("strpassword").SetAttribute("value", this.Account.Password.Substring(0, 8));

                form.InvokeMember("submit");
            }
        }

        /** \brief ログイン処理を終了する */
        private void EndLogin()
        {
            var document = this.Browser.Document;
            var form     = document.GetElementById("loginform"); // ログインフォームの取得

            this.ClearAction();

            if (form == null)
            {
                this.StartCallback(CallbackStatus.Finish, "ログインに成功しました。");
            }
            else
            {
                this.StartCallback(CallbackStatus.Error, "ログインに失敗しました。");
            }
        }

        /** \brief ログアウト後の処理を行う */
        private void EndLogout()
        {
            this.StartCallback(CallbackStatus.Notice, "ハンゲームからログアウトしました。");
            this.LoadTopPage();
        }

        /** \brief 画像認証の処理 */
        private void Capture()
        {
            this.StartCallback(CallbackStatus.Error, "連続してログインに失敗したため、画像認証を要求されています。ブラウザから正常にログインできることを確かめた後、正しいユーザー名とパスワードでもう一度お試しください。");
        }
    }
}
