﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;

/** \brief JoyCity のプラグインの名前空間 */
namespace OGSNET.Plugins.JoyCity
{
    using OGSNET.Plugin;

    /* \brief JoyCity ゲームプラグイン ベースクラス */
    public class JoyCityBase : GamePluginBase
    {
        /** \brief プラグインを開始する */
        protected override void StartPlugin()
        {
            this.CallPlugin("JoyCity", this.GameStart);
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            this.Notice(this.GameInfo.GameName + "を起動しています。");
            this.Navigate(this.GameStartUrl, this.End);
        }

        /** \brief ゲーム起動成功 */
        private void End()
        {
            this.EndPlugin(this.GameInfo.GameName + "の起動に成功しました。");
        }

        /** \brief JoyCity ゲーム開始 URL */
        protected string GameStartUrl
        {
            set;
            get;
        }
    }

    /** \brief Another Day のゲームプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "JoyCity.AnotherDay")]
    public class AnotherDay : JoyCityBase
    {
        /** \brief プラグインの初期化処理 */
        public AnotherDay()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "Another Day (JoyCity) 起動プラグイン", "pine",
                    "Another Day (JoyCity) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("JoyCity", "JoyCity", "Another Day", "http://ad.joycity.jp/main.asp");

            this.GameStartUrl = "http://app.joycity.jp/gamestart/ad/run.asp";
        }
    }

    /** \brief Heroes in the Sky のゲームプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "JoyCity.HeroesInTheSky")]
    public class HeroesInTheSky : JoyCityBase
    {
        /** \brief プラグインの初期化処理 */
        public HeroesInTheSky()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "Heroes in the Sky (JoyCity) 起動プラグイン", "pine",
                    "Heroes in the Sky (JoyCity) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("JoyCity", "JoyCity", "Heroes in the Sky", "http://hs.joycity.jp/Default.aspx");

            this.GameStartUrl = "http://app.joycity.jp/gamestart/HS/run_hs.asp";
        }
    }

    /** \brief フリスタのゲームプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "JoyCity.FreeStyle")]
    public class FreeStyle : GamePluginBase
    {
        /** \brief プラグインの初期化処理 */
        public FreeStyle()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "フリスタ (JoyCity) 起動プラグイン", "pine",
                    "フリスタ (JoyCity) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("JoyCity", "JoyCity", "フリスタ", "http://fs.joycity.jp/main.asp");
        }

        /** \brief プラグインを開始する */
        protected override void StartPlugin()
        {
            this.CallPlugin("JoyCity", this.LoadTopPage);
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("トップページを読み込んでいます。");
            this.Navigate(this.GameInfo.Url, this.GameStart);
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            this.EndPlugin("ゲームを開始します。");
            this.Document.InvokeScript("gamestart");
        }
    }
}