﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;

/** \brief JoyCity のプラグインの名前空間 */
namespace OGSNET.Plugins.JoyCity
{
    using OGSNET.Plugin;

    /** \brief JoyCity の運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "JoyCity")]
    public class Operation : OperationPluginBase
    {
        /** \brief 基本情報の初期化 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "JoyCity 運営プラグイン", "pine",
                    "JoyCity (JC Global) が運営するゲームの起動に必要な起動プラグインです。");

            this.OperationInfo =
                new OperationInfo("JoyCity", "http://www.jcg.co.jp/");
        }

        /** \brief プラグインを開始する */
        protected override void StartPlugin()
        {
            // ログインページを表示する
            this.LoadLoginPage();
        }

        /** \brief ログインページを表示する */
        private void LoadLoginPage()
        {
            this.Notice("JoyCity ログインページへアクセスしています。");
            this.Navigate("https://secure.joycity.jp/hs/login/login.aspx", this.Login);
            this.AddAction("https://secure.joycity.jp/hs/login/didlogin.aspx", this.Login);
        }

        /** \brief ログインの処理 */
        private void Login()
        {
            // アクションをクリア
            this.ClearAction();

            // ログインの処理
            this.Notice("JoyCity にログインしています。");


            // ログインボタンを取得
            var loginButton = this.Document.GetElementById("imgbtnLogin");

            // ユーザーIDとパスワードの入力ボックスを取得
            var user = this.Document.GetElementById("txtUserID");
            var pass = this.Document.GetElementById("txtPassword");

            // 値を入力
            user.SetAttribute("value", this.UserName);
            pass.SetAttribute("value", this.Password);

            // 送信
            this.AddAction("https://secure.joycity.jp/hs/login/didlogin.aspx", this.EndLogin);
            this.AddAction("https://secure.joycity.jp/hs/login/login.aspx", this.BadAccount);
            loginButton.InvokeMember("click");
        }

        /** \brief ログアウトの処理 */
        private void Logout()
        {
            // アクションをクリア
            this.ClearAction();

            // ログアウトの処理
            this.Notice("JoyCity からログアウトしています。");

            // ログアウトボタンの取得
            var logoutButton = this.Document.GetElementById("ImgbtnLogout");

            // ログアウト
            this.AddAction("https://secure.joycity.jp/hs/login/login.aspx", this.EndLogout);
            logoutButton.InvokeMember("click");
        }

        /** \brief ログインに成功した場合の処理 */
        private void EndLogin()
        {
            this.ClearAction();
            this.EndPlugin("JoyCity へのログインに成功しました。");
        }

        /** \brief アカウント情報が違う */
        private void BadAccount()
        {
            this.Error("JoyCity のユーザー名もしくはパスワードが間違っています。");
        }

        /** \brief ログアウトに成功した場合の処理 */
        private void EndLogout()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("JoyCity からのログアウトに成功しました。");

            // ログイン処理
            this.Login();
        }
    }
}
