//
//  OMKConstants.h
//  OpenMetaKit
//
//  Created by s-take on 09/02/09.
//  
//  The MIT License
//  
//  Copyright (c) 2009 s-take.
//  
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//  
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//  
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.
//  

/*!
    @header
    @abstract   Header for OpenMetaKit constants
    @discussion Header for declaring constants, for OpenMeta.
*/
#import <Cocoa/Cocoa.h>


/*!
    @const 
    @abstract   User tags attribute name
    @discussion The name of OpenMeta user tags attribute.
*/
extern NSString *const OMKUserTagsAttributeName;

/*!
    @const 
    @abstract   User rating attribute name
    @discussion The name of OpenMeta user rating attribute.
*/
extern NSString *const OMKUserRatingAttributeName;

/*!
    @const 
    @abstract   User-tagged date/time attribute name
    @discussion The name of OpenMeta user-tagged date/time attribute.
*/
extern NSString *const OMKUserTaggedDateAttributeName;
