<?php
/*
OneSQLiteAdmin

Copyright (c) 2010 Mitsugi Tsutsumi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
$config["version"]="0.4";

//config - Auth
$config["user"]="admin";
$config["password"]="pass";

//config - db file
$config["db"][]="db_admin.db";
$config["db"][]="test/test.db";


//リセットスタイル
if(@$_GET["s"]=="resetcss"){
	header('Content-type: text/css; charset=utf-8');
	echo <<<EOF
/*Eric Meyer Reset CSS*/
html, body, div, span, applet, object, iframe, table, caption,
tbody, tfoot, thead, tr, th, td, del, dfn, em, font, img, ins,
kbd, q, s, samp, small, strike, strong, sub, sup, tt, var,
h1, h2, h3, h4, h5, h6, p, blockquote, pre, a, abbr,
acronym, address, big, cite, code, dl, dt, dd, ol, ul, li,
fieldset, form, label, legend{
	vertical-align:baseline;
	font-family:inherit;
	font-weight:inherit;
	font-style:inherit;
	font-size:100%;
	outline:0;
	padding:0;
	margin:0;
	border:0;
}
:focus{
	outline:0;
}
body{
	background:white;
	line-height:1;
	color:black;
}
ol, ul{
	list-style:none;
}
table{
	border-collapse:separate;
	border-spacing:0;
}
caption, th, td{
	font-weight:normal;
	text-align:left;
}
blockquote:bfore, blockquote:after, q:before, q:after{
	content: "";
}
blockquote, q{
	quotes:"" "";
}
EOF;
	exit;

//CSS
}else if(@$_GET["s"]=="css"){
	$me = $_SERVER["SCRIPT_NAME"];
	header('Content-type: text/css; charset=utf-8');
	echo <<<EOF
/* OneSQLiteAdmin */
ul.dbs li.db {
	list-style:none;
	background: url(${me}?s=img_db) no-repeat;
	background-position: 2px 3px;
	padding-left:15px
}
.tbl-non{display:none;}
.tbl{
	list-style:none;
	background: url(${me}?s=img_tbl) no-repeat;
	background-position: 0px 2px;
	padding-left:17px
}

table{
	border-top:1px solid #4d4d4d;
	border-left:1px solid #4d4d4d;
	border-collapse:collapse;
	border-spacing:0;
	background-color:#ffffff;
	empty-cells:show;
}
th{
	padding:1px;
	border-right:1px solid #4d4d4d;
	border-bottom:1px solid #4d4d4d;
	color:#000000;
	background-color:#cccccc;
	background-position:left top;
	text-align:center;
}
td{
	padding:1px;
	border-right:1px solid #4d4d4d;
	border-bottom:1px solid #4d4d4d;
	white-space: nowrap
}

fieldset {
	border: 1px #bde9ba solid;
	border-top: 13px #bde9ba solid;
	padding:1px
}


legend {
	margin: 0 0 0 20px;
	padding: 5px 10px;
	color: #000000;
	border: 1px #bde9ba solid;
}


div.mn {
	padding-bottom:1px;
	border-bottom: 1px #000000 solid;
}
a.mn:link {
	color: #000000;
	padding-left:3px;
	padding-right:3px;
	border-left: 1px #FFFFFF solid;
	border-right: 1px #FFFFFF solid;
	background-color: #FFFFFF;
	text-decoration: none;
}
a.mn:visited {
	color: #000000;
	padding-left:3px;
	padding-right:3px;
	border-left: 1px #FFFFFF solid;
	border-right: 1px #FFFFFF solid;
	background-color: #FFFFFF;
	text-decoration: none;
}
a.mn:hover {
	color: #000000;
	padding-left:3px;
	padding-right:3px;
	border-top: 1px #e5ffe5 solid;
	border-left: 1px #bde9ba solid;
	border-right: 1px #bde9ba solid;
	background-color: #e5ffe5;
	text-decoration: none;
}

* {margin:0; padding:0;}
body {overflow:hidden; margin:0; padding:0; font-size:100%;}
#mainbox {margin-left:200px; height:100%; overflow:auto; padding:0;}
#mainhead {width:100%;margin:0;padding:0;background-color: #fff; position: fixed; top: 0px; left:200px;}
#mainin { margin:0; padding-top:20px;}
#leftbox {position:absolute; left:0; top:0; width:200px; height:100%; margin:0; padding:0;overflow:auto;border-right:1px solid #000;}
#lefthead {width:200px;margin:0;padding:0;border-bottom:1px solid #fc3;background-color: #bde9ba; position: fixed; top: 0px; left:0px;}
#leftnavi {margin-top:15px;width:100%;padding:0;}

EOF;
	exit;

}else if(@$_GET["s"]=="iecss"){
	header('Content-type: text/css; charset=utf-8');
	echo <<<EOF
html,body {
 overflow-y: hidden;
 height: 100%;
}

#mainbox {margin-left:200px; height:100%;overflow:hidden;padding:0; border-left:1px solid #000;}
#mainhead {width:100%;margin:0;padding:0; position:background-color: #fff;  absolute; top: 0px; left:0px;}
#mainin {margin:0;padding:0;width:100%;height:93%;overflow:auto;}
#leftbox {position:absolute; left:0; top:0; width:200px; height:100%; margin:0; padding:0;overflow:hidden;border-right:0px;}
#lefthead {width:200px;margin:0px;padding:0;border-bottom:1px solid #fc3;border-right:0px;background-color: #bde9ba; position: absolute; top: 0px; left:0px;}
#leftnavi {margin:0;width:100%;height:100%;padding-top:15px;overflow:auto;}
EOF;
	exit(0);


//js
}else if(@$_GET["s"]=="js"){
	header('Content-type: text/javascript; charset=utf-8');
	echo <<<EOF
/* OneSQLiteAdminjs */
EOF;
	exit;

//jkl-parsexml.js
}else if(@$_GET["s"]=="jkl-parsexmlJs"){
	header('Expires: ' . gmdate('D, d M Y H:i:s', time()+24*60*60*365) . ' GMT');
	header('Content-type: text/javascript; charset=utf-8');
	print(getjkl_parsexml_js());
	exit;

}else if(@$_GET["s"]=="img_db"){
	header('Expires: ' . gmdate('D, d M Y H:i:s', time()+24*60*60*365) . ' GMT');
	header("Content-type: image/png");
	echo base64_decode("iVBORw0KGgoAAAANSUhEUgAAAAsAAAALAQMAAACTYuVlAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAAAZQTFRFAAAA////pdmf3QAAABh0RVh0U29mdHdhcmUAUGFpbnQuTkVUIFYzLjM2aCbNIQAAACRJREFUCNdjOJDAsH8Bg4MDQ/0BBp8DDKEODCFgEsgGijQoAAC0HAp0htmWJwAAAABJRU5ErkJggg==");
	exit(0);

}else if(@$_GET["s"]=="img_tbl"){
	header('Expires: ' . gmdate('D, d M Y H:i:s', time()+24*60*60*365) . ' GMT');
	header("Content-type: image/png");
	echo base64_decode("iVBORw0KGgoAAAANSUhEUgAAABAAAAAOAQMAAAAc4Q7JAAAABlBMVEX///8AAABVwtN+AAAAE0lEQVQImWP4/58BiFoUoQg3GwBfJw/EGicjrwAAAABJRU5ErkJggg==");
	exit(0);
}


//認証
session_start();
if (isset($_POST["onedbadmin_username"])) { $_SESSION['onedbadmin_username'] = $_POST["onedbadmin_username"]; }
if (isset($_POST["onedbadmin_password"])) { $_SESSION['onedbadmin_password'] = $_POST["onedbadmin_password"]; }
if ((@$_POST['onedbadmin_username'] == $config["user"]) and (@$_POST['onedbadmin_password'] == $config["password"])) {
	header("Location: ".$_SERVER["SCRIPT_NAME"]);
}
if ((@$_SESSION['onedbadmin_username'] == $config["user"]) and (@$_SESSION['onedbadmin_password'] == $config["password"])) {
	$_SESSION['onedbadmin_valid'] = "1";
} else {
	$_SESSION['onedbadmin_valid'] = "0";
	if ($_GET["s"] !== "login") { header("Location: ".$_SERVER["SCRIPT_NAME"]."?s=login"); }
}

//ログイン
if(@$_GET["s"] == "login"){
	echo buildHtml(getLoginP(),"login");
	exit(0);

//ログアウト
}else if(@$_GET["s"] == "logout") {
	@$_SESSION['onedbadmin_valid'] = "0"; session_destroy();
	echo buildHtml(getLogoutP(),"logout");
	exit(0);


//初期ロード
}else if(!isset($_GET["s"])){
	$me = $_SERVER["SCRIPT_NAME"];

	$head = <<<EOF
window.onload = function (){
	view.dblist("dblist");
}

view = {};

view.dblist = function(div_id){
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=dblist");
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

view.option = function(div_id){
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=option");
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

view.dboption = function(div_id,dbid){
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=dboption&dbid="+dbid);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

view.tbllist = function(div_id,dbid){

	//menu
	var menu_obj;
	var db_count = document.getElementById('db_count').value;
	var httpObj = new JKL.ParseXML.Text("${me}?s=tbllist&dbid="+dbid);
	var data = httpObj.parse();

	for(i=0;i<db_count;i++){
		menu_obj = document.getElementById('db_'+i);
		menue_item = menu_obj.childNodes;
		for(j = 0; j < menue_item.length; j++){
			if(menue_item.item(j).tagName=="UL"){
				menu_obj.removeChild(menue_item.item(j))
			}
		}
	}

	if(data.length>0){
		menu_obj = document.getElementById('db_'+dbid);
		ulobj =  document.createElement('ul');
		ulobj.innerHTML = data;
		menu_obj.appendChild(ulobj);
	}

	//main
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=db&dbid="+dbid);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML=data;
	}

	//dbstructure
	var divObj = document.getElementById("db");
	var httpObj = new JKL.ParseXML.Text("${me}?s=dbstructure&dbid="+dbid);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML=data;
	}

	return false;
}

view.dbstructure = function(div_id,dbid){
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=dbstructure&dbid="+dbid);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

view.tbl = function(div_id,dbid,tblname){
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=tbl&dbid="+dbid+"&tblname="+tblname);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	view.tblstructure("tbl",dbid,tblname);
	return false;
}

view.tblstructure = function(div_id,dbid,tblname){
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=tblstructure&dbid="+dbid+"&tblname="+tblname);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

view.tbldata = function(div_id,dbid,tblname,page){
	var divObj = document.getElementById(div_id);
	if(document.getElementById("viewlimit")){
		var viewlimit = document.getElementById("viewlimit").value;
	}else{
		var viewlimit = 5;
	}
	var httpObj = new JKL.ParseXML.Text("${me}?s=tbldata&dbid="+dbid+"&tblname="+tblname+"&i="+page+"&l="+viewlimit);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

view.sql = function(div_id,dbid,tblname,page){
	var divObj = document.getElementById(div_id);
	var httpObj = new JKL.ParseXML.Text("${me}?s=sql&dbid="+dbid+"&tblname="+tblname+"&div_id="+div_id);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

exec = function(div_id,dbid,div_sql){
	var divObj = document.getElementById(div_id);
	var sql = document.getElementById(div_sql).value;
	var httpObj = new JKL.ParseXML.Text("${me}?s=sqlexec&dbid="+dbid+"&div_id="+div_id , "sql="+sql);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}

execpage = function(div_id,dbid,div_sql,page){
	var divObj = document.getElementById(div_id);
	var sql = document.getElementById(div_sql).value;
	var viewlimit = document.getElementById("viewlimit").value;
	var httpObj = new JKL.ParseXML.Text("${me}?s=sqlexec&dbid="+dbid+"&l="+viewlimit+"&i="+page+"&div_id="+div_id ,"sql="+sql);
	var data = httpObj.parse();
	if(data.length>0){
		divObj.innerHTML = data;
	}
	return false;
}


EOF;

	$head = scriptTag($head);
	$body = <<<EOF
<div id="mainbox">
	<div id="mainhead">
		<div class="mn">
			<a href="${me}" class="mn" >TOP</a>
			<a href="${me}?s=logout" class="mn" >logout</a>
			<a href="#" onclick='return view.option("mainin")' class="mn" >option</a>
		</div>
	</div>

	<div id="mainin">
	</div>
</div>
<div id="leftbox">
	<div id="lefthead"><h1>OneSQLiteAdmin</h1></div>
	<div id="leftnavi">
		<div id="dblist"></div>
	</div>
</div>
EOF;

	echo buildHtml($body,"top",$head);
	exit(0);



}else if($_GET["s"] == "option"){
	$me = $_SERVER["SCRIPT_NAME"];
	$PHPversion = phpversion();
	$SQLiteVersions = "non";
	$OneSQLiteAdminVersion = $config["version"];

	//PDOが存在かつsqliteのドライバがある場合
	if(class_exists('PDO') && in_array('sqlite', PDO::getavailabledrivers())) {
		//メモリ内にデータベースを作成し、SQLiteのバージョンを取得
		$memoryDB = new PDO('sqlite::memory:', '', '');
		$query = "SELECT sqlite_version();";
		$result = $memoryDB->query($query);
		$SQLiteVersion = $result->fetchColumn();
		unset($memoryDB, $result,$query);
	}

	$body = <<<EOF
<div>PHP version {$PHPversion}</div>
<div>SQLite version {$SQLiteVersion}</div>
<div>OneSQLiteAdmin Version {$OneSQLiteAdminVersion}</div>
EOF;
	echo $body;
	exit;

}else if(@$_GET["s"]=="dblist"){
		$dbdata = $config["db"];
		$db_count = 0;

		$body="";
		$body .= '<ul class="dbs">';
		foreach($dbdata as $key => $value){
			$db = basename($value);
			$body .= '<li class="db" id="db_'.$key.'"><a href="#" onclick="return view.tbllist(\'mainin\','.$key.')">'.$db.'</a></li>';
			$db_count++;
		}
		$body .= '</ul>';
		$body .= '<input type="hidden" id="db_count" value="'.$db_count.'">';
		echo $body;
		exit;

}else if(@$_GET["s"]=="db"){
		$dbid = @$_GET["dbid"];
		$body = "";
		$body .= <<<EOF
<div class="mn">
	<a href="#" class="mn" onclick='return view.dbstructure("db",{$dbid})'>Structure</a>
	<a href="#" class="mn" onclick='return view.dboption("db",{$dbid})' >Options</a>
	<a href="#" class="mn" onclick='return view.sql("db",{$dbid});'>SQL</a>
	<a href="#" class="mn">Export</a>
	<a href="#" class="mn">Delete</a>
</div>
<div id="db">
</div>
EOF;

		echo $body;
		exit;

}else if(@$_GET["s"]=="dbstructure"){
		$dbid = @$_GET["dbid"];
		$tbl_dbh = new PDO('sqlite:'.$config["db"][$dbid],'', '');
		$table_names = $tbl_dbh->prepare("select name from sqlite_master where type='table' order by name");
		$table_names->execute();
		$table_names = $table_names->fetchAll(PDO::FETCH_ASSOC);
		$body = "";
		$body .= <<<EOF
	<fieldset>
		<legend>Table</legend>
EOF;
		$body .= '<ul class="tbls">';
		foreach($table_names as $value){
			$body .= '<li class="tbl"><a href="#" onclick="return view.tbl(\'mainin\','.$dbid.',\''.$value["name"].'\');">'.$value["name"].'</a></li>';
		}
		$body .= '</ul>';
		$body .= <<<EOF
	</fieldset>
EOF;
		echo $body;
		exit;
}else if(@$_GET["s"]=="tbllist"){
		$dbid = @$_GET["dbid"];
		$tbl_dbh = new PDO('sqlite:'.$config["db"][$dbid],'', '');
		$table_names = $tbl_dbh->prepare("select name from sqlite_master where type='table' order by name");
		$table_names->execute();
		$table_names = $table_names->fetchAll(PDO::FETCH_ASSOC);

		$body = "";
		foreach($table_names as $value){
			$body .= '<li class="tbl"><a href="#" onclick="return view.tbl(\'mainin\','.$dbid.',\''.$value["name"].'\');">'.$value["name"].'</a></li>';
		}
		echo $body;
		exit;

}else if(@$_GET["s"]=="dboption"){
	$dbid = @$_GET["dbid"];
	$db_path = dirname(__FILE__)."/".$config["db"][$dbid];
	$db_name = basename($db_path);
	$db_size = formatBytes(filesize($db_path));
	$db_rights = formatperms(fileperms($db_path));
	$body = <<<EOF
<fieldset>
	<legend>Information</legend>
	<div>
		<table>
			<tr>
				<th>database</th>
				<td>{$db_name}</td>
			</tr>
			<tr>
				<th>Location</th>
				<td>{$db_path}</td>
			</tr>
			<tr>
				<th>size</th>
				<td>{$db_size}</td>
			</tr>
			<tr>
				<th>rights</th>
				<td>{$db_rights}</td>
			</tr>
		</table>
	</div>
</fieldset>
EOF;
	echo $body;
	exit;

}else if(@$_GET["s"]=="tbl"){
		$body="";
		$dbid = @$_GET["dbid"];
		$tblname = $_GET["tblname"];
		$body .= <<<EOF
<div class="mn">
	<a href="#" class="mn" onclick='return view.tblstructure("tbl",{$dbid},"{$tblname}");'>Structure</a>
	<a href="#" class="mn" onclick='return view.tbldata("tbl",{$dbid},"{$tblname}",1);'>Display</a>
	<a href="#" class="mn" onclick='return view.sql("tbl",{$dbid},"{$tblname}");'>SQL</a>
	<a href="#" class="mn">Select</a>
	<a href="#" class="mn">Insert</a>
	<a href="#" class="mn">Operation</a>
	<a href="#" class="mn">Export</a>
	<a href="#" class="mn">Empty</a>
	<a href="#" class="mn">Delete</a>
</div>
<div id="tbl"></div>
EOF;
		echo $body;
		exit;



}else	if(@$_GET["s"]=="tblstructure"){
		$tblname = $_GET["tblname"];
		$tbl_dbh = new PDO('sqlite:'.$config["db"][$_GET["dbid"]],'', '');
		$table_infoes = $tbl_dbh->prepare("PRAGMA table_info('".$tblname."');");
		$table_infoes->execute();
		$table_infoes = $table_infoes->fetchAll(PDO::FETCH_ASSOC);
		$body = "";
		$body .= <<<EOF
<fieldset>
	<legend>Structure</legend>
<table>
<tr>
EOF;
		foreach($table_infoes[0] as $table_info_c=>$table_info_v){
			$body .= '<th>';
			$body .= $table_info_c;
			$body .= '</th>';
		}
		$body .= '</tr>';
		foreach($table_infoes as $table_info){
			$body .= '<tr>';
			foreach($table_info as $table_info_i){
				$body .= '<td>';
				$body .= $table_info_i;
				$body .= '</td>';
			}
			$body .= '</tr>';
		}
		$body .= '</table>';

		$body .= '</fieldset>';
		echo $body;
		exit;




}else if(@$_GET["s"]=="tbldata"){
		$tblname = $_GET["tblname"];
		$dbid = $_GET["dbid"];
		$tbl_dbh = new PDO('sqlite:'.$config["db"][$dbid],'', '');

		//件数取得
		$tbl_count = $tbl_dbh->prepare("SELECT count(*) as c FROM ".$tblname);
		$tbl_count->execute();
		$tbl_count = $tbl_count->fetchAll();
		$rows_count = $tbl_count[0]["c"];

		$body = "";
		$body .= "<fieldset><legend>Data</legend>";
		if($rows_count>0){
			//現在のページ設定
			if(isset($_GET["i"])){$p = $_GET["i"];
			}else{$p = 1;}

			//1ページに表示するリミット設定(オプション)
			if(isset($_GET["l"])){$limit = $_GET["l"];}
			if(empty($limit)){$limit = 5;
			}else{$limit = intval($limit);}

			//ソート関連
			if(isset($_GET["sort"])){$sort = " ORDER BY ".$_GET["sort"]." ".$_GET["jun"];
			}else{$sort = "";}

			//現在のページ
			$p = (ceil($rows_count / $limit) < $p)?ceil($rows_count / $limit):$p;
			$offset = ($p-1)*$limit;

			$table_infoes = $tbl_dbh->prepare("SELECT * FROM ".$tblname." {$sort} LIMIT {$offset} , {$limit} ");
			$table_infoes->execute();
			$table_infoes = $table_infoes->fetchAll(PDO::FETCH_ASSOC);


			$body .= getTableView($table_infoes,$limit,0,$dbid,$tblname);
			$body .= page_pager($dbid,$tblname,$p,$rows_count,$limit);


		}else{
			$table_infoes = $tbl_dbh->prepare("PRAGMA table_info('".$tblname."');");
			$table_infoes->execute();
			$table_infoes = $table_infoes->fetchAll(PDO::FETCH_ASSOC);
			$tbl = array();
			$tbl[0] = array();
			foreach($table_infoes as $table_info){
				$tbl[0][$table_info["name"]]="";
			}
			$body .= getTableView($tbl,0,0);
		}

		$body .= "</fieldset>";
		echo $body;
		exit;


}else if(@$_GET["s"]=="sql"){
		$dbid = $_GET["dbid"];
		$div_id = $_GET["div_id"];
		$body = <<<EOF
<fieldset>
	<legend>SQL</legend>
	<form action="#">
		<textarea name="sql" id="sql" rows="4" cols="40"></textarea><br />
		<input type="button" value="EXEC" onclick='exec("{$div_id}",${dbid},"sql");'/>
	</form>
</fieldset>
EOF;
		echo $body;
		exit;


}else if(@$_GET["s"]=="sqlexec"){

		$dbid = $_GET["dbid"];
		$div_id = $_GET["div_id"];
		$sql = @$_POST["sql"];

		$body ="";
		$err_msg = "";
		$hidden_sql = "";
		$TableView = "";

	try {
		$tbl_dbh = new PDO('sqlite:'.$config["db"][$_GET["dbid"]],'', '');
		$tbl_dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

		if(preg_match('/^select/i',ltrim($sql))){
			$count_sql = preg_replace('/LIMIT *[0-9].*/i','',$sql);

			$count_sql = 'select count(*) as c from '.preg_replace('/^select.*from/i','',ltrim($count_sql));
			$table_infoes = $tbl_dbh->query($count_sql);
			$table_infoes = $table_infoes->fetchAll(PDO::FETCH_ASSOC);
			$rows_count = $table_infoes[0]["c"];

			if($rows_count>0){
				//現在のページ設定
				if(isset($_GET["i"])){$p = $_GET["i"];
				}else{$p = 1;}

				//1ページに表示するリミット設定(オプション)
				if(isset($_GET["l"])){$limit = $_GET["l"];}
				if(empty($limit)){$limit = 5;
				}else{$limit = intval($limit);}

				//現在のページ
				$p = (ceil($rows_count / $limit) < $p)?ceil($rows_count / $limit):$p;
				$offset = ($p-1)*$limit;

				$sql = preg_replace('/;$/',"",rtrim($sql));
				if(!preg_match('/LIMIT *[0-9]/i',$sql)){
					$sql = $sql." LIMIT {$offset} , {$limit} ";
				}

				$table_infoes = $tbl_dbh->query($sql);
				$table_infoes = $table_infoes->fetchAll(PDO::FETCH_ASSOC);

				$hidden_sql = preg_replace('/LIMIT *[0-9].*/i','',$sql);
				$hidden_sql = '<input type="hidden" name="hidden_sql" id="hidden_sql" value="'.$hidden_sql.'" />';
				$TableView = getTableView($table_infoes,$limit,1,$dbid,$div_id);
				$TableView .= exec_page_pager($dbid,$p,$rows_count,$limit);
			}
		}else{
			$table_infoes = $tbl_dbh->exec($sql);
		}

		$tbl_dbh = null;
	} catch (PDOException $e) {
		$err_msg = $e->getMessage();
		$body .= "<div style='border:1px solid red;color:red;'>{$err_msg}</div>";
		$tbl_dbh = null;
	}

	$body .= <<<EOF
<fieldset>
	<legend>SQL</legend>
	<div style="border:1px solid gray;">{$sql}</div>
EOF;
		if(!empty($TableView)){
			$body .= $TableView.$hidden_sql;
		}else{
			$body .= <<<EOF
	<form action="#">
		<textarea name="sql" id="sql" rows="4" cols="40">{$sql}</textarea><br />
		<input type="button" value="EXEC" onclick='exec("{$div_id}",${dbid},"sql");'/>
	</form>
EOF;
		}
		$body .= "</fieldset>";
		echo $body;
		exit;
}



function getTableView($table_infoes,$viewlimit=5,$shori=0,$dbid=0,$tblname=""){
		if(empty($table_infoes)){
			return "";
		}
		$body = "";

		if($shori==0){
			$body .= '表示件数：<select name="viewlimit" id="viewlimit" onChange=\'return view.tbldata("tbl",'.$dbid.',"'.$tblname.'");\'>';
		}else{
			$body .= '表示件数：<select name="viewlimit" id="viewlimit" onChange=\'return execpage("'.$tblname.'",'.$dbid.',"hidden_sql",1);\'>';
		}
		if($viewlimit==5){
			$body .= '<option value="5" selected >5</option>';
		}else{
			$body .= '<option value="5">5</option>';
		}
		if($viewlimit==10){
			$body .= '<option value="10" selected >10</option>';
		}else{
			$body .= '<option value="10">10</option>';
		}
		if($viewlimit==15){
			$body .= '<option value="15" selected >15</option>';
		}else{
			$body .= '<option value="15">15</option>';
		}
		if($viewlimit==20){
			$body .= '<option value="20" selected >20</option>';
		}else{
			$body .= '<option value="20">20</option>';
		}
		$body .= '</select>';


		$body .= <<<EOF
<table>
	<tr>
EOF;
		if($shori==0){
			$body .= '<th>編集</th>';
		}
		foreach($table_infoes[0] as $table_info_c=>$table_info_v){
			$body .= '<th>';
			$body .= $table_info_c;
			$body .= '</th>';
		}
		$body .= '</tr>';
		foreach($table_infoes as $table_info){
			$body .= '<tr>';
			if($shori==0){
				$body .= '<td></td>';
			}
			foreach($table_info as $table_info_i){
				$body .= '<td>';
				$body .= $table_info_i;
				$body .= '</td>';
			}
			$body .= '</tr>';
		}
		$body .= '</table>';
	return $body;
}

function page_pager($dbid,$tblname,$current_num,$countRe,$per_page=6){
	// 現在のページ情報を取得
	$VIEW_PAGE_MENU_WIDTH = 2;
	$PREV_MARK = "&lt;";
	$NEXT_MARK = "&gt;";
	$startMore="";
	$endMore="";
	$startPage=1;
	$endPage=0;

	$now_page =intval($current_num);
	$now_page =(empty($now_page))?1:$now_page;
	$now_page =(ceil($countRe / $per_page) < $now_page)?ceil($countRe / $per_page):$now_page;

	if($now_page=="") $now_page=1;
	$maxPage=ceil($countRe / $per_page);
	if( ($maxPage == 1) or ($maxPage < $now_page) ) return false;
	if($now_page > 1){
		$startMore .= "<a href=\"#\" onclick='return view.tbldata(\"tbl\",${dbid},\"{$tblname}\"".($now_page - 1).");'>".$PREV_MARK."</a>";
		if($now_page > $VIEW_PAGE_MENU_WIDTH + 1){
			$startPage = $now_page - $VIEW_PAGE_MENU_WIDTH;
			$startMore .= "<a href=\"#\" onclick='return view.tbldata(\"tbl\",${dbid},\"{$tblname}\",".($now_page - 1).");'><span style=\"font-size:small;\">1</span></a><span style=\"font-size:xx-small;\">...</span>";
		}
	}else{
		$startPage = 1;
	}
	if($now_page < $maxPage){
		if($now_page + $VIEW_PAGE_MENU_WIDTH < $maxPage){
			$endPage = $now_page + $VIEW_PAGE_MENU_WIDTH;
			$endMore .= "<span style=\"font-size:xx-small;\">...</span><a href=\"#\" onclick='return view.tbldata(\"tbl\",${dbid},\"{$tblname}\",".$maxPage.");'><span style=\"font-size:small;\">".$maxPage."</span></a>\n";
		}else{
			$endPage = $maxPage;
		}
		$endMore .= "<a href=\"#\" onclick='return view.tbldata(\"tbl\",${dbid},\"{$tblname}\",".($now_page + 1).");'>".$NEXT_MARK."</a>\n";
	}else{
		$endPage = $maxPage;
	}
	$page_footer="";
	for($i = $startPage ; $i <= $endPage ; $i++){
		$page_footer.= " ".(($now_page==$i)?"<span style=\"font-size:small;\">$i</span>\n":"<span style=\"font-size:small;\"><a href=\"#\" onclick='return view.tbldata(\"tbl\",${dbid},\"{$tblname}\",".$i.");'>$i</a></span>\n");
	}
	$page_footer = $startMore.$page_footer.$endMore;
	return $page_footer;
}

function exec_page_pager($dbid,$current_num,$countRe,$per_page=6){
	// 現在のページ情報を取得
	$VIEW_PAGE_MENU_WIDTH = 2;
	$PREV_MARK = "&lt;";
	$NEXT_MARK = "&gt;";
	$startMore="";
	$endMore="";
	$startPage=1;
	$endPage=0;

	$now_page =intval($current_num);
	$now_page =(empty($now_page))?1:$now_page;
	$now_page =(ceil($countRe / $per_page) < $now_page)?ceil($countRe / $per_page):$now_page;

	if($now_page=="") $now_page=1;
	$maxPage=ceil($countRe / $per_page);
	if( ($maxPage == 1) or ($maxPage < $now_page) ) return false;
	if($now_page > 1){
		$startMore .= "<a href=\"#\" onclick='return execpage(\"tbl\",${dbid},\"hidden_sql\",".($now_page - 1).");'>".$PREV_MARK."</a>";
		if($now_page > $VIEW_PAGE_MENU_WIDTH + 1){
			$startPage = $now_page - $VIEW_PAGE_MENU_WIDTH;
			$startMore .= "<a href=\"#\" onclick='return execpage(\"tbl\",${dbid},\"hidden_sql\",".($now_page - 1).");'><span style=\"font-size:small;\">1</span></a><span style=\"font-size:xx-small;\">...</span>";
		}
	}else{
		$startPage = 1;
	}
	if($now_page < $maxPage){
		if($now_page + $VIEW_PAGE_MENU_WIDTH < $maxPage){
			$endPage = $now_page + $VIEW_PAGE_MENU_WIDTH;
			$endMore .= "<span style=\"font-size:xx-small;\">...</span><a href=\"#\" onclick='return execpage(\"tbl\",${dbid},\"hidden_sql\",".$maxPage.");'><span style=\"font-size:small;\">".$maxPage."</span></a>\n";
		}else{
			$endPage = $maxPage;
		}
		$endMore .= "<a href=\"#\" onclick='return execpage(\"tbl\",${dbid},\"hidden_sql\",".($now_page + 1).");'>".$NEXT_MARK."</a>\n";
	}else{
		$endPage = $maxPage;
	}
	$page_footer="";
	for($i = $startPage ; $i <= $endPage ; $i++){
		$page_footer.= " ".(($now_page==$i)?"<span style=\"font-size:small;\">$i</span>\n":"<span style=\"font-size:small;\"><a href=\"#\" onclick='return execpage(\"tbl\",${dbid},\"hidden_sql\",".$i.");'>$i</a></span>\n");
	}
	$page_footer = $startMore.$page_footer.$endMore;
	return $page_footer;
}

function getLogoutP(){
	$me = $_SERVER["SCRIPT_NAME"];
	return <<<EOF
	<h2>ログアウト</h2>
	<p>Logout...</p>
	<p><a href="${me}">Top</a></p>
EOF;
}

function getjkl_parsexml_js(){
	return <<<EOF
// ================================================================
//  jkl-parsexml.js ---- JavaScript Kantan Library for Parsing XML
//  Copyright 2005-2007 Kawasaki Yusuke <u-suke@kawa.net>
//  http://www.kawa.net/works/js/jkl/parsexml.html
// ================================================================
//  v0.01  2005/05/18  first release
//  v0.02  2005/05/20  Opera 8.0beta may be abailable but somtimes crashed
//  v0.03  2005/05/20  overrideMimeType( "text/xml" );
//  v0.04  2005/05/21  class variables: REQUEST_TYPE, RESPONSE_TYPE
//  v0.05  2005/05/22  use Msxml2.DOMDocument.5.0 for GET method on IE6
//  v0.06  2005/05/22  CDATA_SECTION_NODE
//  v0.07  2005/05/23  use Microsoft.XMLDOM for GET method on IE6
//  v0.10  2005/10/11  new function: JKL.ParseXML.HTTP.responseText()
//  v0.11  2005/10/13  new sub class: JKL.ParseXML.Text, JSON and DOM.
//  v0.12  2005/10/14  new sub class: JKL.ParseXML.CSV and CSVmap.
//  v0.13  2005/10/28  bug fixed: TEXT_NODE regexp for white spaces
//  v0.14  2005/11/06  bug fixed: TEXT_NODE regexp at Safari
//  v0.15  2005/11/08  bug fixed: JKL.ParseXML.CSV.async() method
//  v0.16  2005/11/15  new sub class: LoadVars, and UTF-8 text on Safari
//  v0.18  2005/11/16  improve: UTF-8 text file on Safari
//  v0.19  2006/02/03  use XMLHTTPRequest instead of ActiveX on IE7,iCab
//  v0.20  2006/03/22  (skipped)
//  v0.21  2006/11/30  use ActiveX again on IE7
//  v0.22  2007/01/04  JKL.ParseXML.JSON.parseResponse() updated
// ================================================================

if ( typeof(JKL) == 'undefined' ) JKL = function() {};

// ================================================================
//  class: JKL.ParseXML 

JKL.ParseXML = function ( url, query, method ) {
    // debug.print( "new JKL.ParseXML( '"+url+"', '"+query+"', '"+method+"' );" );
    this.http = new JKL.ParseXML.HTTP( url, query, method, false );
    return this;
};

// ================================================================
//  class variables

JKL.ParseXML.VERSION = "0.22";
JKL.ParseXML.MIME_TYPE_XML  = "text/xml";
JKL.ParseXML.MAP_NODETYPE = [
    "",
    "ELEMENT_NODE",                 // 1
    "ATTRIBUTE_NODE",               // 2
    "TEXT_NODE",                    // 3
    "CDATA_SECTION_NODE",           // 4
    "ENTITY_REFERENCE_NODE",        // 5
    "ENTITY_NODE",                  // 6
    "PROCESSING_INSTRUCTION_NODE",  // 7
    "COMMENT_NODE",                 // 8
    "DOCUMENT_NODE",                // 9
    "DOCUMENT_TYPE_NODE",           // 10
    "DOCUMENT_FRAGMENT_NODE",       // 11
    "NOTATION_NODE"                 // 12
];

// ================================================================
//  define callback function (ajax)

JKL.ParseXML.prototype.async = function ( func, args ) {
    this.callback_func = func;      // callback function
    this.callback_arg  = args;      // first argument
};

JKL.ParseXML.prototype.onerror = function ( func, args ) {
    this.onerror_func = func;       // callback function
};

// ================================================================
//  method: parse()
//  return: parsed object
//  Download a file from remote server and parse it.

JKL.ParseXML.prototype.parse = function () {
    if ( ! this.http ) return;

    // set onerror call back 
    if ( this.onerror_func ) {
        this.http.onerror( this.onerror_func );
    }

    if ( this.callback_func ) {                             // async mode
        var copy = this;
        var proc = function() {
            if ( ! copy.http ) return;
            var data = copy.parseResponse();
            copy.callback_func( data, copy.callback_arg );  // call back
        };
        this.http.async( proc );
    }

    this.http.load();

    if ( ! this.callback_func ) {                           // sync mode
        var data = this.parseResponse();
        return data;
    }
};

// ================================================================
//  every child/children into array
JKL.ParseXML.prototype.setOutputArrayAll = function () {
    this.setOutputArray( true );
}
//  a child into scalar, children into array
JKL.ParseXML.prototype.setOutputArrayAuto = function () {
    this.setOutputArray( null );
}
//  every child/children into scalar (first sibiling only)
JKL.ParseXML.prototype.setOutputArrayNever = function () {
    this.setOutputArray( false );
}
//  specified child/children into array, other child/children into scalar
JKL.ParseXML.prototype.setOutputArrayElements = function ( list ) {
    this.setOutputArray( list );
}
//  specify how to treate child/children into scalar/array
JKL.ParseXML.prototype.setOutputArray = function ( mode ) {
    if ( typeof(mode) == "string" ) {
        mode = [ mode ];                // string into array
    }
    if ( mode && typeof(mode) == "object" ) {
        if ( mode.length < 0 ) {
            mode = false;               // false when array == [] 
        } else {
            var hash = {};
            for( var i=0; i<mode.length; i++ ) {
                hash[mode[i]] = true;
            }
            mode = hash;                // array into hashed array
            if ( mode["*"] ) {
                mode = true;            // true when includes "*"
            }
        } 
    } 
    this.usearray = mode;
}

// ================================================================
//  method: parseResponse()

JKL.ParseXML.prototype.parseResponse = function () {
    var root = this.http.documentElement();
    var data = this.parseDocument( root );
    return data;
}

// ================================================================
//  convert from DOM root node to JavaScript Object 
//  method: parseElement( rootElement )

JKL.ParseXML.prototype.parseDocument = function ( root ) {
    // debug.print( "parseDocument: "+root );
    if ( ! root ) return;

    var ret = this.parseElement( root );            // parse root node
    // debug.print( "parsed: "+ret );

    if ( this.usearray == true ) {                  // always into array
        ret = [ ret ];
    } else if ( this.usearray == false ) {          // always into scalar
        //
    } else if ( this.usearray == null ) {           // automatic
        //
    } else if ( this.usearray[root.nodeName] ) {    // specified tag
        ret = [ ret ];
    }

    var json = {};
    json[root.nodeName] = ret;                      // root nodeName
    return json;
};

// ================================================================
//  convert from DOM Element to JavaScript Object 
//  method: parseElement( element )

JKL.ParseXML.prototype.parseElement = function ( elem ) {
    // debug.print( "nodeType: "+JKL.ParseXML.MAP_NODETYPE[elem.nodeType]+" <"+elem.nodeName+">" );

    //  COMMENT_NODE

    if ( elem.nodeType == 7 ) {
        return;
    }

    //  TEXT_NODE CDATA_SECTION_NODE

    if ( elem.nodeType == 3 || elem.nodeType == 4 ) {
        // var bool = elem.nodeValue.match( /[^\\u0000-\\u0020]/ );
        var bool = elem.nodeValue.match( /[^\\x00-\\x20]/ ); // for Safari
        if ( bool == null ) return;     // ignore white spaces
        // debug.print( "TEXT_NODE: "+elem.nodeValue.length+ " "+bool );
        return elem.nodeValue;
    }

    var retval;
    var cnt = {};

    //  parse attributes

    if ( elem.attributes && elem.attributes.length ) {
        retval = {};
        for ( var i=0; i<elem.attributes.length; i++ ) {
            var key = elem.attributes[i].nodeName;
            if ( typeof(key) != "string" ) continue;
            var val = elem.attributes[i].nodeValue;
            if ( ! val ) continue;
            if ( typeof(cnt[key]) == "undefined" ) cnt[key] = 0;
            cnt[key] ++;
            this.addNode( retval, key, cnt[key], val );
        }
    }

    //  parse child nodes (recursive)

    if ( elem.childNodes && elem.childNodes.length ) {
        var textonly = true;
        if ( retval ) textonly = false;        // some attributes exists
        for ( var i=0; i<elem.childNodes.length && textonly; i++ ) {
            var ntype = elem.childNodes[i].nodeType;
            if ( ntype == 3 || ntype == 4 ) continue;
            textonly = false;
        }
        if ( textonly ) {
            if ( ! retval ) retval = "";
            for ( var i=0; i<elem.childNodes.length; i++ ) {
                retval += elem.childNodes[i].nodeValue;
            }
        } else {
            if ( ! retval ) retval = {};
            for ( var i=0; i<elem.childNodes.length; i++ ) {
                var key = elem.childNodes[i].nodeName;
                if ( typeof(key) != "string" ) continue;
                var val = this.parseElement( elem.childNodes[i] );
                if ( ! val ) continue;
                if ( typeof(cnt[key]) == "undefined" ) cnt[key] = 0;
                cnt[key] ++;
                this.addNode( retval, key, cnt[key], val );
            }
        }
    }
    return retval;
};

// ================================================================
//  method: addNode( hash, key, count, value )

JKL.ParseXML.prototype.addNode = function ( hash, key, cnts, val ) {
    if ( this.usearray == true ) {              // into array
        if ( cnts == 1 ) hash[key] = [];
        hash[key][hash[key].length] = val;      // push
    } else if ( this.usearray == false ) {      // into scalar
        if ( cnts == 1 ) hash[key] = val;       // only 1st sibling
    } else if ( this.usearray == null ) {
        if ( cnts == 1 ) {                      // 1st sibling
            hash[key] = val;
        } else if ( cnts == 2 ) {               // 2nd sibling
            hash[key] = [ hash[key], val ];
        } else {                                // 3rd sibling and more
            hash[key][hash[key].length] = val;
        }
    } else if ( this.usearray[key] ) {
        if ( cnts == 1 ) hash[key] = [];
        hash[key][hash[key].length] = val;      // push
    } else {
        if ( cnts == 1 ) hash[key] = val;       // only 1st sibling
    }
};

// ================================================================
//  class: JKL.ParseXML.Text 

JKL.ParseXML.Text = function ( url, query, method ) {
    // debug.print( "new JKL.ParseXML.Text( '"+url+"', '"+query+"', '"+method+"' );" );
    this.http = new JKL.ParseXML.HTTP( url, query, method, true );
    return this;
};

JKL.ParseXML.Text.prototype.parse = JKL.ParseXML.prototype.parse;
JKL.ParseXML.Text.prototype.async = JKL.ParseXML.prototype.async;
JKL.ParseXML.Text.prototype.onerror = JKL.ParseXML.prototype.onerror;

JKL.ParseXML.Text.prototype.parseResponse = function () {
    var data = this.http.responseText();
    return data;
}

// ================================================================
//  class: JKL.ParseXML.JSON

JKL.ParseXML.JSON = function ( url, query, method ) {
    // debug.print( "new JKL.ParseXML.JSON( '"+url+"', '"+query+"', '"+method+"' );" );
    this.http = new JKL.ParseXML.HTTP( url, query, method, true );
    return this;
};

JKL.ParseXML.JSON.prototype.parse = JKL.ParseXML.prototype.parse;
JKL.ParseXML.JSON.prototype.async = JKL.ParseXML.prototype.async;
JKL.ParseXML.JSON.prototype.onerror = JKL.ParseXML.prototype.onerror;

JKL.ParseXML.JSON.prototype.parseResponse = function () {
    var text = this.http.responseText();
    // http://www.antimon2.atnifty.com/2007/01/jklparsexmljson.html
    if ( typeof(text) == 'undefined' ) return;
    if ( ! text.length ) return;
    var data = eval( "("+text+")" );
    return data;
}

// ================================================================
//  class: JKL.ParseXML.DOM

JKL.ParseXML.DOM = function ( url, query, method ) {
    // debug.print( "new JKL.ParseXML.DOM( '"+url+"', '"+query+"', '"+method+"' );" );
    this.http = new JKL.ParseXML.HTTP( url, query, method, false );
    return this;
};

JKL.ParseXML.DOM.prototype.parse = JKL.ParseXML.prototype.parse;
JKL.ParseXML.DOM.prototype.async = JKL.ParseXML.prototype.async;
JKL.ParseXML.DOM.prototype.onerror = JKL.ParseXML.prototype.onerror;

JKL.ParseXML.DOM.prototype.parseResponse = function () {
    var data = this.http.documentElement();
    return data;
}

// ================================================================
//  class: JKL.ParseXML.CSV

JKL.ParseXML.CSV = function ( url, query, method ) {
    // debug.print( "new JKL.ParseXML.CSV( '"+url+"', '"+query+"', '"+method+"' );" );
    this.http = new JKL.ParseXML.HTTP( url, query, method, true );
    return this;
};

JKL.ParseXML.CSV.prototype.parse = JKL.ParseXML.prototype.parse;
JKL.ParseXML.CSV.prototype.async = JKL.ParseXML.prototype.async;
JKL.ParseXML.CSV.prototype.onerror = JKL.ParseXML.prototype.onerror;

JKL.ParseXML.CSV.prototype.parseResponse = function () {
    var text = this.http.responseText();
    var data = this.parseCSV( text );
    return data;
}

JKL.ParseXML.CSV.prototype.parseCSV = function ( text ) {
    text = text.replace( /\\r\\n?/g, "\\n" );              // new line character
    var pos = 0;
    var len = text.length;
    var table = [];
    while( pos<len ) {
        var line = [];
        while( pos<len ) {
            if ( text.charAt(pos) == '"' ) {            // "..." quoted column
                var nextquote = text.indexOf( '"', pos+1 );
                while ( nextquote<len && nextquote > -1 ) {
                    if ( text.charAt(nextquote+1) != '"' ) {
                        break;                          // end of column
                    }
                    nextquote = text.indexOf( '"', nextquote+2 );
                }
                if ( nextquote < 0 ) {
                    // unclosed quote
                } else if ( text.charAt(nextquote+1) == "," ) { // end of column
                    var quoted = text.substr( pos+1, nextquote-pos-1 );
                    quoted = quoted.replace(/""/g,'"');
                    line[line.length] = quoted;
                    pos = nextquote+2;
                    continue;
                } else if ( text.charAt(nextquote+1) == "\\n" || // end of line
                            len==nextquote+1 ) {                // end of file
                    var quoted = text.substr( pos+1, nextquote-pos-1 );
                    quoted = quoted.replace(/""/g,'"');
                    line[line.length] = quoted;
                    pos = nextquote+2;
                    break;
                } else {
                    // invalid column
                }
            }
            var nextcomma = text.indexOf( ",", pos );
            var nextnline = text.indexOf( "\\n", pos );
            if ( nextnline < 0 ) nextnline = len;
            if ( nextcomma > -1 && nextcomma < nextnline ) {
                line[line.length] = text.substr( pos, nextcomma-pos );
                pos = nextcomma+1;
            } else {                                    // end of line
                line[line.length] = text.substr( pos, nextnline-pos );
                pos = nextnline+1;
                break;
            }
        }
        if ( line.length >= 0 ) {
            table[table.length] = line;                 // push line
        }
    }
    if ( table.length < 0 ) return;                     // null data
    return table;
};

// ================================================================
//  class: JKL.ParseXML.CSVmap

JKL.ParseXML.CSVmap = function ( url, query, method ) {
    // debug.print( "new JKL.ParseXML.CSVmap( '"+url+"', '"+query+"', '"+method+"' );" );
    this.http = new JKL.ParseXML.HTTP( url, query, method, true );
    return this;
};

JKL.ParseXML.CSVmap.prototype.parse = JKL.ParseXML.prototype.parse;
JKL.ParseXML.CSVmap.prototype.async = JKL.ParseXML.prototype.async;
JKL.ParseXML.CSVmap.prototype.onerror = JKL.ParseXML.prototype.onerror;
JKL.ParseXML.CSVmap.prototype.parseCSV = JKL.ParseXML.CSV.prototype.parseCSV;

JKL.ParseXML.CSVmap.prototype.parseResponse = function () {
    var text = this.http.responseText();
    var source = this.parseCSV( text );
    if ( ! source ) return;
    if ( source.length < 0 ) return;

    var title = source.shift();                 // first line as title
    var data = [];
    for( var i=0; i<source.length; i++ ) {
        var hash = {};
        for( var j=0; j<title.length && j<source[i].length; j++ ) {
            hash[title[j]] = source[i][j];      // array to map
        }
        data[data.length] = hash;               // push line
    }
    return data;
}

// ================================================================
//  class: JKL.ParseXML.LoadVars

JKL.ParseXML.LoadVars = function ( url, query, method ) {
    // debug.print( "new JKL.ParseXML.LoadVars( '"+url+"', '"+query+"', '"+method+"' );" );
    this.http = new JKL.ParseXML.HTTP( url, query, method, true );
    return this;
};

JKL.ParseXML.LoadVars.prototype.parse = JKL.ParseXML.prototype.parse;
JKL.ParseXML.LoadVars.prototype.async = JKL.ParseXML.prototype.async;
JKL.ParseXML.LoadVars.prototype.onerror = JKL.ParseXML.prototype.onerror;

JKL.ParseXML.LoadVars.prototype.parseResponse = function () {
    var text = this.http.responseText();
    text = text.replace( /\\r\\n?/g, "\\n" );              // new line character
    var hash = {};
    var list = text.split( "&" );
    for( var i=0; i<list.length; i++ ) {
        var eq = list[i].indexOf( "=" );
        if ( eq > -1 ) {
            var key = decodeURIComponent(list[i].substr(0,eq).replace("+","%20"));
            var val = decodeURIComponent(list[i].substr(eq+1).replace("+","%20"));
            hash[key] = val;
        } else {
            hash[list[i]] = "";
        }
    }
    return hash;
};

// ================================================================
//  class: JKL.ParseXML.HTTP
//  constructer: new JKL.ParseXML.HTTP()

JKL.ParseXML.HTTP = function( url, query, method, textmode ) {
    // debug.print( "new JKL.ParseXML.HTTP( '"+url+"', '"+query+"', '"+method+"', '"+textmode+"' );" );
    this.url = url;
    if ( typeof(query) == "string" ) {
        this.query = query;
    } else {
        this.query = "";
    }
    if ( method ) {
        this.method = method;
    } else if ( typeof(query) == "string" ) {
        this.method = "POST";
    } else {
        this.method = "GET";
    }
    this.textmode = textmode ? true : false;
    this.req = null;
    this.xmldom_flag = false;
    this.onerror_func  = null;
    this.callback_func = null;
    this.already_done = null;
    return this;
};

// ================================================================
//  class variables

JKL.ParseXML.HTTP.REQUEST_TYPE  = "application/x-www-form-urlencoded";
JKL.ParseXML.HTTP.ACTIVEX_XMLDOM  = "Microsoft.XMLDOM";  // Msxml2.DOMDocument.5.0
JKL.ParseXML.HTTP.ACTIVEX_XMLHTTP = "Microsoft.XMLHTTP"; // Msxml2.XMLHTTP.3.0
JKL.ParseXML.HTTP.EPOCH_TIMESTAMP = "Thu, 01 Jun 1970 00:00:00 GMT"

// ================================================================

JKL.ParseXML.HTTP.prototype.onerror = JKL.ParseXML.prototype.onerror;
JKL.ParseXML.HTTP.prototype.async = function( func ) {
    this.async_func = func;
}

// ================================================================
//  [IE+IXMLDOMElement]
//      XML     text/xml            OK
//      XML     application/rdf+xml OK
//      TEXT    text/plain          NG
//      TEXT    others              NG
//  [IE+IXMLHttpRequest]
//      XML     text/xml            OK
//      XML     application/rdf+xml NG
//      TEXT    text/plain          OK
//      TEXT    others              OK
//  [Firefox+XMLHttpRequest]
//      XML     text/xml            OK
//      XML     application/rdf+xml OK (overrideMimeType)
//      TEXT    text/plain          OK
//      TEXT    others              OK (overrideMimeType)
//  [Opera+XMLHttpRequest]
//      XML     text/xml            OK
//      XML     application/rdf+xml OK
//      TEXT    text/plain          OK
//      TEXT    others              OK
// ================================================================

JKL.ParseXML.HTTP.prototype.load = function() {
    // create XMLHttpRequest object
    if ( window.ActiveXObject ) {                           // IE5.5,6,7
        var activex = JKL.ParseXML.HTTP.ACTIVEX_XMLHTTP;    // IXMLHttpRequest
        if ( this.method == "GET" && ! this.textmode ) {
            // use IXMLDOMElement to accept any mime types
            // because overrideMimeType() is not available on IE6
            activex = JKL.ParseXML.HTTP.ACTIVEX_XMLDOM;     // IXMLDOMElement
        }
        // debug.print( "new ActiveXObject( '"+activex+"' )" );
        this.req = new ActiveXObject( activex );
    } else if ( window.XMLHttpRequest ) {                   // Firefox, Opera, iCab
        // debug.print( "new XMLHttpRequest()" );
        this.req = new XMLHttpRequest();
    }

    // async mode when call back function is specified
    var async_flag = this.async_func ? true : false;
    // debug.print( "async: "+ async_flag );

    // open for XMLHTTPRequest (not for IXMLDOMElement)
    if ( typeof(this.req.send) != "undefined" ) {
        // debug.print( "open( '"+this.method+"', '"+this.url+"', "+async_flag+" );" );
        this.req.open( this.method, this.url, async_flag );
    }

//  // If-Modified-Since: Thu, 01 Jun 1970 00:00:00 GMT
//  if ( typeof(this.req.setRequestHeader) != "undefined" ) {
//      // debug.print( "If-Modified-Since"+JKL.ParseXML.HTTP.EPOCH_TIMESTAMP );
//      this.req.setRequestHeader( "If-Modified-Since", JKL.ParseXML.HTTP.EPOCH_TIMESTAMP );
//  }

    // Content-Type: application/x-www-form-urlencoded (request header)
    // Some server does not accept without request content-type.
    if ( typeof(this.req.setRequestHeader) != "undefined" ) {
        // debug.print( "Content-Type: "+JKL.ParseXML.HTTP.REQUEST_TYPE+" (request)" );
        this.req.setRequestHeader( "Content-Type", JKL.ParseXML.HTTP.REQUEST_TYPE );
    }

    // Content-Type: text/xml (response header)
    // FireFox does not accept other mime types like application/rdf+xml etc.
    if ( typeof(this.req.overrideMimeType) != "undefined" && ! this.textmode ) {
        // debug.print( "Content-Type: "+JKL.ParseXML.MIME_TYPE_XML+" (response)" );
        this.req.overrideMimeType( JKL.ParseXML.MIME_TYPE_XML );
    }

    // set call back handler when async mode
    if ( async_flag ) {
        var copy = this;
        copy.already_done = false;                  // not parsed yet
        var check_func = function () {
            if ( copy.req.readyState != 4 ) return;
            // debug.print( "readyState(async): "+copy.req.readyState );
            var succeed = copy.checkResponse();
            // debug.print( "checkResponse(async): "+succeed );
            if ( ! succeed ) return;                // failed
            if ( copy.already_done ) return;        // parse only once
            copy.already_done = true;               // already parsed
            copy.async_func();                      // call back async
        };
        this.req.onreadystatechange = check_func;
        // for document.implementation.createDocument
        // this.req.onload = check_func;
    }

    // send the request and query string
    if ( typeof(this.req.send) != "undefined" ) {
        // debug.print( "XMLHTTPRequest: send( '"+this.query+"' );" );
        this.req.send( this.query );                        // XMLHTTPRequest
    } else if ( typeof(this.req.load) != "undefined" ) {
        // debug.print( "IXMLDOMElement: load( '"+this.url+"' );" );
        this.req.async = async_flag;
        this.req.load( this.url );                          // IXMLDOMElement
    }

    // just return when async mode
    if ( async_flag ) return;

    var succeed = this.checkResponse();
    // debug.print( "checkResponse(sync): "+succeed );
}

// ================================================================
//  method: checkResponse()

JKL.ParseXML.HTTP.prototype.checkResponse = function() {
    // parseError on IXMLDOMElement
    if ( this.req.parseError && this.req.parseError.errorCode != 0 ) {
        // debug.print( "parseError: "+this.req.parseError.reason );
        if ( this.onerror_func ) this.onerror_func( this.req.parseError.reason );
        return false;                       // failed
    }

    // HTTP response code
    if ( this.req.status-0 > 0 &&
         this.req.status != 200 &&          // OK
         this.req.status != 206 &&          // Partial Content
         this.req.status != 304 ) {         // Not Modified
        // debug.print( "status: "+this.req.status );
        if ( this.onerror_func ) this.onerror_func( this.req.status );
        return false;                       // failed
    }

    return true;                            // succeed
}

// ================================================================
//  method: documentElement()
//  return: XML DOM in response body

JKL.ParseXML.HTTP.prototype.documentElement = function() {
    // debug.print( "documentElement: "+this.req );
    if ( ! this.req ) return;
    if ( this.req.responseXML ) {
        return this.req.responseXML.documentElement;    // XMLHTTPRequest
    } else {
        return this.req.documentElement;                // IXMLDOMDocument
    }
}

// ================================================================
//  method: responseText()
//  return: text string in response body

JKL.ParseXML.HTTP.prototype.responseText = function() {
    // debug.print( "responseText: "+this.req );
    if ( ! this.req ) return;

    //  Safari and Konqueror cannot understand the encoding of text files.
    if ( navigator.appVersion.match( "KHTML" ) ) {
        var esc = escape( this.req.responseText );
//        debug.print( "escape: "+esc );
        if ( ! esc.match("%u") && esc.match("%") ) {
            return decodeURIComponent(esc);
        }
    }

    return this.req.responseText;
}

// ================================================================
//  http://msdn.microsoft.com/library/en-us/xmlsdk/html/d051f7c5-e882-42e8-a5b6-d1ce67af275c.asp
// ================================================================
EOF;
}

function getLoginP(){
	$me = $_SERVER["SCRIPT_NAME"];
	return <<<EOF
<div class="container"> 
<div class="header"> 
	<h1> 
		<a href="${me}" class="title">OneSQLiteAdmin</a>
	</h1> 
</div> 
 
	<h2>ログイン</h2> 
	<form method="post" action="${me}"> 
		<p> 
			<label for="onedbadmin_username">User:</label> 
			<input type="text" name="onedbadmin_username" id="onedbadmin_username" class="textinput" /> 
		</p> 
		<p> 
			<label for="onedbadmin_password">Password:</label> 
			<input type="password" name="onedbadmin_password" id="onedbadmin_password" class="textinput" /> 
		</p> 
		<p><input type="submit" class="button" value="Enter" /></p> 
	</form> 
</div> 
EOF;

}

function scriptTag($str_script){
	return <<<EOF
<script type="text/javascript">
<!--
${str_script}
//-->
</script>
EOF;
}

/*
 *フレームの外側用
 */
function buildHtml($body , $title="", $head=""){
	if(empty($title)){
		$title="OneSQLiteAdmin";
	}else{
		$title="OneSQLiteAdmin - ".$title;
	}
	$result = <<<EOF
<!doctype HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html lang="ja">
<head>
<meta name="robots" content="noindex">
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta name="content-language" content="ja">
<link rel="shortcut icon" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAALAQMAAACTYuVlAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAAAZQTFRFAAAA////pdmf3QAAABh0RVh0U29mdHdhcmUAUGFpbnQuTkVUIFYzLjM2aCbNIQAAACRJREFUCNdjOJDAsH8Bg4MDQ/0BBp8DDKEODCFgEsgGijQoAAC0HAp0htmWJwAAAABJRU5ErkJggg==" />
<link rel="stylesheet" type="text/css" href="?s=resetcss" media="all">
<link rel="stylesheet" type="text/css" href="?s=css" media="all">
<!--[if lt IE 7]> 
<link rel="stylesheet" href="?s=iecss" type="text/css" />
<![endif]-->
<title>${title}</title>
<script src="?s=jkl-parsexmlJs" type="text/javascript"></script>
<script src="?s=js" type="text/javascript"></script>
{$head}</head>
<body>
EOF;
	$result .= $body;
	$result .= "</body></html>";
	return $result;
}

function formatBytes($bytes, $precision = 2) { 
    $units = array('B', 'KB', 'MB', 'GB', 'TB'); 
   
    $bytes = max($bytes, 0); 
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024)); 
    $pow = min($pow, count($units) - 1); 
   
    $bytes /= pow(1024, $pow); 
   
    return round($bytes, $precision) . ' ' . $units[$pow]; 
} 


function formatperms($str){
	$perms = $str;
	
	if (($perms & 0xC000) == 0xC000) {
	    // ソケット
	    $info = 's';
	} elseif (($perms & 0xA000) == 0xA000) {
	    // シンボリックリンク
	    $info = 'l';
	} elseif (($perms & 0x8000) == 0x8000) {
	    // 通常のファイル
	    $info = '-';
	} elseif (($perms & 0x6000) == 0x6000) {
	    // ブロックスペシャルファイル
	    $info = 'b';
	} elseif (($perms & 0x4000) == 0x4000) {
	    // ディレクトリ
	    $info = 'd';
	} elseif (($perms & 0x2000) == 0x2000) {
	    // キャラクタスペシャルファイル
	    $info = 'c';
	} elseif (($perms & 0x1000) == 0x1000) {
	    // FIFO パイプ
	    $info = 'p';
	} else {
	    // 不明
	    $info = 'u';
	}
	
	// 所有者
	$info .= (($perms & 0x0100) ? 'r' : '-');
	$info .= (($perms & 0x0080) ? 'w' : '-');
	$info .= (($perms & 0x0040) ?
	            (($perms & 0x0800) ? 's' : 'x' ) :
	            (($perms & 0x0800) ? 'S' : '-'));
	
	// グループ
	$info .= (($perms & 0x0020) ? 'r' : '-');
	$info .= (($perms & 0x0010) ? 'w' : '-');
	$info .= (($perms & 0x0008) ?
	            (($perms & 0x0400) ? 's' : 'x' ) :
	            (($perms & 0x0400) ? 'S' : '-'));
	
	// 全体
	$info .= (($perms & 0x0004) ? 'r' : '-');
	$info .= (($perms & 0x0002) ? 'w' : '-');
	$info .= (($perms & 0x0001) ?
	            (($perms & 0x0200) ? 't' : 'x' ) :
	            (($perms & 0x0200) ? 'T' : '-'));
	
	return $info;
}
