package onig4j;

import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class OnigCaptureTreeNodeTest {
    
    @Test
    public void getChildNodes() throws InterruptedException {
        OnigRegex regex = new OnigRegex("a(.*)b|[e-f]+");
        OnigRegion region = new OnigRegion();
        
        int ret = regex.search("abcdefg", region);
        assertNull(region.getCaptureTreeNode());
        
        OnigSyntaxType syntax = OnigSyntaxType.ONIG_SYNTAX_DEFAULT.clone();
        syntax.setOperator2(syntax.getOperator2() | OnigSyntaxType.ONIG_SYN_OP2_ATMARK_CAPTURE_HISTORY);
        
        regex = new OnigRegex("(?@a)*", syntax);
        ret = regex.search("abcdefg", region);

        OnigCaptureTreeNode capture = region.getCaptureTreeNode();
        assertNotNull(capture);
        OnigCaptureTreeNode[] children = capture.getChildNodes();
        assertNotNull(children);
        assertTrue(children.length > 0);
        
        for (final OnigCaptureTreeNode node : children) {
            assertNotNull(node);
            final OnigCaptureTreeNode[] nodes = node.getChildNodes();
            assertNotNull(nodes);
            assertEquals(0, nodes.length);
        }
        
        region.close();
        syntax.close();
        regex.close();
    }

    @Test(expected = IllegalStateException.class)
    public void getChildNodesThrowIllegalStateException() throws InterruptedException {
        OnigSyntaxType syntax = OnigSyntaxType.ONIG_SYNTAX_DEFAULT.clone();
        syntax.setOperator2(syntax.getOperator2() | OnigSyntaxType.ONIG_SYN_OP2_ATMARK_CAPTURE_HISTORY);
        
        OnigRegex regex = new OnigRegex("(?@a)*", syntax);
        OnigRegion region = new OnigRegion();
        regex.search("abcdefg", region);
        syntax.close();

        OnigCaptureTreeNode capture = region.getCaptureTreeNode();
        assertNotNull(capture);
        OnigCaptureTreeNode[] children = capture.getChildNodes();
        assertNotNull(children);
        assertTrue(children.length > 0);
        regex.close();
        region.close();
        
        children = capture.getChildNodes();        
    }
    
}