package onig4j.java.util.regex;

import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class MatcherTest {

    @Test
    public void start() {
        final String regex = ",";
        final String input = "abc,ｄ,eｆg,h,ｉ,,j,,,,ｋ,,,";
        
        final java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        assertTrue(matcher.find());
        assertEquals(3, matcher.start());
        
        Pattern pattern = Pattern.compile(regex);
        final Matcher matcher2 = pattern.matcher(input);
        assertTrue(matcher2.find());
        assertEquals(matcher.start(), matcher2.start());

        assertEquals(matcher.groupCount(), matcher2.groupCount());
        assertEquals(matcher.group(), matcher2.group());
        
        for (int i = 0; i < matcher.groupCount(); ++i) {
            assertEquals(matcher.start(i), matcher2.start(2));
            assertEquals(matcher.end(i), matcher2.end(2));
            assertEquals(matcher.group(i), matcher2.group(i));
        }
        
        matcher2.reset();
        assertEquals(0, matcher2.groupCount());
    }

    @Test
    public void group() {
        final int[] options
                = new int[] {
                        java.util.regex.Pattern.MULTILINE | java.util.regex.Pattern.UNIX_LINES,
                        java.util.regex.Pattern.MULTILINE,
                    };
        final String regex = "[^$]";
//        final String regex = "(?!$)";
//        final String regex = "[^(?=(\r|\n|\u0085|\u2028|\u2029|$))]";
//        final String regex = "^(?=[\r\u0085\u2028\u2029]|(?<!\r)\n|\\z)";
        final String input = "\r\nあいうえお\nかきくけこ\r\nさしすせそ\rたちつてと";
        
        for (final int option : options) {
            java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex, option).matcher(input);
            assertTrue(matcher.find());
            final String group = matcher.group();
            assertEquals(0, matcher.start());
//            assertEquals(1, matcher.end());

            Pattern pattern = Pattern.compile(regex, option);
            Matcher matcher2 = pattern.matcher(input);
            assertTrue(matcher2.find());
            assertEquals(matcher.start(), matcher2.start());
            // MEMO 行末記号を置き換えた場合 [^$] での検索結果が一致しないためテストに失敗する

            assertEquals(matcher.groupCount(), matcher2.groupCount());
            assertEquals(group, matcher2.group());
            assertEquals(matcher.start(), matcher2.start());
            assertEquals(matcher.end(), matcher2.end());

            for (int i = 0; i < matcher.groupCount(); ++i) {
                assertEquals(matcher.start(i), matcher2.start(2));
                assertEquals(matcher.end(i), matcher2.end(2));
                assertEquals(matcher.group(i), matcher2.group(i));
            }
        }
    }

    @Test
    public void CANON_EQ() {
        final String regex = "a\u030A";
        final String input = "あいうえお\u00E5かきくけこ";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        assertFalse(matcher.find());
        
        matcher = java.util.regex.Pattern.compile(regex, java.util.regex.Pattern.CANON_EQ).matcher(input);
        assertTrue(matcher.find());
        assertEquals(5, matcher.start());
        
        Pattern pattern2 = Pattern.compile(regex);
        final Matcher matcher2 = pattern2.matcher(input);
        assertFalse(matcher2.find());
        
        Pattern pattern3 =  Pattern.compile(regex, Pattern.CANON_EQ);
        final Matcher matcher3 = pattern3.matcher(input);
        assertTrue(matcher3.find());
        assertEquals(matcher.start(), matcher3.start());
    }
    
    @Test
    public void replaceAll() {
        final String regex = "a*b";
        final String input = "aabfooaabfooabfoob";
        
        final String[] values = java.util.regex.Pattern.compile(regex).split(input);
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        assertEquals("-foo-foo-foo-", matcher.replaceAll("-"));
        
        Pattern pattern = Pattern.compile(regex);
        final String[] values2 = pattern.split(input);
        final Matcher matcher2 = pattern.matcher(input);
        assertEquals("-foo-foo-foo-", matcher2.replaceAll("-"));
    }
    
    @Test
    public void replaceAll2() {
        final String regex = "(\n|\r\n|\r|\u0085|\u2028|\u2029)";
        final String input = "あいうえお\nかきくけこ\r\nさしすせそ\rたちつてと\u0085なにぬねの\u2028はひふへほ\u2029まみむめも";
//        final String input = "aaa\r\nbbb";
        final String replacement = "<br/>\\n\\$0";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        final String replaced = matcher.replaceAll(replacement);
        System.out.println("replaceAll2:replaced :[" + replaced + "]\n");
        
        Pattern pattern = Pattern.compile(regex);
        final Matcher matcher2 = pattern.matcher(input);
        final String replaced2 = matcher2.replaceAll(replacement);
        System.out.println("replaceAll2:replaced2:[" + replaced2 + "]\n");
        
        assertEquals(replaced, replaced2);
    }
    
    @Test
    public void replaceAll3() {
        final String regex = "(\n|\r\n|\r|\u0085|\u2028|\u2029)";
        final String input = "あいうえお\nかきくけこ\r\nさしすせそ\rたちつてと\u0085なにぬねの\u2028はひふへほ\u2029まみむめも";
        final String replacement = "<br/>\\n\\\\$0";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        final String replaced = matcher.replaceAll(replacement);
        System.out.println("replaceAll3:replaced :[" + replaced + "]\n");
        
        Pattern pattern = Pattern.compile(regex);
        final Matcher matcher2 = pattern.matcher(input);
        final String replaced2 = matcher2.replaceAll(replacement);
        System.out.println("replaceAll3:replaced2:[" + replaced2 + "]\n");
        
        assertEquals(replaced, replaced2);
    }
    
    @Test
    public void replaceAll4() {
        final String regex = "(\n|\r\n|\r|\u0085|\u2028|\u2029)";
        final String input = "あいうえお\nかきくけこ\r\nさしすせそ\rたちつてと\u0085なにぬねの\u2028はひふへほ\u2029まみむめも";
        final String replacement = "<br/>\\\\n\\\\$0";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        final String replaced = matcher.replaceAll(replacement);
        System.out.println("replaceAll4:replaced :[" + replaced + "]\n");
        
        Pattern pattern = Pattern.compile(regex);
        final Matcher matcher2 = pattern.matcher(input);
        final String replaced2 = matcher2.replaceAll(replacement);
        System.out.println("replaceAll4:replaced2:[" + replaced2 + "]\n");
        
        assertEquals(replaced, replaced2);
    }
    
    @Test
    public void replaceAll5() {
        final String regex = "(\n|\r\n|\r|\u0085|\u2028|\u2029)";
        final String input = "あいうえお\nかきくけこ\r\nさしすせそ\rたちつてと\u0085なにぬねの\u2028はひふへほ\u2029まみむめも";
        final String replacement = "<br/>\\n";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        final String replaced = matcher.replaceAll(replacement);
        System.out.println("replaceAll5:replaced :[" + replaced + "]\n");
        
        Pattern pattern = Pattern.compile(regex);
        final Matcher matcher2 = pattern.matcher(input);
        final String replaced2 = matcher2.replaceAll(replacement);
        System.out.println("replaceAll5:replaced2:[" + replaced2 + "]\n");
        
        assertEquals(replaced, replaced2);
    }
    
    @Test
    public void replaceAll6() {
        final String regex = "$";
        final String input = "あいうえお\nかきくけこ\r\nさしすせそ\rたちつてと\u0085なにぬねの\u2028はひふへほ\u2029まみむめも";
        final String replacement = "<br/>\\n";
        
        java.util.regex.Matcher matcher
                = java.util.regex.Pattern.compile(regex, java.util.regex.Pattern.MULTILINE).matcher(input);
        final String replaced = matcher.replaceAll(replacement);
        System.out.println("replaceAll6:replaced :[" + replaced + "]\n");
        
        Pattern pattern = Pattern.compile(regex, Pattern.MULTILINE);
        final Matcher matcher2 = pattern.matcher(input);
        final String replaced2 = matcher2.replaceAll(replacement);
        System.out.println("replaceAll6:replaced2:[" + replaced2 + "]\n");
        
        assertEquals(replaced, replaced2);
    }
    
    @Test
    public void replaceFirst() {
        final String regex = "dog";
        final String input = "zzzdogzzzdogzzz";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        assertEquals("zzzcatzzzdogzzz", matcher.replaceFirst("cat"));
        
        Pattern pattern = Pattern.compile(regex);
        final Matcher matcher2 = pattern.matcher(input);
        assertEquals("zzzcatzzzdogzzz", matcher2.replaceFirst("cat"));
    }
    
    @Test
    public void replaceFirst2() {
        final String regex = "dog";
        final String input = "zzzdogzzzdogzzz";
        final String replacement = "cat_and_$0";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        final String replaced = matcher.replaceFirst(replacement);
        assertEquals("zzzcat_and_dogzzzdogzzz", replaced);
        
        Pattern pattern = Pattern.compile(regex);
        final Matcher matcher2 = pattern.matcher(input);
        assertEquals(replaced, matcher2.replaceFirst(replacement));
    }
    
    @Test
    public void quoteReplacement() {
        final String replacement = "cat_\\and_\\$0\n";
        
        final String quoted = java.util.regex.Matcher.quoteReplacement(replacement);
        System.out.println("quoteReplacement:quoted :[" + quoted + "]\n");
//        assertEquals("zzzcat_and_dogzzzdogzzz", replaced);
        
        assertEquals(quoted, Matcher.quoteReplacement(replacement));
    }
    
    @Test
    public void useTransparentBounds() {
        final String regex = "123(?=45)";
        final String regex2 = "(?<=12)345";
        final String input = "01234512345";
        
        java.util.regex.Matcher matcher = java.util.regex.Pattern.compile(regex).matcher(input);
        matcher.useTransparentBounds(true);
        matcher.useAnchoringBounds(false);

        assertTrue(matcher.find());
        assertEquals(1, matcher.start());
        assertEquals("123", matcher.group());

        matcher.region(1, 4);
        assertTrue(matcher.find());
        assertEquals(1, matcher.start());
        assertEquals("123", matcher.group());
        
        matcher.useTransparentBounds(false);
        matcher.region(1, 4);
        assertFalse(matcher.find());
        
        matcher = java.util.regex.Pattern.compile(regex2).matcher(input);
        matcher.useAnchoringBounds(false);
        matcher.region(3, 7);
        assertFalse(matcher.find());
        
        matcher.useTransparentBounds(true);
        
        assertTrue(matcher.find());
        assertEquals("345", matcher.group());
        
        matcher.region(3, input.length());
        assertTrue(matcher.find());
        assertEquals(3, matcher.start());
        assertEquals("345", matcher.group());
        
        matcher.region(4, input.length());
        assertTrue(matcher.find());
        assertEquals(8, matcher.start());
        assertEquals("345", matcher.group());

        matcher.useTransparentBounds(false);
        matcher.region(3, 7);
        assertFalse(matcher.find());
        
        Matcher matcher2 = Pattern.compile(regex).matcher(input);
        assertTrue(matcher2.find());
        assertEquals(1, matcher2.start());
        assertEquals("123", matcher2.group());
 
        matcher2.region(1, 4);
        assertFalse(matcher2.find());
        matcher2.reset();
        
        matcher2.useTransparentBounds(true);
        matcher2.useAnchoringBounds(false);

        assertTrue(matcher2.find());
        assertEquals(1, matcher2.start());
        assertEquals("123", matcher2.group());

         matcher2.region(1, 4);
        assertTrue(matcher2.find());
        assertEquals(1, matcher2.start());
        assertEquals("123", matcher2.group());
        
        onig4j.OnigRegex onig = new onig4j.OnigRegex(regex2);
        int ret = onig.search(input, 3);
        assertEquals(3, ret);
        
        matcher2 = Pattern.compile(regex2).matcher(input);
        matcher2.useAnchoringBounds(false);
//        matcher2.region(3, 7);
//        assertFalse(matcher2.find());
        
        matcher2.useTransparentBounds(true);
        
        assertTrue(matcher2.find());
        assertEquals("345", matcher2.group());
        
        matcher2.region(3, input.length());
        assertTrue(matcher2.find());
        assertEquals(3, matcher2.start());
        assertEquals("345", matcher2.group());
        
        matcher2.region(4, input.length());
        assertTrue(matcher2.find());
        assertEquals(8, matcher2.start());
        assertEquals("345", matcher2.group());
        
        matcher2.useTransparentBounds(false);
        matcher2.region(3, 7);
        assertFalse(matcher2.find());
    }
    
    @Test
    public void hitEnd() {
        final String regexList[] = new String[] { "aa", "a+", "a*" };
        final String inputList[] = new String[] { "aa", "aaa", "aaaa" };
        
        int i = 0;
        for (final String regex : regexList) {
            for (final String input : inputList) {
                final java.util.regex.Matcher matcher
                        = java.util.regex.Pattern.compile(regex).matcher(input);
                assertTrue(matcher.find());
                System.out.println("matcher: " + matcher);
                if ("aa".equals(regex)) {
                    assertEquals("aa", matcher.group());
                    assertFalse(matcher.hitEnd());
                    assertEquals(2, matcher.end());
                } else {
                    assertEquals(input, matcher.group());
                    assertTrue(matcher.hitEnd());
                    assertEquals(input.length(), matcher.end());
                }
                
                final Matcher matcher2 = Pattern.compile(regex).matcher(input);
                assertTrue(matcher2.find());
                System.out.println("matcher2: " + matcher2);
                if ("aa".equals(regex)) {
                    assertEquals("aa", matcher2.group());
                    
//                    assertFalse(matcher2.hitEnd());
                    // TODO 本来は常にfalseになるべきだが現在の実装では常にfalseにならない為の暫定処置
                    if ("aa".equals(input)) {
                        assertTrue(matcher2.hitEnd());
                    } else {
                        assertFalse(matcher2.hitEnd());
                    }
                    assertEquals(2, matcher2.end());
                } else {
                    assertEquals(input, matcher2.group());
                    assertTrue(matcher2.hitEnd());
                    assertEquals(input.length(), matcher2.end());
                }
            }
        }
    }
    
    @Test
    public void matches() {
        final String regex = "123[0-9]*";
        final String input = "12345";
        
        final java.util.regex.Matcher matcher
                = java.util.regex.Pattern.compile(regex).matcher(input);
        assertTrue(matcher.find());
        assertTrue(matcher.matches());
        assertFalse(matcher.find());
        
        final Matcher matcher2 = Pattern.compile(regex).matcher(input);
        assertTrue(matcher2.find());
        assertTrue(matcher2.matches());
        assertFalse(matcher2.find());
        
        final String inputMismatch = "12345６";
        
        matcher.reset(inputMismatch);
        assertTrue(matcher.find());
        assertFalse(matcher.matches());
//        assertEquals(5, matcher.end());
        // MEMO: matches()メソッドは失敗していてもマッチ位置は5に進んでいるため後続のfind()は失敗する
        assertFalse(matcher.find());
        
        matcher2.reset(inputMismatch);
        assertTrue(matcher2.find());
        assertFalse(matcher2.matches());
        assertFalse(matcher2.find());
    }
    
    @Test
    public void lookingAt() {
        final String regex = "123[0-9]*";
        final String input = "12345";
        
        final java.util.regex.Matcher matcher
                = java.util.regex.Pattern.compile(regex).matcher(input);
        assertTrue(matcher.find());
        assertTrue(matcher.lookingAt());
        assertFalse(matcher.find());
        
        final Matcher matcher2 = Pattern.compile(regex).matcher(input);
        assertTrue(matcher2.find());
        assertTrue(matcher2.lookingAt());
        assertFalse(matcher2.find());
        
        final String input2 = "12345６";
        
        matcher.reset(input2);
        assertTrue(matcher.find());
        assertTrue(matcher.lookingAt());
        assertFalse(matcher.find());
        
        matcher2.reset(input2);
        assertTrue(matcher2.find());
        assertTrue(matcher2.lookingAt());
        assertFalse(matcher2.find());
    }
    
    @Test
    public void useAnchoringBounds() {
        final String regex = "^.*\n";
        final String input = "あいうえお\nかきくけこ\n";
        
        final java.util.regex.Matcher matcher
                = java.util.regex.Pattern.compile(regex).matcher(input);
        assertTrue(matcher.hasAnchoringBounds());
        System.out.println(matcher);
        assertTrue(matcher.find());
        assertEquals("あいうえお\n", matcher.group());

        matcher.region(matcher.end(), matcher.regionEnd());
        System.out.println(matcher);
        assertTrue(matcher.find(0));
        assertEquals("あいうえお\n", matcher.group());
        matcher.region(matcher.end(), matcher.regionEnd());
        
        assertTrue(matcher.find());
        assertEquals("かきくけこ\n", matcher.group());

        matcher.useAnchoringBounds(false);
        assertEquals("かきくけこ\n", matcher.group());

        matcher.reset();
        System.out.println(matcher);
        assertTrue(matcher.find());
        assertEquals("あいうえお\n", matcher.group());
        matcher.region(matcher.end(), matcher.regionEnd());
        assertFalse(matcher.find());
        
        final Matcher matcher2 = Pattern.compile(regex).matcher(input);
        assertTrue(matcher2.hasAnchoringBounds());
        System.out.println(matcher2);
        assertTrue(matcher2.find());
        assertEquals("あいうえお\n", matcher2.group());
        matcher2.region(matcher2.end(), matcher2.regionEnd());
        assertTrue(matcher2.find());
        assertEquals("かきくけこ\n", matcher2.group());
        
        matcher2.useAnchoringBounds(false);
        assertEquals("かきくけこ\n", matcher2.group());
        
        matcher2.reset();
        System.out.println(matcher2);
        assertTrue(matcher2.find());
        assertEquals("あいうえお\n", matcher2.group());
        matcher2.region(matcher2.end(), matcher2.regionEnd());
        assertFalse(matcher.find());
    }
}